/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript;

import de.peeeq.wurstscript.SyntacticSugar;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.antlr.JassParser;
import de.peeeq.wurstscript.antlr.WurstParser;
import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.JassToplevelDeclaration;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.attributes.CompilationUnitInfo;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.jass.AntlrJassParseTreeTransformer;
import de.peeeq.wurstscript.jass.ExtendedJassLexer;
import de.peeeq.wurstscript.jurst.AntlrJurstParseTreeTransformer;
import de.peeeq.wurstscript.jurst.ExtendedJurstLexer;
import de.peeeq.wurstscript.jurst.antlr.JurstParser;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.parser.antlr.AntlrWurstParseTreeTransformer;
import de.peeeq.wurstscript.parser.antlr.ExtendedWurstLexer;
import de.peeeq.wurstscript.utils.LineOffsets;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;

public class WurstParser {
    private static final int MAX_SYNTAX_ERRORS = 15;
    private final ErrorHandler errorHandler;
    private final WurstGui gui;
    private boolean removeSugar = true;
    private static final Pattern pattern = Pattern.compile("\\s*");

    public WurstParser(ErrorHandler errorHandler, WurstGui gui) {
        this.errorHandler = errorHandler;
        this.gui = gui;
    }

    public void setRemoveSugar(boolean removeSugar) {
        this.removeSugar = removeSugar;
    }

    public CompilationUnit parse(Reader reader, String source, boolean hasCommonJ) {
        return this.parseWithAntlr(reader, source, hasCommonJ);
    }

    private CompilationUnit parseWithAntlr(Reader reader, String source, boolean hasCommonJ) {
        try {
            CodePointCharStream input = CharStreams.fromReader((Reader)reader);
            final ExtendedWurstLexer lexer = new ExtendedWurstLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            de.peeeq.wurstscript.antlr.WurstParser parser = new de.peeeq.wurstscript.antlr.WurstParser((TokenStream)tokens);
            BaseErrorListener l = new BaseErrorListener((CharStream)input, source){
                int errorCount = 0;
                final /* synthetic */ CharStream val$input;
                final /* synthetic */ String val$source;
                {
                    this.val$input = charStream;
                    this.val$source = string;
                }

                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                    int posStop;
                    int pos;
                    NoViableAltException ne;
                    if (e instanceof NoViableAltException && (ne = (NoViableAltException)e).getStartToken().getType() == 135) {
                        msg = "Hotdoc comment is in invalid position, it can only appear before function definitions, classes, and other elements that can be documented.";
                        offendingSymbol = ne.getStartToken();
                    }
                    LineOffsets offsets = lexer.getLineOffsets();
                    if (offendingSymbol instanceof Token) {
                        Token token = (Token)offendingSymbol;
                        pos = token.getStartIndex();
                        posStop = token.getStopIndex() + 1;
                    } else {
                        pos = offsets.get(line) + charPositionInLine;
                        posStop = pos + 1;
                    }
                    if (posStop >= this.val$input.size()) {
                        posStop = this.val$input.size() - 1;
                    }
                    Matcher matcher = pattern.matcher(this.val$input.getText(new Interval(pos, posStop)));
                    while (pos > 0 && matcher.matches()) {
                        --pos;
                    }
                    CompileError err = new CompileError(new WPos(this.val$source, offsets, pos, posStop), msg);
                    WurstParser.this.gui.sendError(err);
                    ++this.errorCount;
                    if (this.errorCount > 15) {
                        throw new TooManyErrorsException();
                    }
                }
            };
            lexer.setErrorListener((ANTLRErrorListener)l);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)l);
            WurstParser.CompilationUnitContext cu = parser.compilationUnit();
            if (lexer.getTabWarning() != null) {
                CompileError warning = lexer.getTabWarning();
                warning = new CompileError(warning.getSource().withFile(source), warning.getMessage(), CompileError.ErrorType.WARNING);
                this.gui.sendError(warning);
            }
            CompilationUnit root = new AntlrWurstParseTreeTransformer(source, this.errorHandler, lexer.getLineOffsets(), lexer.getCommentTokens(), true).transform(cu);
            if (this.removeSugar) {
                this.removeSyntacticSugar(root, hasCommonJ);
            }
            root.getCuInfo().setIndentationMode(lexer.getIndentationMode());
            return root;
        }
        catch (IOException e) {
            WLogger.severe(e);
            throw new Error(e);
        }
        catch (TooManyErrorsException e) {
            WLogger.info("Stopped parsing file " + source + ", too many errors");
            return this.emptyCompilationUnit();
        }
    }

    public CompilationUnit parseJurst(Reader reader, String source, boolean hasCommonJ) {
        return this.parseJurstWithAntlr(reader, source, hasCommonJ);
    }

    private CompilationUnit parseJurstWithAntlr(Reader reader, String source, boolean hasCommonJ) {
        try {
            CodePointCharStream input = CharStreams.fromReader((Reader)reader);
            final ExtendedJurstLexer lexer = new ExtendedJurstLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            JurstParser parser = new JurstParser((TokenStream)tokens);
            BaseErrorListener l = new BaseErrorListener((CharStream)input, source){
                int errorCount = 0;
                final /* synthetic */ CharStream val$input;
                final /* synthetic */ String val$source;
                {
                    this.val$input = charStream;
                    this.val$source = string;
                }

                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                    int posStop;
                    int pos;
                    LineOffsets offsets = lexer.getLineOffsets();
                    if (offendingSymbol instanceof Token) {
                        Token token = (Token)offendingSymbol;
                        pos = token.getStartIndex();
                        posStop = token.getStopIndex() + 1;
                    } else {
                        pos = offsets.get(line) + charPositionInLine;
                        posStop = pos + 1;
                    }
                    msg = "line " + line + ": " + (String)msg;
                    Matcher matcher = pattern.matcher(this.val$input.getText(new Interval(pos, posStop)));
                    while (pos > 0 && matcher.matches()) {
                        --pos;
                    }
                    CompileError err = new CompileError(new WPos(this.val$source, offsets, pos, posStop), (String)msg);
                    WurstParser.this.gui.sendError(err);
                    ++this.errorCount;
                    if (this.errorCount > 15) {
                        throw new TooManyErrorsException();
                    }
                }
            };
            lexer.addErrorListener((ANTLRErrorListener)l);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)l);
            JurstParser.CompilationUnitContext cu = parser.compilationUnit();
            CompilationUnit root = new AntlrJurstParseTreeTransformer(source, this.errorHandler, lexer.getLineOffsets()).transform(cu);
            if (this.removeSugar) {
                this.removeSyntacticSugar(root, hasCommonJ);
            }
            return root;
        }
        catch (IOException e) {
            WLogger.severe(e);
            throw new Error(e);
        }
        catch (TooManyErrorsException e) {
            WLogger.info("Stopped parsing file " + source + ", too many errors");
            return this.emptyCompilationUnit();
        }
    }

    public CompilationUnit parseJass(Reader reader, String source, boolean hasCommonJ) {
        return this.parseJassAntlr(reader, source, hasCommonJ);
    }

    private CompilationUnit parseJassAntlr(Reader reader, String source, boolean hasCommonJ) {
        try {
            CodePointCharStream input = CharStreams.fromReader((Reader)reader);
            final ExtendedJassLexer lexer = new ExtendedJassLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            JassParser parser = new JassParser((TokenStream)tokens);
            BaseErrorListener l = new BaseErrorListener((CharStream)input, source){
                int errorCount = 0;
                final /* synthetic */ CharStream val$input;
                final /* synthetic */ String val$source;
                {
                    this.val$input = charStream;
                    this.val$source = string;
                }

                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                    int posStop;
                    int pos;
                    LineOffsets offsets = lexer.getLineOffsets();
                    if (offendingSymbol instanceof Token) {
                        Token token = (Token)offendingSymbol;
                        pos = token.getStartIndex();
                        posStop = token.getStopIndex() + 1;
                    } else {
                        pos = offsets.get(line) + charPositionInLine;
                        posStop = pos + 1;
                    }
                    msg = "line " + line + ": " + (String)msg;
                    Matcher matcher = pattern.matcher(this.val$input.getText(new Interval(pos, posStop)));
                    while (pos > 0 && matcher.matches()) {
                        --pos;
                    }
                    CompileError err = new CompileError(new WPos(this.val$source, offsets, pos, posStop), (String)msg);
                    WurstParser.this.gui.sendError(err);
                    ++this.errorCount;
                    if (this.errorCount > 15) {
                        throw new TooManyErrorsException();
                    }
                }
            };
            lexer.addErrorListener((ANTLRErrorListener)l);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)l);
            JassParser.CompilationUnitContext cu = parser.compilationUnit();
            CompilationUnit root = new AntlrJassParseTreeTransformer(source, this.errorHandler, lexer.getLineOffsets()).transform(cu);
            this.removeSyntacticSugar(root, hasCommonJ);
            return root;
        }
        catch (IOException e) {
            WLogger.severe(e);
            throw new Error(e);
        }
        catch (TooManyErrorsException e) {
            WLogger.info("Stopped parsing file " + source + ", too many errors");
            return this.emptyCompilationUnit();
        }
    }

    public CompilationUnit emptyCompilationUnit() {
        return Ast.CompilationUnit(new CompilationUnitInfo(this.errorHandler), Ast.JassToplevelDeclarations(new JassToplevelDeclaration[0]), Ast.WPackages(new WPackage[0]));
    }

    private void removeSyntacticSugar(CompilationUnit root, boolean hasCommonJ) {
        new SyntacticSugar().removeSyntacticSugar(root, hasCommonJ);
    }

    static class TooManyErrorsException
    extends RuntimeException {
        TooManyErrorsException() {
        }
    }
}

