/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.bytes;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0012"}, d2={"Ldorkbox/bytes/ByteArrayWrapper;", "", "data", "", "copyBytes", "", "([BZ)V", "bytes", "getBytes", "()[B", "hashCode", "", "Ljava/lang/Integer;", "equals", "other", "toString", "", "Companion", "ByteUtilities"})
public final class ByteArrayWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] bytes;
    @Nullable
    private Integer hashCode;
    @NotNull
    public static final String version = "2.0";

    public ByteArrayWrapper(@NotNull byte[] data, boolean copyBytes) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int length = data.length;
        if (copyBytes) {
            this.bytes = new byte[length];
            System.arraycopy(data, 0, this.bytes, 0, length);
        } else {
            this.bytes = data;
        }
    }

    public /* synthetic */ ByteArrayWrapper(byte[] byArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(byArray, bl);
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        Integer hashCode = this.hashCode;
        if (hashCode == null) {
            this.hashCode = hashCode = Integer.valueOf(Arrays.hashCode(this.bytes));
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object other) {
        return !(other instanceof ByteArrayWrapper) ? false : Arrays.equals(this.bytes, ((ByteArrayWrapper)other).bytes);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("ByteArrayWrapper ");
        String string = Arrays.toString(this.bytes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return stringBuilder.append(string).toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldorkbox/bytes/ByteArrayWrapper$Companion;", "", "()V", "version", "", "copy", "Ldorkbox/bytes/ByteArrayWrapper;", "data", "", "wrap", "ByteUtilities"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ByteArrayWrapper copy(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new ByteArrayWrapper(data, true);
        }

        @NotNull
        public final ByteArrayWrapper wrap(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new ByteArrayWrapper(data, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

