/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.validation.controlflow;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.peeeq.wurstscript.ast.AstElementWithBody;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.validation.controlflow.ForwardMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class ForwardExecution<T, Target extends AstElementWithBody> {
    private final ForwardMethod<T, Target> method;
    private final Map<WStatement, T> currentValues = Maps.newLinkedHashMap();
    private final AstElementWithBody f;
    private final PriorityQueue<WStatement> todo = new PriorityQueue(11, (o1, o2) -> o2.getSource().getLeftPos() - o1.getSource().getLeftPos());

    ForwardExecution(Target f, ForwardMethod<T, Target> method) {
        this.f = f;
        this.method = method;
        method.setFuncDef(f);
    }

    void execute() {
        if (this.f.getBody().isEmpty()) {
            throw new Error("" + this.f);
        }
        this.addTodo((WStatement)this.f.getBody().get(0));
        while (!this.todo.isEmpty()) {
            this.checkStmt(this.fromTodo());
        }
        this.method.checkFinal(this.get((WStatement)this.f.getBody().get(this.f.getBody().size() - 1)));
    }

    private WStatement fromTodo() {
        return this.todo.poll();
    }

    private void addTodo(WStatement s) {
        if (this.todo.contains(s)) {
            return;
        }
        this.todo.add(s);
    }

    private void checkStmt(WStatement s) {
        T incoming = this.method.merge(this.get(s.attrPreviousStatements()));
        T oldR = this.currentValues.get(s);
        T r = this.method.calculate(s, incoming);
        if (oldR == null || !this.method.equality(oldR, r)) {
            this.currentValues.put(s, r);
            for (WStatement next : s.attrNextStatements()) {
                this.addTodo(next);
            }
        }
    }

    private Collection<T> get(List<WStatement> previousStatements) {
        if (previousStatements.isEmpty()) {
            return Collections.singleton(this.method.startValue());
        }
        ArrayList result = Lists.newArrayList();
        for (WStatement s : previousStatements) {
            result.add(this.get(s));
        }
        return result;
    }

    private T get(WStatement s) {
        T t = this.currentValues.get(s);
        if (t == null) {
            t = this.method.startValue();
        }
        return t;
    }
}

