/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port.win;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.misc.WinRegistryHandler;
import net.moonlightflower.wc3libs.port.GameDirFinder;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.GameVersionFinder;
import net.moonlightflower.wc3libs.port.MapsDirFinder;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.win.WinGameVersionFinder;
import net.moonlightflower.wc3libs.port.win.registry.WinRegistryGameDirFinder;

public class WinMapsDirFinder
extends MapsDirFinder {
    public static File DEFAULT_DOCUMENTS_DIR = new File("%USERPROFILE%/Documents");
    public static File LOCAL_SUB_DIR = new File("Warcraft III/Maps");
    public static File GAME_SUB_DIR = new File("Maps");

    protected GameDirFinder getWinGameDirFinder() {
        return new WinRegistryGameDirFinder();
    }

    protected WinRegistryHandler getWinRegistryHandler() {
        return new WinRegistryHandler();
    }

    protected GameVersionFinder getWinGameVersionFinder() {
        return new WinGameVersionFinder();
    }

    public File find(@Nonnull GameVersion gameVersion) throws NotFoundException {
        if (gameVersion.compareTo(GameVersion.VERSION_1_29) > 0) {
            WinRegistryHandler winRegistryHandler = this.getWinRegistryHandler();
            File documentsDir = DEFAULT_DOCUMENTS_DIR;
            try {
                documentsDir = new File(winRegistryHandler.get("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User Shell Folders", "Personal"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            File localMapsDir = new File(documentsDir, LOCAL_SUB_DIR.toString());
            if (!localMapsDir.exists()) {
                throw new NotFoundException(new Exception(localMapsDir + " does not exist"));
            }
            return localMapsDir;
        }
        GameDirFinder winGameDirFinder = this.getWinGameDirFinder();
        try {
            File gameDir = (File)winGameDirFinder.get();
            File mapsDir = new File(gameDir, GAME_SUB_DIR.toString());
            if (!mapsDir.exists()) {
                throw new NotFoundException(new Exception(mapsDir + " does not exist"));
            }
            return mapsDir;
        }
        catch (NotFoundException notFoundException) {
            throw new NotFoundException();
        }
    }

    @Override
    @Nonnull
    public File find() throws NotFoundException {
        GameVersionFinder winGameVersionFinder = this.getWinGameVersionFinder();
        try {
            GameVersion gameVersion = (GameVersion)winGameVersionFinder.get();
            return this.find(gameVersion);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(e);
        }
    }
}

