/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import de.peeeq.wurstio.languageserver.ModelManager;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;

public abstract class UserRequest<Res> {
    private final CompletableFuture<Res> fut = new CompletableFuture();

    public abstract Res execute(ModelManager var1) throws IOException;

    public boolean keepDuplicateRequests() {
        return false;
    }

    public void cancel() {
        this.fut.cancel(true);
    }

    public CompletableFuture<Res> getFuture() {
        return this.fut;
    }

    public void run(ModelManager modelManager) {
        try {
            Res res = this.execute(modelManager);
            this.fut.complete(res);
        }
        catch (Exception e) {
            this.fut.completeExceptionally(e);
        }
    }

    public void handleException(LanguageClient languageClient, Throwable err, CompletableFuture<Res> resFut) {
        languageClient.showMessage(new MessageParams(MessageType.Error, err.getMessage()));
        resFut.completeExceptionally(err);
    }
}

