/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.immutablecollections;

import com.google.common.base.Preconditions;
import de.peeeq.immutablecollections.ImmutableList;
import de.peeeq.immutablecollections.ImmutableListImpl;
import de.peeeq.immutablecollections.ImmutableListIterator;
import java.util.Iterator;

class ImmutableListImplCons<T, L extends T, R extends T>
extends ImmutableList<T> {
    private final ImmutableList<L> left;
    private final ImmutableList<R> right;
    private final int size;

    ImmutableListImplCons(ImmutableList<L> left, ImmutableList<R> right) {
        if (left.size() == 0) {
            throw new IllegalArgumentException("left list is empty");
        }
        if (right.size() == 0) {
            throw new IllegalArgumentException("right list is empty");
        }
        this.left = left;
        this.right = right;
        this.size = left.size() + right.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableListIterator(this);
    }

    @Override
    public ImmutableList<T> appFront(T elem) {
        Preconditions.checkNotNull(elem);
        return new ImmutableListImpl<T>(elem, this);
    }

    @Override
    public <R2 extends T> ImmutableList<T> cons(ImmutableList<R2> other) {
        if (other.isEmpty()) {
            return this;
        }
        return new ImmutableListImplCons<T, L, R2>(this, other);
    }

    @Override
    public T head() {
        return (T)this.left.head();
    }

    @Override
    public ImmutableList<T> tail() {
        ImmutableList<L> leftTail = this.left.tail();
        if (leftTail.isEmpty()) {
            return this.right;
        }
        return new ImmutableListImplCons<T, L, R>(leftTail, this.right);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableList<T> removeAll(T t) {
        ImmutableList<L> l = this.left.removeAll(t);
        ImmutableList<R> r = this.right.removeAll(t);
        if (this.left == l && this.right == r) {
            return this;
        }
        return l.cons(r);
    }
}

