/*
 * Decompiled with CFR 0.152.
 */
package workers;

import file.DependencyManager;
import global.Log;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.Git;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.MainWindow;
import ui.UiManager;
import workers.DependencyVerifierWorker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lworkers/DependencyVerifierWorker;", "Ljavax/swing/SwingWorker;", "", "Ljava/lang/Void;", "dependencyUrl", "", "(Ljava/lang/String;)V", "getDependencyUrl", "()Ljava/lang/String;", "doInBackground", "()Ljava/lang/Boolean;", "WurstSetup"})
public final class DependencyVerifierWorker
extends SwingWorker<Boolean, Void> {
    @NotNull
    private final String dependencyUrl;

    public DependencyVerifierWorker(@NotNull String dependencyUrl) {
        Intrinsics.checkNotNullParameter((Object)dependencyUrl, (String)"dependencyUrl");
        this.dependencyUrl = dependencyUrl;
    }

    @NotNull
    public final String getDependencyUrl() {
        return this.dependencyUrl;
    }

    @Override
    @Nullable
    protected Boolean doInBackground() throws Exception {
        Log.INSTANCE.print("Checking git repo..");
        try {
            Triple<String, String, String> resolved = DependencyManager.INSTANCE.resolveName(this.dependencyUrl);
            Collection result = Git.lsRemoteRepository().setRemote((String)resolved.getFirst()).call();
            if (!result.isEmpty()) {
                Log.INSTANCE.print("valid!\n");
                MainWindow.INSTANCE.getUi().getDependencies().add(this.dependencyUrl);
                SwingUtilities.invokeLater(DependencyVerifierWorker::doInBackground$lambda$1);
                UiManager.INSTANCE.refreshComponents();
            } else {
                Log.INSTANCE.print("Error: Entered invalid git repo\n");
            }
        }
        catch (Exception e) {
            Log.INSTANCE.print("Error: Entered invalid git repo\n");
            e.printStackTrace();
        }
        return null;
    }

    private static final String doInBackground$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void doInBackground$lambda$1() {
        MainWindow.INSTANCE.getUi().getDependencyTF().setText(MainWindow.INSTANCE.getUi().getDependencies().stream().map(arg_0 -> DependencyVerifierWorker.doInBackground$lambda$1$lambda$0(doInBackground.1.1.INSTANCE, arg_0)).collect(Collectors.joining(", ")));
    }
}

