/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import de.peeeq.wurstscript.WLogger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;

public class ConfigProvider {
    private final LanguageClient languageClient;

    public ConfigProvider(LanguageClient languageClient) {
        this.languageClient = languageClient;
    }

    public String getConfig(String key, String defaultValue) {
        ConfigurationItem ci = new ConfigurationItem();
        ci.setSection("wurst");
        CompletableFuture res = this.languageClient.configuration(new ConfigurationParams(Collections.singletonList(ci)));
        try {
            List config = (List)res.get();
            for (Object c : config) {
                if (!(c instanceof JsonObject)) continue;
                JsonObject cfg = (JsonObject)c;
                JsonElement result = cfg.get(key);
                if (result instanceof JsonNull) {
                    return null;
                }
                if (result == null) continue;
                return result.getAsString();
            }
            return defaultValue;
        }
        catch (InterruptedException | ExecutionException e) {
            String msg = "Could not get config " + key + ", using default value " + defaultValue;
            WLogger.warning(msg, e);
            this.languageClient.showMessage(new MessageParams(MessageType.Warning, msg));
            return defaultValue;
        }
    }

    public String getJhcrExe() {
        return this.getConfig("jhcrExe", "jhcr.exe");
    }

    public Optional<String> getWc3RunArgs() {
        return Optional.ofNullable(this.getConfig("wc3RunArgs", null));
    }

    public Optional<String> getMapDocumentPath() {
        return Optional.ofNullable(this.getConfig("mapDocumentPath", null));
    }
}

