/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.ArrayInitializer;
import de.peeeq.wurstscript.ast.AstElementWithIndexes;
import de.peeeq.wurstscript.ast.AstElementWithNameId;
import de.peeeq.wurstscript.ast.AstElementWithTypeParameters;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.ConstructorDefs;
import de.peeeq.wurstscript.ast.CyclicDependencyError;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.EnumMember;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprDestroy;
import de.peeeq.wurstscript.ast.ExprEmpty;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprIntVal;
import de.peeeq.wurstscript.ast.ExprMember;
import de.peeeq.wurstscript.ast.ExprMemberArrayVar;
import de.peeeq.wurstscript.ast.ExprMemberArrayVarDot;
import de.peeeq.wurstscript.ast.ExprMemberArrayVarDotDot;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.ExprMemberMethodDot;
import de.peeeq.wurstscript.ast.ExprMemberMethodDotDot;
import de.peeeq.wurstscript.ast.ExprMemberVar;
import de.peeeq.wurstscript.ast.ExprMemberVarDot;
import de.peeeq.wurstscript.ast.ExprMemberVarDotDot;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.ExprNull;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.ExprStringVal;
import de.peeeq.wurstscript.ast.ExprThis;
import de.peeeq.wurstscript.ast.ExprVarAccess;
import de.peeeq.wurstscript.ast.ExprVarArrayAccess;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FuncRef;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.FunctionImplementation;
import de.peeeq.wurstscript.ast.FunctionLike;
import de.peeeq.wurstscript.ast.GlobalOrLocalVarDef;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.HasModifier;
import de.peeeq.wurstscript.ast.HasTypeArgs;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.LExpr;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.LoopStatement;
import de.peeeq.wurstscript.ast.ModAbstract;
import de.peeeq.wurstscript.ast.ModConstant;
import de.peeeq.wurstscript.ast.ModOverride;
import de.peeeq.wurstscript.ast.ModStatic;
import de.peeeq.wurstscript.ast.ModVararg;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.ast.Modifiers;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.ModuleUse;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.NativeType;
import de.peeeq.wurstscript.ast.NoExpr;
import de.peeeq.wurstscript.ast.NoSuperConstructorCall;
import de.peeeq.wurstscript.ast.NoTypeExpr;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.OptExpr;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.SomeSuperConstructorCall;
import de.peeeq.wurstscript.ast.StmtCall;
import de.peeeq.wurstscript.ast.StmtExitwhen;
import de.peeeq.wurstscript.ast.StmtForEach;
import de.peeeq.wurstscript.ast.StmtForFrom;
import de.peeeq.wurstscript.ast.StmtForIn;
import de.peeeq.wurstscript.ast.StmtForRange;
import de.peeeq.wurstscript.ast.StmtIf;
import de.peeeq.wurstscript.ast.StmtReturn;
import de.peeeq.wurstscript.ast.StmtSet;
import de.peeeq.wurstscript.ast.StmtWhile;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchDefaultCaseStatements;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.TranslatedToImFunction;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeExprArray;
import de.peeeq.wurstscript.ast.TypeExprList;
import de.peeeq.wurstscript.ast.TypeExprResolved;
import de.peeeq.wurstscript.ast.TypeExprSimple;
import de.peeeq.wurstscript.ast.TypeExprThis;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.TypeRef;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.VisibilityModifier;
import de.peeeq.wurstscript.ast.VisibilityPrivate;
import de.peeeq.wurstscript.ast.VisibilityProtected;
import de.peeeq.wurstscript.ast.VisibilityPublic;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WShortParameter;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.ast.WStatements;
import de.peeeq.wurstscript.ast.WurstDoc;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.CofigOverridePackages;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.ImplicitFuncs;
import de.peeeq.wurstscript.attributes.SmallHelpers;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.VarLink;
import de.peeeq.wurstscript.gui.ProgressHelper;
import de.peeeq.wurstscript.types.CallSignature;
import de.peeeq.wurstscript.types.FunctionSignature;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeArray;
import de.peeeq.wurstscript.types.WurstTypeBool;
import de.peeeq.wurstscript.types.WurstTypeBoundTypeParam;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeClosure;
import de.peeeq.wurstscript.types.WurstTypeCode;
import de.peeeq.wurstscript.types.WurstTypeEnum;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeInterface;
import de.peeeq.wurstscript.types.WurstTypeModule;
import de.peeeq.wurstscript.types.WurstTypeNamedScope;
import de.peeeq.wurstscript.types.WurstTypeNull;
import de.peeeq.wurstscript.types.WurstTypeReal;
import de.peeeq.wurstscript.types.WurstTypeString;
import de.peeeq.wurstscript.types.WurstTypeTuple;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import de.peeeq.wurstscript.types.WurstTypeVoid;
import de.peeeq.wurstscript.utils.Utils;
import de.peeeq.wurstscript.validation.TRVEHelper;
import de.peeeq.wurstscript.validation.ValidateClassMemberUsage;
import de.peeeq.wurstscript.validation.ValidateGlobalsUsage;
import de.peeeq.wurstscript.validation.ValidateLocalUsage;
import de.peeeq.wurstscript.validation.controlflow.DataflowAnomalyAnalysis;
import de.peeeq.wurstscript.validation.controlflow.ReturnsAnalysis;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;

public class WurstValidator {
    private final WurstModel prog;
    private int functionCount;
    private int visitedFunctions;
    private final Multimap<WScope, WScope> calledFunctions = HashMultimap.create();
    private @Nullable Element lastElement = null;
    private final HashSet<String> trveWrapperFuncs = new HashSet();
    private final HashMap<String, HashSet<FunctionCall>> wrapperCalls = new HashMap();

    public WurstValidator(WurstModel root) {
        this.prog = root;
    }

    public void validate(Collection<CompilationUnit> toCheck) {
        try {
            this.functionCount = this.countFunctions();
            this.visitedFunctions = 0;
            this.prog.getErrorHandler().setProgress("Checking wurst types", ProgressHelper.getValidatorPercent(this.visitedFunctions, this.functionCount));
            for (CompilationUnit cu : toCheck) {
                this.walkTree(cu);
            }
            this.prog.getErrorHandler().setProgress("Post checks", 0.55);
            this.postChecks(toCheck);
        }
        catch (RuntimeException e) {
            WLogger.severe(e);
            Element le = this.lastElement;
            if (le != null) {
                le.addError("Encountered compiler bug near element " + Utils.printElement(le) + ":\n" + Utils.printException(e));
            }
            throw e;
        }
    }

    private void postChecks(Collection<CompilationUnit> toCheck) {
        this.checkUnusedImports(toCheck);
        ValidateGlobalsUsage.checkGlobalsUsage(toCheck);
        ValidateClassMemberUsage.checkClassMembers(toCheck);
        ValidateLocalUsage.checkLocalsUsage(toCheck);
        this.trveWrapperFuncs.forEach(wrapper -> {
            if (this.wrapperCalls.containsKey(wrapper)) {
                this.wrapperCalls.get(wrapper).forEach(call -> {
                    if (call.getArgs().size() > 1 && call.getArgs().get(1) instanceof ExprStringVal) {
                        ExprStringVal varName = (ExprStringVal)call.getArgs().get(1);
                        TRVEHelper.protectedVariables.add(varName.getValS());
                        WLogger.info("keep: " + varName.getValS());
                    } else {
                        call.addError("Map contains TriggerRegisterVariableEvent with non-constant arguments. Can't be optimized.");
                    }
                });
            }
        });
    }

    private void checkUnusedImports(Collection<CompilationUnit> toCheck) {
        for (CompilationUnit cu : toCheck) {
            for (WPackage p : cu.getPackages()) {
                this.checkUnusedImports(p);
            }
        }
    }

    private void checkUnusedImports(WPackage p) {
        LinkedHashSet used = Sets.newLinkedHashSet();
        this.collectUsedPackages(used, p.getElements());
        HashMap<WImport, Set<WPackage>> contributions = new HashMap<WImport, Set<WPackage>>();
        for (WImport imp : p.getImports()) {
            Set<WPackage> contributedPackages = this.contributedPackages(imp.attrImportedPackage(), used, new HashSet<WPackage>());
            contributions.put(imp, contributedPackages);
        }
        block1: for (WImport imp : p.getImports()) {
            if (imp.attrImportedPackage() == null || imp.getIsPublic() || imp.getPackagename().equals("Wurst")) continue;
            Set impContributions = (Set)contributions.get(imp);
            if (impContributions.isEmpty()) {
                imp.addWarning("The import " + imp.getPackagename() + " is never used");
                continue;
            }
            for (WImport imp2 : p.getImports()) {
                if (imp == imp2 || !((Set)contributions.get(imp2)).containsAll(impContributions)) continue;
                imp.addWarning("The import " + imp.getPackagename() + " can be removed, because it is already included in " + imp2.getPackagename() + ".");
                continue block1;
            }
        }
    }

    private Set<WPackage> contributedPackages(WPackage p, Set<PackageOrGlobal> used, Set<WPackage> visited) {
        if (p == null) {
            return Collections.emptySet();
        }
        visited.add(p);
        HashSet<WPackage> result = new HashSet<WPackage>();
        if (used.contains(p)) {
            result.add(p);
        }
        for (WImport imp : p.getImports()) {
            WPackage imported = imp.attrImportedPackage();
            if (imp.getPackagename().equals("Wurst") || visited.contains(imported) || !imp.getIsPublic()) continue;
            result.addAll(this.contributedPackages(imported, used, visited));
        }
        return result;
    }

    private WPackage getConfiguredPackage(Element e) {
        PackageOrGlobal p = e.attrNearestPackage();
        if (p instanceof WPackage && p.getModel().attrConfigOverridePackages().containsValue((Object)p)) {
            for (WPackage k : p.getModel().attrConfigOverridePackages().keySet()) {
                if (!((WPackage)p.getModel().attrConfigOverridePackages().get((Object)k)).equals(p)) continue;
                return k;
            }
        }
        return null;
    }

    private void collectUsedPackages(Set<PackageOrGlobal> used, Element e) {
        ModuleUse mu;
        ExprBinary binop;
        TypeRef t;
        NameRef nr;
        Object def;
        WPackage configPackage;
        FuncRef fr;
        FuncLink link;
        for (int i = 0; i < e.size(); ++i) {
            this.collectUsedPackages(used, e.get(i));
        }
        if (e instanceof FuncRef && (link = (fr = (FuncRef)e).attrFuncLink()) != null) {
            used.add(link.getDef().attrNearestPackage());
            if (link.getDef().attrHasAnnotation("@config") && (configPackage = this.getConfiguredPackage(link.getDef())) != null) {
                used.add(configPackage);
            }
        }
        if (e instanceof NameRef && (def = (nr = (NameRef)e).attrNameLink()) != null) {
            used.add(((NameLink)def).getDef().attrNearestPackage());
            if (((NameLink)def).getDef().attrHasAnnotation("@config") && (configPackage = this.getConfiguredPackage(((NameLink)def).getDef())) != null) {
                used.add(configPackage);
            }
        }
        if (e instanceof TypeRef && (def = (t = (TypeRef)e).attrTypeDef()) != null) {
            used.add(def.attrNearestPackage());
        }
        if (e instanceof ExprBinary && (def = (binop = (ExprBinary)e).attrFuncLink()) != null) {
            used.add(((FuncLink)def).getDef().attrNearestPackage());
        }
        if (e instanceof Expr) {
            WurstType typ = ((Expr)e).attrTyp();
            if (typ instanceof WurstTypeNamedScope) {
                WurstTypeNamedScope ns = (WurstTypeNamedScope)typ;
                NamedScope def2 = ns.getDef();
                if (def2 != null) {
                    used.add(def2.attrNearestPackage());
                }
            } else if (typ instanceof WurstTypeTuple) {
                def = ((WurstTypeTuple)typ).getTupleDef();
                used.add(def.attrNearestPackage());
            }
        }
        if (e instanceof ModuleUse && (def = (mu = (ModuleUse)e).attrModuleDef()) != null) {
            used.add(def.attrNearestPackage());
        }
    }

    private void walkTree(Element e) {
        this.lastElement = e;
        this.check(e);
        this.lastElement = null;
        for (int i = 0; i < e.size(); ++i) {
            this.walkTree(e.get(i));
        }
    }

    private void check(Element e) {
        try {
            if (e instanceof Annotation) {
                this.checkAnnotation((Annotation)e);
            }
            if (e instanceof AstElementWithTypeParameters) {
                this.checkTypeParameters((AstElementWithTypeParameters)e);
            }
            if (e instanceof AstElementWithNameId) {
                this.checkName((AstElementWithNameId)e);
            }
            if (e instanceof ClassDef) {
                this.checkAbstractMethods((ClassDef)e);
                this.visit((ClassDef)e);
            }
            if (e instanceof ClassOrModule) {
                this.checkConstructorsUnique((ClassOrModule)e);
            }
            if (e instanceof CompilationUnit) {
                this.checkPackageName((CompilationUnit)e);
            }
            if (e instanceof ConstructorDef) {
                this.checkConstructor((ConstructorDef)e);
                this.checkConstructorSuperCall((ConstructorDef)e);
            }
            if (e instanceof ExprBinary) {
                this.visit((ExprBinary)e);
            }
            if (e instanceof ExprClosure) {
                this.checkClosure((ExprClosure)e);
            }
            if (e instanceof ExprEmpty) {
                this.checkExprEmpty((ExprEmpty)e);
            }
            if (e instanceof ExprIntVal) {
                this.checkIntVal((ExprIntVal)e);
            }
            if (e instanceof ExprFuncRef) {
                this.checkFuncRef((ExprFuncRef)e);
            }
            if (e instanceof ExprFunctionCall) {
                this.checkBannedFunctions((ExprFunctionCall)e);
                this.visit((ExprFunctionCall)e);
            }
            if (e instanceof ExprMemberMethod) {
                this.visit((ExprMemberMethod)e);
            }
            if (e instanceof ExprMemberVar) {
                this.checkMemberVar((ExprMemberVar)e);
            }
            if (e instanceof ExprMemberArrayVar) {
                this.checkMemberArrayVar((ExprMemberArrayVar)e);
            }
            if (e instanceof ExprNewObject) {
                this.checkNewObj((ExprNewObject)e);
                this.visit((ExprNewObject)e);
            }
            if (e instanceof ExprNull) {
                this.checkExprNull((ExprNull)e);
            }
            if (e instanceof ExprVarAccess) {
                this.visit((ExprVarAccess)e);
            }
            if (e instanceof ExprVarArrayAccess) {
                this.checkArrayAccess((ExprVarArrayAccess)e);
            }
            if (e instanceof ExtensionFuncDef) {
                this.visit((ExtensionFuncDef)e);
            }
            if (e instanceof FuncDef) {
                this.visit((FuncDef)e);
            }
            if (e instanceof FuncRef) {
                this.checkFuncRef((FuncRef)e);
            }
            if (e instanceof FunctionLike) {
                this.checkUninitializedVars((FunctionLike)e);
            }
            if (e instanceof GlobalVarDef) {
                this.visit((GlobalVarDef)e);
            }
            if (e instanceof HasModifier) {
                this.checkModifiers((HasModifier)e);
            }
            if (e instanceof HasTypeArgs) {
                this.checkTypeBinding((HasTypeArgs)e);
            }
            if (e instanceof InterfaceDef) {
                this.checkInterfaceDef((InterfaceDef)e);
            }
            if (e instanceof LocalVarDef) {
                this.checkLocalShadowing((LocalVarDef)e);
                this.visit((LocalVarDef)e);
            }
            if (e instanceof Modifiers) {
                this.visit((Modifiers)e);
            }
            if (e instanceof ModuleDef) {
                this.visit((ModuleDef)e);
            }
            if (e instanceof NameDef) {
                this.nameDefsMustNotBeNamedAfterJassNativeTypes((NameDef)e);
                this.checkConfigOverride((NameDef)e);
            }
            if (e instanceof NameRef) {
                this.checkImplicitParameter((NameRef)e);
                this.checkNameRef((NameRef)e);
            }
            if (e instanceof StmtCall) {
                this.checkCall((StmtCall)e);
            }
            if (e instanceof ExprDestroy) {
                this.visit((ExprDestroy)e);
            }
            if (e instanceof StmtForRange) {
                this.checkForRange((StmtForRange)e);
            }
            if (e instanceof StmtIf) {
                this.visit((StmtIf)e);
            }
            if (e instanceof StmtReturn) {
                this.visit((StmtReturn)e);
            }
            if (e instanceof StmtSet) {
                this.checkStmtSet((StmtSet)e);
            }
            if (e instanceof StmtWhile) {
                this.visit((StmtWhile)e);
            }
            if (e instanceof SwitchStmt) {
                this.checkSwitch((SwitchStmt)e);
            }
            if (e instanceof TypeExpr) {
                this.checkTypeExpr((TypeExpr)e);
            }
            if (e instanceof TypeExprArray) {
                this.checkCodeArrays((TypeExprArray)e);
            }
            if (e instanceof TupleDef) {
                this.checkTupleDef((TupleDef)e);
            }
            if (e instanceof VarDef) {
                this.checkVarDef((VarDef)e);
            }
            if (e instanceof WImport) {
                this.visit((WImport)e);
            }
            if (e instanceof WPackage) {
                this.checkPackage((WPackage)e);
            }
            if (e instanceof WParameter) {
                this.checkParameter((WParameter)e);
                this.visit((WParameter)e);
            }
            if (e instanceof WScope) {
                this.checkForDuplicateNames((WScope)e);
            }
            if (e instanceof WStatement) {
                this.checkReachability((WStatement)e);
            }
            if (e instanceof WurstModel) {
                this.checkForDuplicatePackages((WurstModel)e);
            }
            if (e instanceof WStatements) {
                this.checkForInvalidStmts((WStatements)e);
                this.checkForEmptyBlocks((WStatements)e);
            }
            if (e instanceof StmtExitwhen) {
                this.visit((StmtExitwhen)e);
            }
        }
        catch (CyclicDependencyError cde) {
            cde.printStackTrace();
            Element element = cde.getElement();
            String attr = cde.getAttributeName().replaceFirst("^attr", "");
            WLogger.info(Utils.printElementWithSource(Optional.of(element)) + " depends on itself when evaluating attribute " + attr);
            WLogger.info(cde);
            throw new CompileError(element.attrSource(), Utils.printElement(element) + " depends on itself when evaluating attribute " + attr);
        }
    }

    private void checkAbstractMethods(ClassDef c) {
        ImmutableMultimap<String, DefLink> nameLinks = c.attrNameLinks();
        if (!c.attrIsAbstract()) {
            StringBuilder toImplement = new StringBuilder();
            for (DefLink link : nameLinks.values()) {
                NameDef f = link.getDef();
                if (!f.attrIsAbstract()) continue;
                if (f.attrNearestStructureDef() == c) {
                    Element loc = f.getModifiers().stream().filter(m -> m instanceof ModAbstract).map(x -> x).findFirst().orElse(f);
                    loc.addError("Non-abstract class " + c.getName() + " cannot have abstract functions like " + f.getName());
                    continue;
                }
                if (!(link instanceof FuncLink)) continue;
                toImplement.append("\n    ");
                toImplement.append(((FuncLink)link).printFunctionTemplate());
            }
            if (toImplement.length() > 0) {
                c.addError("Non-abstract class " + c.getName() + " must implement the following functions:" + toImplement);
            }
        }
    }

    private void visit(StmtExitwhen exitwhen) {
        Element parent = exitwhen.getParent();
        while (!(parent instanceof FunctionDefinition)) {
            if (parent instanceof StmtForEach) {
                StmtForEach forEach = (StmtForEach)parent;
                if (forEach.getIn().tryGetNameDef().attrIsVararg()) {
                    exitwhen.addError("Cannot use break in vararg for each loops.");
                }
                return;
            }
            if (parent instanceof LoopStatement) {
                return;
            }
            parent = parent.getParent();
        }
        exitwhen.addError("Break is not allowed outside of loop statements.");
    }

    private void checkTupleDef(TupleDef e) {
        this.checkTupleDefCycle(e, new ArrayList<TupleDef>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTupleDefCycle(TupleDef e, ArrayList<TupleDef> tuples) {
        if (tuples.contains(e)) {
            return true;
        }
        tuples.add(e);
        try {
            for (WParameter param : e.getParameters()) {
                WurstTypeTuple tt;
                TupleDef tDef;
                WurstType t = param.getTyp().attrTyp();
                if (!(t instanceof WurstTypeTuple) || !this.checkTupleDefCycle(tDef = (tt = (WurstTypeTuple)t).getTupleDef(), tuples)) continue;
                param.addError("Parameter " + param.getName() + " is recursive. This is not allowed for tuples.");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            tuples.remove(e);
        }
    }

    private void checkForInvalidStmts(WStatements stmts) {
        for (WStatement s : stmts) {
            if (!(s instanceof ExprVarAccess)) continue;
            ExprVarAccess ev = (ExprVarAccess)s;
            s.addError("Use of variable " + ev.getVarName() + " is an incomplete statement.");
        }
    }

    private void checkForEmptyBlocks(WStatements e) {
        Element parent = e.getParent();
        if (parent instanceof OnDestroyDef || parent instanceof ConstructorDef || parent instanceof FunctionDefinition || parent instanceof SwitchDefaultCaseStatements || parent instanceof SwitchCase) {
            return;
        }
        if (parent instanceof ExprStatementsBlock) {
            if (e.size() > 2) {
                return;
            }
            parent.getParent().addWarning("This function has an empty body. Write 'skip' if you intend to leave it empty.");
            return;
        }
        if (!e.isEmpty()) {
            return;
        }
        if (Utils.isJassCode(parent)) {
            return;
        }
        if (parent instanceof StmtIf) {
            StmtIf stmtIf = (StmtIf)parent;
            if (e == stmtIf.getElseBlock() && stmtIf.getHasElse()) {
                parent.addWarning("This if-statement has an empty else-block.");
            } else if (e == stmtIf.getThenBlock()) {
                parent.addWarning("This if-statement has an empty then-block. Write 'skip' if you intend to leave it empty.");
            }
            return;
        }
        parent.addWarning("This statement (" + Utils.printElement(parent) + ") contains an empty block. Write 'skip' if you intend to leave it empty.");
    }

    private void checkName(AstElementWithNameId e) {
        String name = e.getNameId().getName();
        TypeDef def = e.lookupType(name, false);
        if (def != e && def instanceof NativeType) {
            e.addError("The name '" + name + "' is already used as a native type in " + Utils.printPos(def.getSource()));
        } else if (!e.attrSource().getFile().endsWith(".j")) {
            switch (name) {
                case "int": 
                case "integer": 
                case "real": 
                case "code": 
                case "boolean": 
                case "string": 
                case "handle": {
                    e.addError("The name '" + name + "' is a built-in type and cannot be used here.");
                }
            }
        }
    }

    private void checkConfigOverride(NameDef e) {
        if (!e.hasAnnotation("@config")) {
            return;
        }
        PackageOrGlobal nearestPackage = e.attrNearestPackage();
        if (!(nearestPackage instanceof WPackage)) {
            e.addError("Annotation @config can only be used in packages.");
            return;
        }
        WPackage configPackage = (WPackage)nearestPackage;
        if (!configPackage.getName().endsWith("_config")) {
            e.addError("Annotation @config can only be used in config packages (package name has to end with '_config').");
            return;
        }
        WPackage origPackage = CofigOverridePackages.getOriginalPackage(configPackage);
        if (origPackage == null) {
            return;
        }
        if (e instanceof GlobalVarDef) {
            GlobalVarDef v = (GlobalVarDef)e;
            NameLink origVar = origPackage.getElements().lookupVarNoConfig(v.getName(), false);
            if (origVar == null) {
                e.addError("Could not find var " + v.getName() + " in configured package.");
                return;
            }
            if (!v.attrTyp().equalsType(origVar.getTyp(), v)) {
                e.addError("Configured variable must have type " + origVar.getTyp() + " but the found type is " + v.attrTyp() + ".");
                return;
            }
            if (!origVar.getDef().hasAnnotation("@configurable")) {
                e.addWarning("The configured variable " + v.getName() + " is not marked with @configurable.\nIt is still possible to configure this var but it is not recommended.");
            }
        } else if (e instanceof FuncDef) {
            FuncDef funcDef = (FuncDef)e;
            ImmutableCollection<FuncLink> funcs = origPackage.getElements().lookupFuncsNoConfig(funcDef.getName(), false);
            FuncDef configuredFunc = null;
            for (NameLink nameLink : funcs) {
                FuncDef f;
                if (!(nameLink.getDef() instanceof FuncDef) || !this.equalSignatures(funcDef, f = (FuncDef)nameLink.getDef())) continue;
                configuredFunc = f;
                break;
            }
            if (configuredFunc == null) {
                funcDef.addError("Could not find a function " + funcDef.getName() + " with the same signature in the configured package.");
            } else if (!configuredFunc.hasAnnotation("@configurable")) {
                e.addWarning("The configured function " + funcDef.getName() + " is not marked with @configurable.\nIt is still possible to configure this function but it is not recommended.");
            }
        } else {
            e.addError("Configuring " + Utils.printElement(e) + " is not supported by Wurst.");
        }
    }

    private boolean equalSignatures(FuncDef f, FuncDef g) {
        if (f.getParameters().size() != g.getParameters().size()) {
            return false;
        }
        if (!f.attrReturnTyp().equalsType(g.attrReturnTyp(), f)) {
            return false;
        }
        for (int i = 0; i < f.getParameters().size(); ++i) {
            if (((WParameter)f.getParameters().get(i)).attrTyp().equalsType(((WParameter)g.getParameters().get(i)).attrTyp(), f)) continue;
            return false;
        }
        return true;
    }

    private void checkExprEmpty(ExprEmpty e) {
        e.addError("Incomplete expression...");
    }

    private void checkMemberArrayVar(ExprMemberArrayVar e) {
    }

    private void checkNameRef(NameRef e) {
        if (e.getVarName().isEmpty()) {
            e.addError("Missing variable name.");
        }
    }

    private void checkPackage(WPackage p) {
        this.checkForDuplicateImports(p);
        p.attrInitDependencies();
    }

    private void checkTypeExpr(TypeExpr e) {
        if (e instanceof TypeExprResolved) {
            return;
        }
        if (e.isModuleUseTypeArg()) {
            return;
        }
        TypeDef typeDef = e.attrTypeDef();
        if (e.attrTypeDef() instanceof ModuleDef) {
            ModuleDef md = (ModuleDef)e.attrTypeDef();
            this.checkModuleTypeUsedCorrectly(e, md);
        }
        if (typeDef instanceof TypeParamDef) {
            TypeParamDef tp = (TypeParamDef)typeDef;
            this.checkTypeparamsUsedCorrectly(e, tp);
        }
    }

    private void checkModuleTypeUsedCorrectly(TypeExpr e, ModuleDef md) {
        TypeExpr scopeType;
        TypeExprSimple tes;
        TypeExprThis parent;
        if (e instanceof TypeExprThis) {
            return;
        }
        if (e.getParent() instanceof TypeExprThis && (parent = (TypeExprThis)e.getParent()).getScopeType() == e) {
            return;
        }
        if (e instanceof TypeExprSimple && (tes = (TypeExprSimple)e).getScopeType() instanceof TypeExpr && ((scopeType = (TypeExpr)tes.getScopeType()) instanceof TypeExprThis || scopeType.attrTypeDef() instanceof ModuleDef)) {
            return;
        }
        e.addError("Cannot use module type " + md.getName() + " in this context.");
    }

    private void checkTypeparamsUsedCorrectly(TypeExpr e, TypeParamDef tp) {
        if (tp.isStructureDefTypeParam()) {
            if (tp.attrNearestStructureDef() instanceof ModuleDef) {
                return;
            }
            if (!e.attrIsDynamicContext()) {
                e.addError("Type variables must not be used in static contexts.");
            }
        }
    }

    private void checkClosure(ExprClosure e) {
        WurstTypeClass ct;
        ClassDef cd;
        WurstType expectedTyp = e.attrExpectedTypAfterOverloading();
        if (expectedTyp instanceof WurstTypeCode) {
            if (!e.attrCapturedVariables().isEmpty()) {
                for (Map.Entry elem : e.attrCapturedVariables().entries()) {
                    ((Element)elem.getKey()).addError("Cannot capture local variable '" + ((VarDef)elem.getValue()).getName() + "' in anonymous function. This is only possible with closures.");
                }
            }
        } else if (expectedTyp instanceof WurstTypeUnknown || expectedTyp instanceof WurstTypeClosure) {
            e.addError("Closures can only be used when a interface or class type is given.");
        } else if (!(expectedTyp instanceof WurstTypeClass) && !(expectedTyp instanceof WurstTypeInterface)) {
            e.addError("Closures can only be used when a interface or class type is given, but at this position a " + expectedTyp + " is expected.");
        }
        e.attrCapturedVariables();
        if (e.getImplementation() instanceof ExprStatementsBlock) {
            ExprStatementsBlock block = (ExprStatementsBlock)e.getImplementation();
            new DataflowAnomalyAnalysis(false).execute(block);
        }
        if (expectedTyp instanceof WurstTypeClass && (cd = (ct = (WurstTypeClass)expectedTyp).getClassDef()).getConstructors().stream().noneMatch(constr -> constr.getParameters().isEmpty())) {
            e.addError("No default constructor for class " + ct + " found, so it cannot be instantiated using an anonymous function.");
        }
    }

    private void checkConstructorsUnique(ClassOrModule c) {
        ConstructorDefs constrs = c.getConstructors();
        for (int i = 0; i < constrs.size() - 1; ++i) {
            ConstructorDef c1 = (ConstructorDef)constrs.get(i);
            int j = i + 1;
            while (i < constrs.size()) {
                ConstructorDef c2 = (ConstructorDef)constrs.get(j);
                if (c1.getParameters().size() == c2.getParameters().size() && !this.parametersTypeDisjunct(c1.getParameters(), c2.getParameters())) {
                    c2.addError("Duplicate constructor, an other constructor with similar types is already defined in line " + c1.attrSource().getLine());
                }
                ++i;
            }
        }
    }

    private boolean parametersTypeDisjunct(WParameters params1, WParameters params2) {
        for (int i = 0; i < params1.size(); ++i) {
            WurstType t2;
            WurstType t1 = ((WParameter)params1.get(i)).attrTyp();
            if (t1.isSubtypeOf(t2 = ((WParameter)params2.get(i)).attrTyp(), params1) || t2.isSubtypeOf(t1, params2)) continue;
            return true;
        }
        return false;
    }

    private void checkImplicitParameter(NameRef e) {
        e.attrImplicitParameter();
    }

    private void checkTypeParameters(AstElementWithTypeParameters e) {
        for (TypeParamDef ta : e.getTypeParameters()) {
            if (ta.getName().contains("<") || ta.getName().startsWith("#")) {
                ta.addError("Type parameter must be a simple name ");
            } else {
                this.checkTypeName(ta, ta.getName());
            }
            ta.attrTyp();
        }
    }

    private void checkExprNull(ExprNull e) {
        if (!Utils.isJassCode(e) && e.attrExpectedTyp() instanceof WurstTypeUnknown) {
            e.addError("Cannot use 'null' constant here because the compiler cannot infer which kind of null it is.");
        }
    }

    private void checkForRange(StmtForRange e) {
        if (!e.getLoopVar().attrTyp().isSubtypeOf(WurstTypeInt.instance(), e)) {
            e.getLoopVar().addError("For-loop variable must be int.");
        }
        if (!e.getTo().attrTyp().isSubtypeOf(WurstTypeInt.instance(), e)) {
            e.getLoopVar().addError("For-loop target must be int.");
        }
        if (!e.getStep().attrTyp().isSubtypeOf(WurstTypeInt.instance(), e)) {
            e.getLoopVar().addError("For-loop step must be int.");
        }
    }

    private void checkIntVal(ExprIntVal e) {
    }

    private int countFunctions() {
        final int[] functionCount = new int[1];
        this.prog.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(FuncDef f) {
                super.visit(f);
                functionCount[0] = functionCount[0] + 1;
            }
        });
        return functionCount[0];
    }

    private void checkStmtSet(StmtSet s) {
        NameLink nameLink = s.getUpdatedExpr().attrNameLink();
        if (nameLink == null) {
            s.getUpdatedExpr().addError("Could not find variable " + s.getUpdatedExpr().getVarName() + ".");
            return;
        }
        if (!(nameLink instanceof VarLink)) {
            s.getUpdatedExpr().addError("Invalid assignment. This is not a variable, this is a " + nameLink);
            return;
        }
        WurstType leftType = s.getUpdatedExpr().attrTyp();
        WurstType rightType = s.getRight().attrTyp();
        this.checkAssignment(Utils.isJassCode(s), s, leftType, rightType);
        this.checkIfAssigningToConstant(s.getUpdatedExpr());
        this.checkIfNoEffectAssignment(s);
    }

    private void checkIfNoEffectAssignment(StmtSet s) {
        if (this.refersToSameVar(s.getUpdatedExpr(), s.getRight())) {
            s.addWarning("The assignment to " + Utils.printElement(s.getUpdatedExpr().attrNameDef()) + " probably has no effect.");
        }
    }

    private boolean refersToSameVar(OptExpr a, OptExpr b) {
        if (a instanceof NoExpr && b instanceof NoExpr) {
            return true;
        }
        if (a instanceof ExprThis && b instanceof ExprThis) {
            return true;
        }
        if (a instanceof NameRef && b instanceof NameRef) {
            NameRef va = (NameRef)a;
            NameRef vb = (NameRef)b;
            NameLink nla = va.attrNameLink();
            NameLink nlb = vb.attrNameLink();
            if (nla != null && nlb != null && nla.getDef() == nlb.getDef() && this.refersToSameVar(va.attrImplicitParameter(), vb.attrImplicitParameter())) {
                if (va instanceof AstElementWithIndexes && vb instanceof AstElementWithIndexes) {
                    AstElementWithIndexes vai = (AstElementWithIndexes)((Object)va);
                    AstElementWithIndexes vbi = (AstElementWithIndexes)((Object)vb);
                    for (int i = 0; i < vai.getIndexes().size() && i < vbi.getIndexes().size(); ++i) {
                        if (this.refersToSameVar((OptExpr)vai.getIndexes().get(i), (OptExpr)vbi.getIndexes().get(i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void checkIfAssigningToConstant(LExpr left) {
        left.match(new LExpr.MatcherVoid(){

            @Override
            public void case_ExprVarArrayAccess(ExprVarArrayAccess e) {
            }

            @Override
            public void case_ExprVarAccess(ExprVarAccess e) {
                WurstValidator.this.checkVarNotConstant(e, e.attrNameLink());
            }

            @Override
            public void case_ExprMemberVarDot(ExprMemberVarDot e) {
                if (e.attrNameDef() instanceof WParameter) {
                    if (e.getLeft() instanceof ExprThis) {
                        e.addError("Cannot change 'this'. Tuples are not classes.");
                    } else if (e.getLeft() instanceof NameRef) {
                        WurstValidator.this.checkIfAssigningToConstant((NameRef)e.getLeft());
                    } else {
                        e.addError("Ok, so you are trying to assign something to the return value of a function. This wont do nothing. Tuples are not classes.");
                    }
                }
                WurstValidator.this.checkVarNotConstant(e, e.attrNameLink());
            }

            @Override
            public void case_ExprMemberArrayVarDot(ExprMemberArrayVarDot e) {
            }

            @Override
            public void case_ExprMemberArrayVarDotDot(ExprMemberArrayVarDotDot e) {
                e.addError("Cannot assign to dot-dot-expression.");
            }

            @Override
            public void case_ExprMemberVarDotDot(ExprMemberVarDotDot e) {
                e.addError("Cannot assign to dot-dot-expression.");
            }
        });
    }

    private void checkVarNotConstant(NameRef left, @Nullable NameLink link) {
        if (link == null) {
            return;
        }
        NameDef var = link.getDef();
        if (var != null && var.attrIsConstant()) {
            GlobalVarDef glob;
            if (var instanceof GlobalVarDef && (glob = (GlobalVarDef)var).attrIsDynamicClassMember() && this.isInConstructor(left)) {
                return;
            }
            left.addError("Cannot assign a new value to constant " + Utils.printElement(var));
        }
    }

    private boolean isInConstructor(Element e) {
        while (e != null) {
            if (e instanceof ConstructorDef) {
                return true;
            }
            e = e.getParent();
        }
        return false;
    }

    private void checkAssignment(boolean isJassCode, Element pos, WurstType leftType, WurstType rightType) {
        WPackage pack;
        WurstTypeNamedScope ns;
        if (!rightType.isSubtypeOf(leftType, pos)) {
            if (isJassCode && leftType.isSubtypeOf(WurstTypeReal.instance(), pos) && rightType.isSubtypeOf(WurstTypeInt.instance(), pos)) {
                return;
            }
            pos.addError("Cannot assign " + rightType + " to " + leftType);
        }
        if (leftType instanceof WurstTypeNamedScope && (ns = (WurstTypeNamedScope)leftType).isStaticRef()) {
            pos.addError("Missing variable name in variable declaration.\nCannot assign to " + leftType);
        }
        if (leftType instanceof WurstTypeArray) {
            pos.addError("Missing array index for assignment to array variable.s");
        }
        if (rightType instanceof WurstTypeVoid && pos.attrNearestPackage() instanceof WPackage && (pack = (WPackage)pos.attrNearestPackage()) != null && !pack.getName().equals("WurstREPL")) {
            pos.addError("Function or expression returns nothing. Cannot assign nothing to a variable.");
        }
    }

    private void visit(LocalVarDef s) {
        this.checkVarName(s, false);
        if (s.getInitialExpr() instanceof Expr) {
            Expr initial = (Expr)s.getInitialExpr();
            if (!(s.getOptTyp() instanceof NoTypeExpr) && initial instanceof ExprNewObject) {
                s.addWarning("Duplicated type information. Use 'var' or 'let' instead.");
            }
            WurstType leftType = s.attrTyp();
            WurstType rightType = initial.attrTyp();
            this.checkAssignment(Utils.isJassCode(s), s, leftType, rightType);
        } else if (s.getInitialExpr() instanceof ArrayInitializer) {
            ArrayInitializer arInit = (ArrayInitializer)s.getInitialExpr();
            this.checkArrayInit(s, arInit);
        }
        this.checkIfRead(s);
    }

    private void checkArrayInit(VarDef def, ArrayInitializer arInit) {
        WurstType leftType = def.attrTyp();
        if (leftType instanceof WurstTypeArray) {
            WurstTypeArray arT = (WurstTypeArray)leftType;
            if (arT.getDimensions() > 1) {
                def.addError("Array initializer can only be used with one-dimensional arrays.");
            }
            if (arT.getDimensions() == 1) {
                int initialValues = arInit.getValues().size();
                int size = arT.getSize(0);
                if (size >= 0 && size != initialValues) {
                    def.addError("Array variable " + def.getName() + " is an array of size " + size + ", but is initialized with " + initialValues + " values here.");
                }
            }
            WurstType baseType = arT.getBaseType();
            for (Expr expr : arInit.getValues()) {
                if (expr.attrTyp().isSubtypeOf(baseType, expr)) continue;
                expr.addError("Expected expression of type " + baseType + " in array initialization, but found " + expr.attrTyp());
            }
        } else {
            def.addError("Array initializer can only be used with array-variables, but " + Utils.printElement(def) + " has type " + leftType);
        }
    }

    private void checkIfRead(VarDef s) {
        if (s.getName().startsWith("_")) {
            return;
        }
        if (Utils.isJassCode(s)) {
            return;
        }
        if (s.getParent() instanceof StmtForRange) {
            return;
        }
        WScope f = s.attrNearestScope();
        if (f != null && !f.attrReadVariables().contains(s)) {
            s.addWarning("The " + Utils.printElement(s) + " is never read. If intentional, prefix with \"_\" to suppress this warning.");
        }
    }

    private void checkVarName(VarDef s, boolean isConstant) {
        String varName = s.getName();
        if (!(this.isValidVarnameStart(varName) || Utils.isJassCode(s) || varName.matches("[A-Z0-9_]+"))) {
            s.addWarning("Variable names should start with a lower case character. (" + varName + ")");
        }
        if (varName.equals("handle")) {
            s.addError("\"handle\" is not a valid variable name");
        } else if (varName.equals("code")) {
            s.addError("\"code\" is not a valid variable name");
        }
    }

    private boolean isValidVarnameStart(String varName) {
        return varName.length() > 0 && Character.isLowerCase(varName.charAt(0)) || varName.startsWith("_");
    }

    private void visit(WParameter p) {
        this.checkVarName(p, false);
        if (p.attrIsVararg() && p.attrNearestFuncDef().getParameters().size() != 1) {
            p.addError("Vararg functions may only have one parameter");
        }
        this.checkIfParameterIsRead(p);
    }

    private void checkIfParameterIsRead(WParameter p) {
        FunctionImplementation f = p.attrNearestFuncDef();
        if (f != null) {
            if (p.getParent().getParent() instanceof ExprClosure) {
                return;
            }
            if (f.attrIsOverride()) {
                return;
            }
            if (f.attrIsAbstract()) {
                return;
            }
            if (f.attrHasAnnotation("compiletimenative")) {
                return;
            }
        } else {
            if (p.getParent().getParent() instanceof TupleDef) {
                return;
            }
            if (p.getParent().getParent() instanceof NativeFunc) {
                return;
            }
        }
        this.checkIfRead(p);
    }

    private void visit(GlobalVarDef s) {
        this.checkVarName(s, s.attrIsConstant());
        if (s.getInitialExpr() instanceof Expr) {
            Expr initial = (Expr)s.getInitialExpr();
            WurstType leftType = s.attrTyp();
            WurstType rightType = initial.attrTyp();
            this.checkAssignment(Utils.isJassCode(s), s, leftType, rightType);
        } else if (s.getInitialExpr() instanceof ArrayInitializer) {
            this.checkArrayInit(s, (ArrayInitializer)s.getInitialExpr());
        }
        if (!(s.attrTyp() instanceof WurstTypeArray) || s.attrIsStatic() || s.attrIsDynamicClassMember()) {
            // empty if block
        }
    }

    private void visit(StmtIf stmtIf) {
        WurstType condType = stmtIf.getCond().attrTyp();
        if (!(condType instanceof WurstTypeBool)) {
            stmtIf.getCond().addError("If condition must be a boolean but found " + condType);
        }
    }

    private void visit(StmtWhile stmtWhile) {
        WurstType condType = stmtWhile.getCond().attrTyp();
        if (!(condType instanceof WurstTypeBool)) {
            stmtWhile.getCond().addError("While condition must be a boolean but found " + condType);
        }
    }

    private void visit(ExtensionFuncDef func) {
        this.checkFunctionName(func);
        func.getExtendedType().attrTyp();
    }

    private void checkFunctionName(FunctionDefinition f) {
        if (!Utils.isJassCode(f) && !this.isValidVarnameStart(f.getName())) {
            f.addWarning("Function names should start with an lower case character.");
        }
    }

    private void checkReturn(FunctionLike func) {
        FunctionImplementation funcDef;
        if (!func.attrHasEmptyBody()) {
            new ReturnsAnalysis().execute(func);
        } else if (func instanceof FunctionImplementation && (funcDef = (FunctionImplementation)func).getReturnTyp() instanceof TypeExpr && !(func.attrNearestStructureDef() instanceof InterfaceDef)) {
            func.addError("Function " + funcDef.getName() + " is missing a body. Use the 'skip' statement to define an empty body.");
        }
    }

    private void checkReachability(WStatement s) {
        if (s.getParent() instanceof WStatements) {
            WStatements stmts = (WStatements)s.getParent();
            if (s.attrPreviousStatements().isEmpty() && (s.attrListIndex() > 0 || !(stmts.getParent() instanceof TranslatedToImFunction) && !(stmts.getParent() instanceof ExprStatementsBlock))) {
                if (Utils.isJassCode(s)) {
                    s.addWarning("Unreachable code");
                } else if (this.mightBeAffectedBySwitchThatCoversAllCases(s)) {
                    s.addWarning("Unreachable code");
                } else {
                    s.addError("Unreachable code");
                }
            }
        }
    }

    private boolean mightBeAffectedBySwitchThatCoversAllCases(WStatement s) {
        final boolean[] containsSwitchAr = new boolean[]{false};
        s.attrNearestNamedScope().accept(new Element.DefaultVisitor(){

            @Override
            public void visit(SwitchStmt switchStmt) {
                if (switchStmt.calculateHandlesAllCases()) {
                    containsSwitchAr[0] = true;
                }
            }
        });
        return containsSwitchAr[0];
    }

    private void visit(FuncDef func) {
        ++this.visitedFunctions;
        func.getErrorHandler().setProgress(null, ProgressHelper.getValidatorPercent(this.visitedFunctions, this.functionCount));
        this.checkFunctionName(func);
        if (func.attrIsAbstract()) {
            if (!func.attrHasEmptyBody()) {
                func.addError("Abstract function " + func.getName() + " must not have a body.");
            }
            if (func.attrIsPrivate()) {
                func.addError("Abstract functions must not be private.");
            }
        }
    }

    private void checkUninitializedVars(FunctionLike f) {
        FuncDef func;
        boolean isAbstract = false;
        if (f instanceof FuncDef && (func = (FuncDef)f).attrIsAbstract()) {
            isAbstract = true;
            if (!func.attrHasEmptyBody()) {
                ((WStatement)func.getBody().get(0)).addError("The abstract function " + func.getName() + " must not have any statements.");
            }
        }
        if (!isAbstract) {
            this.checkReturn(f);
            if (!(f.getSource().getFile().endsWith("common.j") || f.getSource().getFile().endsWith("blizzard.j") || f.getSource().getFile().endsWith("war3map.j"))) {
                new DataflowAnomalyAnalysis(Utils.isJassCode(f)).execute(f);
            }
        }
    }

    private void checkCall(StmtCall call) {
        String funcName;
        if (call instanceof FunctionCall) {
            FunctionCall fcall = (FunctionCall)call;
            funcName = fcall.getFuncName();
            HashSet fcalls = this.wrapperCalls.computeIfAbsent(funcName, s -> new HashSet());
            fcalls.add(fcall);
        } else if (call instanceof ExprNewObject) {
            funcName = "constructor";
        } else {
            throw new Error("unhandled case: " + Utils.printElement(call));
        }
        call.attrCallSignature().checkSignatureCompatibility(call.attrFunctionSignature(), funcName, call);
    }

    private void checkAnnotation(Annotation a) {
        FuncLink fl = a.attrFuncLink();
        if (fl != null) {
            if (a.getArgs().size() < fl.getParameterTypes().size()) {
                a.addWarning("not enough arguments");
            } else if (a.getArgs().size() > fl.getParameterTypes().size()) {
                a.addWarning("too many enough arguments");
            } else {
                for (int i = 0; i < a.getArgs().size(); ++i) {
                    WurstType expected;
                    WurstType actual = ((Expr)a.getArgs().get(i)).attrTyp();
                    if (actual.isSubtypeOf(expected = fl.getParameterType(i), a)) continue;
                    ((Expr)a.getArgs().get(i)).addWarning("Expected " + expected + " but found " + actual + ".");
                }
            }
        }
    }

    private void visit(ExprFunctionCall stmtCall) {
        ExprFuncRef exprFuncRef;
        FuncLink f;
        Expr firstArg;
        String funcName = stmtCall.getFuncName();
        stmtCall.attrTyp();
        this.checkFuncDefDeprecated(stmtCall);
        if (stmtCall.attrFuncLink() != null) {
            FuncLink calledFunc = stmtCall.attrFuncLink();
            if (calledFunc.getDef().attrIsDynamicClassMember() && !stmtCall.attrIsDynamicContext()) {
                stmtCall.addError("Cannot call dynamic function " + funcName + " from static context.");
            }
            if (calledFunc.getDef() instanceof ExtensionFuncDef) {
                stmtCall.addError("Extension function " + funcName + " must be called with an explicit receiver.\nTry to write this." + funcName + "(...) .");
            }
        }
        if (Utils.oneOf(funcName, "Condition", "Filter") && !stmtCall.getArgs().isEmpty() && (firstArg = (Expr)stmtCall.getArgs().get(0)) instanceof ExprFuncRef && (f = (exprFuncRef = (ExprFuncRef)firstArg).attrFuncLink()) != null && !(f.getReturnType() instanceof WurstTypeBool) && !(f.getReturnType() instanceof WurstTypeVoid)) {
            firstArg.addError("Functions passed to Filter or Condition must return boolean or nothing.");
        }
    }

    @Deprecated
    private void checkParams(Element where, String preMsg, List<Expr> args, FunctionSignature sig) {
        this.checkParams(where, preMsg, args, sig.getParamTypes());
    }

    @Deprecated
    private void checkParams(Element where, String preMsg, List<Expr> args, List<WurstType> parameterTypes) {
        if (args.size() > parameterTypes.size()) {
            where.addError(preMsg + "Too many parameters.");
        } else if (args.size() < parameterTypes.size()) {
            where.addError(preMsg + "Missing parameters.");
        } else {
            for (int i = 0; i < args.size(); ++i) {
                WurstType expected;
                WurstType actual = args.get(i).attrTyp();
                if (actual.isSubtypeOf(expected = parameterTypes.get(i), where)) continue;
                args.get(i).addError(preMsg + "Expected " + expected + " as parameter " + (i + 1) + " but  found " + actual);
            }
        }
    }

    private void visit(ExprBinary expr) {
        FuncLink def = expr.attrFuncLink();
        if (def != null) {
            FunctionSignature sig = FunctionSignature.fromNameLink(def);
            CallSignature callSig = new CallSignature(expr.getLeft(), Collections.singletonList(expr.getRight()));
            callSig.checkSignatureCompatibility(sig, "" + expr.getOp(), expr);
        }
    }

    private void visit(ExprMemberMethod stmtCall) {
        stmtCall.attrTyp();
    }

    private void visit(ExprNewObject stmtCall) {
        stmtCall.attrTyp();
        stmtCall.attrConstructorDef();
    }

    private void visit(Modifiers modifiers) {
        boolean hasVis = false;
        boolean isStatic = false;
        for (Modifier m : modifiers) {
            if (m instanceof VisibilityModifier) {
                if (hasVis) {
                    m.addError("Each element can only have one visibility modifier (public, private, ...)");
                }
                hasVis = true;
                continue;
            }
            if (!(m instanceof ModStatic)) continue;
            if (isStatic) {
                m.addError("double static? - what r u trying to do?");
            }
            isStatic = true;
        }
    }

    private void visit(StmtReturn s) {
        if (s.attrNearestExprStatementsBlock() != null) {
            ExprStatementsBlock e = s.attrNearestExprStatementsBlock();
            if (e.getReturnStmt() != s) {
                s.addError("Return in a statements block can only be at the end.");
                return;
            }
            if (s.getReturnedObj() instanceof Expr) {
                Expr expr = (Expr)s.getReturnedObj();
                if (expr.attrTyp().isVoid()) {
                    s.addError("Cannot return void from statements block.");
                }
            } else {
                s.addError("Cannot have empty return statement in statements block.");
            }
        } else {
            FunctionImplementation func = s.attrNearestFuncDef();
            if (func == null) {
                s.addError("return statements can only be used inside functions");
                return;
            }
            this.checkReturnInFunc(s, func);
        }
    }

    private void checkReturnInFunc(StmtReturn s, FunctionImplementation func) {
        WurstType returnType = func.attrReturnTyp();
        if (s.getReturnedObj() instanceof Expr) {
            Expr returned = (Expr)s.getReturnedObj();
            if (returnType.isSubtypeOf(WurstTypeVoid.instance(), s)) {
                s.addError("Cannot return a value from a function which returns nothing");
            } else {
                WurstType returnedType = returned.attrTyp();
                if (!returnedType.isSubtypeOf(returnType, s)) {
                    s.addError("Cannot return " + returnedType + ", expected expression of type " + returnType);
                }
            }
        } else if (!returnType.isSubtypeOf(WurstTypeVoid.instance(), s)) {
            s.addError("Missing return value");
        }
    }

    private void visit(ClassDef classDef) {
        this.checkTypeName(classDef, classDef.getName());
        if (!(classDef.getExtendedClass() instanceof NoTypeExpr) && !(classDef.getExtendedClass().attrTyp() instanceof WurstTypeClass)) {
            classDef.getExtendedClass().addError("Classes may only extend other classes.");
        }
        if (classDef.isInnerClass() && !classDef.attrIsStatic()) {
            classDef.addError("At the moment only static inner classes are supported.");
        }
    }

    private void checkTypeName(Element source, String name) {
        if (!Character.isUpperCase(name.charAt(0))) {
            source.addWarning("Type names should start with upper case characters.");
        }
    }

    private void visit(ModuleDef moduleDef) {
        this.checkTypeName(moduleDef, moduleDef.getName());
        moduleDef.attrNameLinks();
    }

    private void visit(ExprDestroy stmtDestroy) {
        WurstType typ = stmtDestroy.getDestroyedObj().attrTyp();
        if (!(typ instanceof WurstTypeModule)) {
            if (typ instanceof WurstTypeClass) {
                WurstTypeClass c = (WurstTypeClass)typ;
                this.checkDestroyClass(stmtDestroy, c);
            } else if (typ instanceof WurstTypeInterface) {
                WurstTypeInterface i = (WurstTypeInterface)typ;
                this.checkDestroyInterface(stmtDestroy, i);
            } else {
                stmtDestroy.addError("Cannot destroy objects of type " + typ);
            }
        }
    }

    private void checkDestroyInterface(ExprDestroy stmtDestroy, WurstTypeInterface i) {
        if (i.isStaticRef()) {
            stmtDestroy.addError("Cannot destroy interface " + i);
        }
    }

    private void checkDestroyClass(ExprDestroy stmtDestroy, WurstTypeClass c) {
        if (c.isStaticRef()) {
            stmtDestroy.addError("Cannot destroy class " + c);
        }
        this.calledFunctions.put((Object)stmtDestroy.attrNearestScope(), (Object)c.getClassDef().getOnDestroy());
    }

    private void visit(ExprVarAccess e) {
        this.checkVarRef(e, e.attrIsDynamicContext());
    }

    private void visit(WImport wImport) {
        if (wImport.attrImportedPackage() == null) {
            if (!wImport.getPackagename().equals("NoWurst")) {
                wImport.addError("Could not find imported package " + wImport.getPackagename());
            }
            return;
        }
        if (!wImport.attrImportedPackage().getName().equals("Wurst") && wImport.attrImportedPackage().getName().equals(wImport.attrNearestNamedScope().getName())) {
            wImport.addError("Packages cannot import themselves");
        }
    }

    private void checkVarRef(NameRef e, boolean dynamicContext) {
        WurstTypeNamedScope wtns;
        GlobalVarDef g;
        NameLink link = e.attrNameLink();
        if (link == null) {
            return;
        }
        NameDef def = link.getDef();
        if (def instanceof GlobalVarDef && (g = (GlobalVarDef)def).attrIsDynamicClassMember() && !dynamicContext) {
            e.addError("Cannot reference dynamic variable " + e.getVarName() + " from static context.");
        }
        this.checkNameRefDeprecated((Element)e, def);
        if (e.attrTyp() instanceof WurstTypeNamedScope && (wtns = (WurstTypeNamedScope)e.attrTyp()).isStaticRef()) {
            ExprMemberMethod em;
            if (!this.isUsedAsReceiverInExprMember(e)) {
                e.addError("Reference to " + e.getVarName() + " cannot be used as an expression.");
            } else if (e.getParent() instanceof ExprMemberMethodDotDot) {
                e.addError("Reference to " + e.getVarName() + " cannot be used with the cascade operator. Only dynamic objects are allowed.");
            } else if (e.getParent() instanceof ExprMemberMethod && (em = (ExprMemberMethod)e.getParent()).attrFuncDef() instanceof ExtensionFuncDef) {
                e.addError("Reference to " + e.getVarName() + " can only be used for calling static methods, but not for calling extension method method '" + em.getFuncName() + "'.");
            }
        }
    }

    private boolean isUsedAsReceiverInExprMember(Expr e) {
        if (e.getParent() instanceof ExprMember) {
            ExprMember em = (ExprMember)e.getParent();
            return em.getLeft() == e;
        }
        if (e.getParent() instanceof StmtForIn) {
            StmtForIn parent = (StmtForIn)e.getParent();
            return parent.getIn() == e;
        }
        if (e.getParent() instanceof StmtForFrom) {
            StmtForFrom parent = (StmtForFrom)e.getParent();
            return parent.getIn() == e;
        }
        return false;
    }

    private void checkTypeBinding(HasTypeArgs e) {
        VariableBinding mapping = e.match(new HasTypeArgs.Matcher<VariableBinding>(){

            @Override
            public VariableBinding case_ExprNewObject(ExprNewObject e) {
                return e.attrTyp().getTypeArgBinding();
            }

            @Override
            public VariableBinding case_ModuleUse(ModuleUse moduleUse) {
                return null;
            }

            @Override
            public VariableBinding case_TypeExprSimple(TypeExprSimple e) {
                return e.attrTyp().getTypeArgBinding();
            }

            @Override
            public VariableBinding case_ExprFunctionCall(ExprFunctionCall e) {
                return e.attrTyp().getTypeArgBinding();
            }

            @Override
            public VariableBinding case_ExprMemberMethodDot(ExprMemberMethodDot e) {
                return e.attrTyp().getTypeArgBinding();
            }

            @Override
            public VariableBinding case_ExprMemberMethodDotDot(ExprMemberMethodDotDot e) {
                return e.attrTyp().getTypeArgBinding();
            }
        });
        if (mapping == null) {
            return;
        }
        for (Tuple2<TypeParamDef, WurstTypeBoundTypeParam> t : mapping) {
            FunctionDefinition toIndex;
            WurstTypeBoundTypeParam boundTyp = (WurstTypeBoundTypeParam)t._2();
            WurstType typ = boundTyp.getBaseType();
            TypeParamDef tp = (TypeParamDef)t._1();
            if (tp.getTypeParamConstraints() instanceof TypeExprList || typ.isTranslatedToInt() || e instanceof ModuleUse) continue;
            String toIndexFuncName = ImplicitFuncs.toIndexFuncName(typ);
            String fromIndexFuncName = ImplicitFuncs.fromIndexFuncName(typ);
            Collection<FuncLink> toIndexFuncs = ImplicitFuncs.findToIndexFuncs(typ, e);
            Collection<FuncLink> fromIndexFuncs = ImplicitFuncs.findFromIndexFuncs(typ, e);
            if (toIndexFuncs.isEmpty()) {
                e.addError("Type parameters can only be bound to ints and class types, but not to " + typ + ".\nYou can provide functions " + toIndexFuncName + " and " + fromIndexFuncName + " to use this type with generics.");
                continue;
            }
            if (fromIndexFuncs.isEmpty()) {
                e.addError("Could not find function " + fromIndexFuncName + " which is required to use " + typ + " with generics.");
                continue;
            }
            if (toIndexFuncs.size() > 1) {
                e.addError("There is more than one function named " + toIndexFuncName);
            }
            if (fromIndexFuncs.size() > 1) {
                e.addError("There is more than one function named " + fromIndexFuncName);
            }
            if ((toIndex = Utils.getFirst(toIndexFuncs).getDef()) instanceof FuncDef) {
                FuncDef toIndexF = (FuncDef)toIndex;
                if (toIndexF.getParameters().size() != 1) {
                    toIndexF.addError("Must have exactly one parameter");
                } else if (!((WParameter)toIndexF.getParameters().get(0)).attrTyp().equalsType(typ, e)) {
                    toIndexF.addError("Parameter must be of type " + typ);
                }
                WurstType returnType = toIndexF.attrReturnTyp();
                if (!returnType.equalsType(WurstTypeInt.instance(), e)) {
                    toIndexF.addError("Return type must be of type int  but was " + returnType);
                }
            } else {
                toIndex.addError("This should be a function.");
            }
            FunctionDefinition fromIndex = Utils.getFirst(fromIndexFuncs).getDef();
            if (fromIndex instanceof FuncDef) {
                WurstType returnType;
                FuncDef fromIndexF = (FuncDef)fromIndex;
                if (fromIndexF.getParameters().size() != 1) {
                    fromIndexF.addError("Must have exactly one parameter");
                } else if (!((WParameter)fromIndexF.getParameters().get(0)).attrTyp().equalsType(WurstTypeInt.instance(), e)) {
                    fromIndexF.addError("Parameter must be of type int");
                }
                if ((returnType = fromIndexF.attrReturnTyp()).equalsType(typ, e)) continue;
                fromIndexF.addError("Return type must be of type " + typ + " but was " + returnType);
                continue;
            }
            fromIndex.addError("This should be a function.");
        }
    }

    private void checkFuncRef(FuncRef ref) {
        if (ref.getFuncName().isEmpty()) {
            ref.addError("Missing function name.");
        }
        this.checkFuncDefDeprecated(ref);
        FuncLink called = ref.attrFuncLink();
        if (called == null) {
            return;
        }
        WScope scope = ref.attrNearestFuncDef();
        if (scope == null) {
            scope = ref.attrNearestScope();
        }
        if (!(ref instanceof ExprFuncRef)) {
            this.calledFunctions.put((Object)scope, (Object)called.getDef());
        }
    }

    private void checkNameRefDeprecated(Element trace, NameLink link) {
        if (link != null) {
            this.checkNameRefDeprecated(trace, link.getDef());
        }
    }

    private void checkNameRefDeprecated(Element trace, NameDef def) {
        if (def != null && def.hasAnnotation("@deprecated")) {
            Annotation annotation = def.getAnnotation("@deprecated");
            String msg = annotation.getAnnotationMessage();
            msg = msg == null || msg.isEmpty() ? "It shouldn't be used and will be removed in the future." : msg;
            trace.addWarning("<" + def.getName() + "> is deprecated. " + msg);
        }
    }

    private void checkFuncDefDeprecated(FuncRef ref) {
        this.checkNameRefDeprecated((Element)ref, ref.attrFuncLink());
    }

    private void checkFuncRef(ExprFuncRef ref) {
        FuncLink called = ref.attrFuncLink();
        if (called == null) {
            return;
        }
        if (ref.attrTyp() instanceof WurstTypeCode && called.getDef().attrParameterTypesIncludingReceiver().size() > 0) {
            Object msg = "Can only use functions without parameters in 'code' function references.";
            if (called.getDef().attrIsDynamicClassMember()) {
                msg = (String)msg + "\nNote that " + called.getName() + " is a dynamic function and thus has an implicit parameter 'this'.";
            }
            ref.addError((String)msg);
        }
    }

    private void checkModifiers(final HasModifier e) {
        for (final Modifier m : e.getModifiers()) {
            final StringBuilder error = new StringBuilder();
            e.match(new HasModifier.MatcherVoid(){

                @Override
                public void case_WParameter(WParameter wParameter) {
                    this.check(ModConstant.class);
                }

                @Override
                public void case_WShortParameter(WShortParameter wShortParameter) {
                    this.check(ModConstant.class);
                }

                @Override
                public void case_TypeParamDef(TypeParamDef typeParamDef) {
                    error.append("Type Parameters must not have modifiers");
                }

                @Override
                public void case_NativeType(NativeType nativeType) {
                    this.check(VisibilityPublic.class);
                }

                @SafeVarargs
                private final void check(Class<? extends Modifier> ... allowed) {
                    if (m instanceof WurstDoc) {
                        return;
                    }
                    if (m instanceof ModVararg && e.getParent() instanceof WParameters) {
                        return;
                    }
                    boolean isAllowed = false;
                    for (Class<? extends Modifier> a : allowed) {
                        String allowedName;
                        String modName = m.getClass().getName();
                        if (!modName.startsWith(allowedName = a.getName())) continue;
                        isAllowed = true;
                        break;
                    }
                    if (!isAllowed) {
                        error.append("Modifier ").append(WurstValidator.printMod(m)).append(" not allowed for ").append(Utils.printElement(e)).append(".\n Allowed are the following modifiers: ");
                        boolean first = true;
                        for (Class<? extends Modifier> c : allowed) {
                            if (!first) {
                                error.append(", ");
                            }
                            error.append(WurstValidator.printMod(c));
                            first = false;
                        }
                    }
                }

                @Override
                public void case_NativeFunc(NativeFunc nativeFunc) {
                    this.check(VisibilityPublic.class, Annotation.class);
                }

                @Override
                public void case_ModuleInstanciation(ModuleInstanciation moduleInstanciation) {
                    this.check(VisibilityPrivate.class, VisibilityProtected.class);
                }

                @Override
                public void case_ModuleDef(ModuleDef moduleDef) {
                    this.check(VisibilityPublic.class);
                }

                @Override
                public void case_LocalVarDef(LocalVarDef localVarDef) {
                    this.check(ModConstant.class);
                    if (localVarDef.hasAnnotation("@compiletime")) {
                        localVarDef.getAnnotation("@compiletime").addWarning("The annotation '@compiletime' has no effect on variables.");
                    }
                }

                @Override
                public void case_GlobalVarDef(GlobalVarDef g) {
                    if (g.attrNearestClassOrModule() != null) {
                        this.check(VisibilityPrivate.class, VisibilityProtected.class, ModStatic.class, ModConstant.class, Annotation.class);
                    } else {
                        this.check(VisibilityPublic.class, ModConstant.class, Annotation.class);
                    }
                    if (g.hasAnnotation("@compiletime")) {
                        g.getAnnotation("@compiletime").addWarning("The annotation '@compiletime' has no effect on variables.");
                    }
                }

                @Override
                public void case_FuncDef(FuncDef f) {
                    if (f.attrNearestStructureDef() != null) {
                        if (f.attrNearestStructureDef() instanceof InterfaceDef) {
                            this.check(VisibilityPrivate.class, VisibilityProtected.class, ModAbstract.class, ModOverride.class, Annotation.class);
                        } else {
                            this.check(VisibilityPrivate.class, VisibilityProtected.class, ModAbstract.class, ModOverride.class, ModStatic.class, Annotation.class);
                            if (f.attrNearestStructureDef() instanceof ClassDef && f.attrIsStatic() && f.attrIsAbstract()) {
                                f.addError("Static functions cannot be abstract.");
                            }
                        }
                    } else {
                        this.check(VisibilityPublic.class, Annotation.class);
                    }
                    if (f.attrIsCompiletime()) {
                        if (f.getParameters().size() > 0) {
                            f.addError("Functions annotated '@compiletime' may not take parameters.\nNote: The annotation marks functions to be executed by wurst at compiletime.");
                        } else if (f.attrIsDynamicClassMember()) {
                            f.addError("Functions annotated '@compiletime' must be static.\nNote: The annotation marks functions to be executed by wurst at compiletime.");
                        }
                    }
                }

                @Override
                public void case_ExtensionFuncDef(ExtensionFuncDef extensionFuncDef) {
                    this.check(VisibilityPublic.class, Annotation.class);
                }

                @Override
                public void case_ConstructorDef(ConstructorDef constructorDef) {
                    this.check(VisibilityPrivate.class);
                }

                @Override
                public void case_ClassDef(ClassDef classDef) {
                    this.check(VisibilityPublic.class, ModAbstract.class, ModStatic.class);
                    if (!classDef.isInnerClass() && classDef.attrIsStatic()) {
                        classDef.addError("Top-level class " + classDef.getName() + " cannot be static. Only inner classes can be declared static.");
                    }
                }

                @Override
                public void case_InterfaceDef(InterfaceDef interfaceDef) {
                    this.check(VisibilityPublic.class);
                }

                @Override
                public void case_TupleDef(TupleDef tupleDef) {
                    this.check(VisibilityPublic.class);
                }

                @Override
                public void case_WPackage(WPackage wPackage) {
                    this.check(new Class[0]);
                }

                @Override
                public void case_EnumDef(EnumDef enumDef) {
                    this.check(VisibilityPublic.class);
                }

                @Override
                public void case_EnumMember(EnumMember enumMember) {
                    this.check(new Class[0]);
                }
            });
            if (error.length() <= 0) continue;
            if (m.attrSource().getFile().endsWith(".jurst")) {
                m.addWarning(error.toString());
                continue;
            }
            m.addError(error.toString());
        }
    }

    private static String printMod(Class<? extends Modifier> c) {
        String name = c.getName().toLowerCase();
        name = name.replaceFirst("^.*\\.", "");
        name = name.replaceAll("^(mod|visibility)", "");
        name = name.replaceAll("impl$", "");
        return name;
    }

    private static String printMod(Modifier m) {
        if (m instanceof Annotation) {
            return ((Annotation)m).getAnnotationType();
        }
        return WurstValidator.printMod(m.getClass());
    }

    private void checkConstructor(ConstructorDef d) {
        StructureDef s;
        if (d.attrNearestClassOrModule() instanceof ModuleDef && d.getParameters().size() > 0) {
            d.getParameters().addError("Module constructors must not have parameters.");
        }
        if ((s = d.attrNearestStructureDef()) instanceof ClassDef) {
            ClassDef c = (ClassDef)s;
            WurstTypeClass ct = c.attrTypC();
            WurstTypeClass extendedClass = ct.extendedClass();
            if (extendedClass != null) {
                ConstructorDef sc = d.attrSuperConstructor();
                if (sc == null) {
                    d.addError("No super constructor found.");
                } else {
                    ArrayList paramTypes = Lists.newArrayList();
                    for (WParameter p : sc.getParameters()) {
                        paramTypes.add(p.attrTyp());
                    }
                    if (d.getSuperConstructorCall() instanceof NoSuperConstructorCall && paramTypes.size() > 0) {
                        c.addError("The extended class <" + extendedClass.getName() + "> does not expose a no-arg constructor. You must define a constructor that calls super(..) appropriately, in this class.");
                    } else {
                        this.checkParams((Element)d, "Incorrect call to super constructor: ", SmallHelpers.superArgs(d), paramTypes);
                    }
                }
            }
        } else if (d.getSuperConstructorCall() instanceof SomeSuperConstructorCall) {
            d.addError("Module constructors cannot have super calls.");
        }
    }

    private void checkArrayAccess(ExprVarArrayAccess ea) {
        this.checkNameRefDeprecated((Element)ea, ea.tryGetNameDef());
        for (Expr index : ea.getIndexes()) {
            if (index.attrTyp().isSubtypeOf(WurstTypeInt.instance(), ea)) continue;
            index.addError("Arrayindices have to be of type int");
        }
    }

    private void checkInterfaceDef(InterfaceDef i) {
        this.checkTypeName(i, i.getName());
    }

    private void checkNewObj(ExprNewObject e) {
        ConstructorDef constr = e.attrConstructorDef();
        if (constr != null) {
            this.calledFunctions.put((Object)e.attrNearestScope(), (Object)constr);
            if (constr.attrNearestClassDef().attrIsAbstract()) {
                e.addError("Cannot create an instance of the abstract class " + constr.attrNearestClassDef().getName());
                return;
            }
            this.checkParams((Element)e, "Wrong object creation: ", (List<Expr>)e.getArgs(), e.attrFunctionSignature());
        }
    }

    private void nameDefsMustNotBeNamedAfterJassNativeTypes(NameDef n) {
        PackageOrGlobal p = n.attrNearestPackage();
        if (p == null) {
            n.addError("Not in package or global: " + n.getName());
        }
    }

    private void checkMemberVar(ExprMemberVar e) {
        if (e.getVarName().length() == 0) {
            e.addError("Incomplete member access.");
        }
        if (e.getParent() instanceof WStatements) {
            e.addError("Incomplete statement.");
        }
    }

    private void checkPackageName(CompilationUnit cu) {
        if (cu.getPackages().size() == 1 && Utils.isWurstFile(cu.getCuInfo().getFile())) {
            WPackage p = (WPackage)cu.getPackages().get(0);
            if (!Utils.fileName(cu.getCuInfo().getFile()).equals(p.getName() + ".wurst") && !Utils.fileName(cu.getCuInfo().getFile()).equals(p.getName() + ".jurst")) {
                p.addError("The file must have the same name as the package " + p.getName());
            }
        }
    }

    private void checkForDuplicatePackages(WurstModel model) {
        model.attrPackages();
    }

    private void checkBannedFunctions(ExprFunctionCall e) {
        if (e.getFuncName().equals("TriggerRegisterVariableEvent")) {
            if (e.getArgs().size() > 1) {
                if (e.getArgs().get(1) instanceof ExprStringVal) {
                    ExprStringVal varName = (ExprStringVal)e.getArgs().get(1);
                    TRVEHelper.protectedVariables.add(varName.getValS());
                    WLogger.info("keep: " + varName.getValS());
                    return;
                }
                if (e.getArgs().get(1) instanceof ExprVarAccess) {
                    WParameters params;
                    ExprVarAccess varAccess = (ExprVarAccess)e.getArgs().get(1);
                    @Nullable FunctionImplementation nearestFunc = e.attrNearestFuncDef();
                    WStatements fbody = nearestFunc.getBody();
                    if (e.getParent() instanceof StmtReturn && fbody.size() <= 4 && ((WStatement)fbody.get(fbody.size() - 2)).structuralEquals(e.getParent()) && (params = nearestFunc.getParameters()).size() == 4 && ((TypeExprSimple)((WParameter)params.get(0)).getTyp()).getTypeName().equals("trigger") && ((TypeExprSimple)((WParameter)params.get(1)).getTyp()).getTypeName().equals("string") && ((TypeExprSimple)((WParameter)params.get(2)).getTyp()).getTypeName().equals("limitop") && ((TypeExprSimple)((WParameter)params.get(3)).getTyp()).getTypeName().equals("real")) {
                        this.trveWrapperFuncs.add(nearestFunc.getName());
                        WLogger.info("found wrapper: " + nearestFunc.getName());
                        return;
                    }
                }
            } else {
                e.addError("Map contains TriggerRegisterVariableEvent with non-constant arguments. Can't be optimized.");
            }
        }
        if (e.getFuncName().equals("ExecuteFunc")) {
            if (e.getArgs().size() != 1) {
                e.addError("Wrong number of args");
                return;
            }
            if (e.getArgs().get(0) instanceof ExprStringVal) {
                ExprStringVal s = (ExprStringVal)e.getArgs().get(0);
                String exFunc = s.getValS();
                ImmutableCollection<FuncLink> funcs = e.lookupFuncs(exFunc);
                if (funcs.isEmpty()) {
                    e.addError("Could not find function " + exFunc + ".");
                    return;
                }
                if (funcs.size() > 1) {
                    StringBuilder alternatives = new StringBuilder();
                    for (NameLink nameLink : funcs) {
                        alternatives.append("\n - ").append(Utils.printElementWithSource(Optional.of(nameLink.getDef())));
                    }
                    e.addError("Ambiguous function name: " + exFunc + ". Alternatives are: " + alternatives);
                    return;
                }
                FuncLink func = Utils.getFirst(funcs);
                if (func.getParameterTypes().size() != 0) {
                    e.addError("Function " + exFunc + " must not have any parameters.");
                }
            } else {
                e.addError("Wurst does only support ExecuteFunc with a single string as argument.");
            }
        }
    }

    private boolean isViableSwitchtype(Expr expr) {
        WurstType typ = expr.attrTyp();
        if (typ.equalsType(WurstTypeInt.instance(), null) || typ.equalsType(WurstTypeString.instance(), null)) {
            return true;
        }
        if (typ instanceof WurstTypeEnum) {
            WurstTypeEnum wte = (WurstTypeEnum)typ;
            return !wte.isStaticRef();
        }
        return false;
    }

    private void checkSwitch(SwitchStmt s) {
        if (!this.isViableSwitchtype(s.getExpr())) {
            s.addError("The type " + s.getExpr().attrTyp() + " is not viable as switchtype.\nViable switchtypes: int, string, enum");
        } else {
            List switchExprs = s.getCases().stream().flatMap(e -> e.getExpressions().stream()).collect(Collectors.toList());
            for (Expr cExpr : switchExprs) {
                if (cExpr.attrTyp().isSubtypeOf(s.getExpr().attrTyp(), cExpr)) continue;
                cExpr.addError("The type " + cExpr.attrTyp() + " does not match the switchtype " + s.getExpr().attrTyp() + ".");
            }
            for (int i = 0; i < switchExprs.size(); ++i) {
                Expr ei = (Expr)switchExprs.get(i);
                for (int j = 0; j < i; ++j) {
                    Expr ej = (Expr)switchExprs.get(j);
                    if (!ei.structuralEquals(ej)) continue;
                    ei.addError("The case " + Utils.prettyPrint(ei) + " is already handled in line " + ej.attrSource().getLine());
                    return;
                }
            }
        }
        for (String unhandledCase : s.calculateUnhandledCases()) {
            s.addError(unhandledCase + " not covered in switchstatement and no default found.");
        }
        if (s.getCases().isEmpty()) {
            s.addError("Switch statement without any cases.");
        }
    }

    public static void computeFlowAttributes(Element node) {
        if (node instanceof WStatement) {
            WStatement s = (WStatement)node;
            s.attrNextStatements();
        }
        for (int i = 0; i < node.size(); ++i) {
            WurstValidator.computeFlowAttributes(node.get(i));
        }
    }

    private void checkCodeArrays(TypeExprArray e) {
        TypeExprSimple base;
        if (e.getBase() instanceof TypeExprSimple && (base = (TypeExprSimple)e.getBase()).getTypeName().equals("code")) {
            e.addError("Code arrays are not supported. Try using an array of triggers or conditionfuncs.");
        }
    }

    public static boolean canOverride(FuncLink func1, FuncLink func2, boolean allowStaticOverride) {
        return WurstValidator.checkOverride(func1, func2, allowStaticOverride) == null;
    }

    public static String checkOverride(FuncLink func1, FuncLink func2, boolean allowStaticOverride) {
        if (!allowStaticOverride) {
            if (func1.isStatic()) {
                return "Static method " + func1.getName() + " cannot override other methods.";
            }
            if (func2.isStatic()) {
                return "Static " + Utils.printElementWithSource(Optional.of(func2.getDef())) + " cannot be overridden.";
            }
        } else {
            if (func1.isStatic() && !func2.isStatic()) {
                return "Static method " + func1.getName() + " cannot override dynamic " + Utils.printElementWithSource(Optional.of(func2.getDef())) + ".";
            }
            if (!func1.isStatic() && func2.isStatic()) {
                return "Method " + func1.getName() + " cannot override static " + Utils.printElementWithSource(Optional.of(func2.getDef())) + ".";
            }
        }
        if (func1.isVarargMethod() && !func2.isVarargMethod()) {
            return "Vararg method " + func1.getName() + " cannot override non-vararg method " + Utils.printElementWithSource(Optional.of(func2.getDef())) + ".";
        }
        if (!func1.isVarargMethod() && func2.isVarargMethod()) {
            return "Non-vararg method " + func1.getName() + " cannot override vararg method " + Utils.printElementWithSource(Optional.of(func2.getDef())) + ".";
        }
        int paramCount2 = func2.getParameterTypes().size();
        int paramCount1 = func1.getParameterTypes().size();
        if (paramCount1 != paramCount2) {
            return Utils.printElement(func2.getDef()) + " takes " + paramCount2 + " parameters, but there are only " + paramCount1 + " parameters here.";
        }
        for (int i = 0; i < paramCount1; ++i) {
            WurstType type2;
            WurstType type1 = func1.getParameterType(i);
            if (type1.isSupertypeOf(type2 = func2.getParameterType(i), func1.getDef())) continue;
            return "Parameter " + type1 + " " + func1.getParameterName(i) + " should have type " + type2 + " to override " + Utils.printElementWithSource(Optional.of(func2.getDef())) + ".";
        }
        if (!func1.getReturnType().isSubtypeOf(func2.getReturnType(), func1.getDef())) {
            return "Return type should be " + func2.getReturnType() + " to override " + Utils.printElementWithSource(Optional.of(func2.getDef())) + ".";
        }
        return null;
    }

    private void checkForDuplicateNames(WScope scope) {
        ImmutableMultimap<String, DefLink> links = scope.attrNameLinks();
        for (String name : links.keySet()) {
            ImmutableCollection nameLinks = links.get((Object)name);
            if (nameLinks.size() <= 1) continue;
            ArrayList funcs = null;
            List other = null;
            for (NameLink nl : nameLinks) {
                if (nl.getDefinedIn() != scope) continue;
                if (nl instanceof FuncLink) {
                    if (funcs == null) {
                        funcs = Lists.newArrayList();
                    }
                    FuncLink funcLink = (FuncLink)nl;
                    for (FuncLink link : funcs) {
                        if (this.distinctFunctions(funcLink, link)) continue;
                        funcLink.getDef().addError("Function already defined : " + Utils.printElementWithSource(Optional.of(link.getDef())));
                        link.getDef().addError("Function already defined : " + Utils.printElementWithSource(Optional.of(funcLink.getDef())));
                    }
                    funcs.add(funcLink);
                    continue;
                }
                if (other == null) {
                    other = Lists.newArrayList();
                }
                other.add(nl);
            }
            if (other == null || other.size() <= 1) continue;
            other.sort(Comparator.comparingInt(o -> o.getDef().attrSource().getLeftPos()));
            NameLink l1 = (NameLink)other.get(0);
            for (int j = 1; j < other.size(); ++j) {
                ((NameLink)other.get(j)).getDef().addError("An element with name " + name + " already exists: " + Utils.printElementWithSource(Optional.of(l1.getDef())));
            }
        }
    }

    private boolean distinctFunctions(FuncLink nl1, FuncLink nl2) {
        if (this.receiverTypesDifferent(nl1, nl2)) {
            return true;
        }
        FunctionDefinition f1 = nl1.getDef();
        FunctionDefinition f2 = nl2.getDef();
        WParameters ps1 = f1.getParameters();
        WParameters ps2 = f2.getParameters();
        if (ps1.size() != ps2.size()) {
            return true;
        }
        return this.parametersTypeDisjunct(ps1, ps2);
    }

    private boolean receiverTypesDifferent(FuncLink nl1, FuncLink nl2) {
        if (nl1.getReceiverType() == null) {
            return nl2.getReceiverType() != null;
        }
        return nl2.getReceiverType() == null || !nl1.getReceiverType().equalsType(nl2.getReceiverType(), nl1.getDef());
    }

    private void checkForDuplicateImports(WPackage p) {
        LinkedHashSet imports = Sets.newLinkedHashSet();
        for (WImport imp : p.getImports()) {
            if (imports.add(imp.getPackagename())) continue;
            imp.addError("The package " + imp.getPackagename() + " is already imported.");
        }
    }

    private void checkVarDef(VarDef v) {
        GlobalOrLocalVarDef g;
        WurstType vtype = v.attrTyp();
        if (vtype instanceof WurstTypeCode && v.attrIsDynamicClassMember()) {
            v.addError("Code members not allowed as dynamic class members (variable " + v.getName() + ")\nTry using a trigger or conditionfunc instead.");
        }
        if (v instanceof GlobalOrLocalVarDef && (g = (GlobalOrLocalVarDef)v).attrIsConstant() && g.getInitialExpr() instanceof NoExpr && !g.attrIsDynamicClassMember()) {
            g.addError("Constant variable " + g.getName() + " needs an initial value.");
        }
        if (vtype instanceof WurstTypeArray) {
            WurstTypeArray wta = (WurstTypeArray)vtype;
            switch (wta.getDimensions()) {
                case 0: {
                    v.addError("0-dimensional arrays are not allowed");
                    break;
                }
                case 1: {
                    if (!v.attrIsDynamicClassMember() || wta.getSize(0) > 0) break;
                    v.addError("Array members require a fixed size greater 0.");
                    break;
                }
                default: {
                    v.addError("Multidimensional Arrays are not yet supported.");
                }
            }
        }
        if (vtype instanceof WurstTypeNull) {
            v.addError("Initial value of variable " + v.getName() + " is 'null'. Specify a concrete type.");
        }
    }

    private void checkLocalShadowing(LocalVarDef v) {
        NameLink shadowed = v.getParent().getParent().lookupVar(v.getName(), false);
        if (shadowed != null) {
            if (shadowed.getDef() instanceof LocalVarDef) {
                v.addError("Variable " + v.getName() + " hides an other local variable with the same name.");
            } else if (shadowed.getDef() instanceof WParameter) {
                v.addError("Variable " + v.getName() + " hides a parameter with the same name.");
            }
        }
    }

    private void checkConstructorSuperCall(ConstructorDef c) {
        ClassDef classDef;
        if (c.getSuperConstructorCall() instanceof SomeSuperConstructorCall && c.attrNearestClassDef() != null && (classDef = c.attrNearestClassDef()).getExtendedClass() instanceof NoTypeExpr) {
            c.addError("Super call in a class which extends nothing.");
        }
    }

    private void checkParameter(WParameter param) {
        if (param.attrTyp() instanceof WurstTypeArray) {
            param.addError("Cannot use arrays as parameters.");
        }
    }
}

