/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.interpreter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.peeeq.wurstio.jassinterpreter.InterpreterException;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstArray;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;
import de.peeeq.wurstscript.intermediatelang.ILconstObject;
import de.peeeq.wurstscript.intermediatelang.IlConstHandle;
import de.peeeq.wurstscript.intermediatelang.interpreter.ILStackFrame;
import de.peeeq.wurstscript.intermediatelang.interpreter.LocalState;
import de.peeeq.wurstscript.intermediatelang.interpreter.NativesProvider;
import de.peeeq.wurstscript.intermediatelang.interpreter.State;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImCompiletimeExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.utils.LineOffsets;
import de.peeeq.wurstscript.utils.Utils;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ProgramState
extends State {
    public static final int GENERATED_BY_WURST = 42;
    private Element lastStatement;
    protected WurstGui gui;
    private PrintStream outStream = System.err;
    private final List<NativesProvider> nativeProviders = Lists.newArrayList();
    private ImProg prog;
    private int objectIdCounter;
    private final HashMap<Integer, ILconstObject> indexToObject = new HashMap();
    private final Deque<ILStackFrame> stackFrames = new ArrayDeque<ILStackFrame>();
    private final Deque<Element> lastStatements = new ArrayDeque<Element>();
    private final boolean isCompiletime;
    private final HashMap<Integer, IlConstHandle> handleMap = new HashMap();

    public ProgramState(WurstGui gui, ImProg prog, boolean isCompiletime) {
        this.gui = gui;
        this.prog = prog;
        this.isCompiletime = isCompiletime;
    }

    public void setLastStatement(ImStmt s) {
        this.lastStatement = s;
    }

    public Element getLastStatement() {
        return this.lastStatement;
    }

    public WurstGui getGui() {
        return this.gui;
    }

    public void writeBack(boolean injectObjects) {
    }

    public PrintStream getOutStream() {
        return this.outStream;
    }

    public void setOutStream(PrintStream os) {
        this.outStream = os;
        for (NativesProvider natives : this.nativeProviders) {
            natives.setOutStream(os);
        }
    }

    public void addNativeProvider(NativesProvider np) {
        np.setOutStream(this.outStream);
        this.nativeProviders.add(np);
    }

    public Iterable<NativesProvider> getNativeProviders() {
        return this.nativeProviders;
    }

    public ProgramState setProg(ImProg p) {
        this.prog = p;
        return this;
    }

    public ImProg getProg() {
        return this.prog;
    }

    public ILconstObject allocate(ImClassType clazz, de.peeeq.wurstscript.ast.Element trace) {
        ++this.objectIdCounter;
        ILconstObject res = new ILconstObject(clazz, this.objectIdCounter, trace);
        this.indexToObject.put(this.objectIdCounter, res);
        return res;
    }

    protected Object classKey(ImClass clazz) {
        return clazz;
    }

    public void deallocate(ILconstObject obj, ImClass clazz, de.peeeq.wurstscript.ast.Element trace) {
        this.assertAllocated(obj, trace);
        obj.destroy();
    }

    public void assertAllocated(ILconstObject obj, de.peeeq.wurstscript.ast.Element trace) {
        if (obj == null) {
            throw new InterpreterException(trace, "Null pointer dereference");
        }
        if (obj.isDestroyed()) {
            throw new InterpreterException(trace, "Object already destroyed");
        }
    }

    public boolean isInstanceOf(ILconstObject obj, ImClass clazz, de.peeeq.wurstscript.ast.Element trace) {
        if (obj == null) {
            return false;
        }
        this.assertAllocated(obj, trace);
        return obj.getImClass().isSubclassOf(clazz);
    }

    public int getTypeId(ILconstObject obj, de.peeeq.wurstscript.ast.Element trace) {
        this.assertAllocated(obj, trace);
        return obj.getImClass().attrTypeId();
    }

    private ImClass findClazz(Object key) {
        for (ImClass c : this.prog.getClasses()) {
            if (!this.classKey(c).equals(key)) continue;
            return c;
        }
        throw new Error("no class found for key " + key);
    }

    public void pushStackframe(ImFunction f, ILconst[] args, WPos trace) {
        this.stackFrames.push(new ILStackFrame(f, args, trace));
        Element stmt = this.lastStatement;
        if (stmt == null) {
            stmt = f;
        }
        this.lastStatements.push(stmt);
    }

    public void pushStackframe(ImCompiletimeExpr f, WPos trace) {
        this.stackFrames.push(new ILStackFrame(f, trace));
        Element stmt = this.lastStatement;
        if (stmt == null) {
            stmt = f;
        }
        this.lastStatements.push(stmt);
    }

    public void popStackframe() {
        if (!this.stackFrames.isEmpty()) {
            this.stackFrames.pop();
        }
        if (!this.lastStatements.isEmpty()) {
            this.lastStatement = this.lastStatements.pop();
        }
    }

    public void resetStackframes() {
        this.stackFrames.clear();
        this.lastStatements.clear();
    }

    public StackTrace getStackFrames() {
        return new StackTrace(this.stackFrames);
    }

    public void compilationError(String errorMessage) {
        Element lastStatement = this.getLastStatement();
        if (lastStatement != null) {
            WPos source = lastStatement.attrTrace().attrSource();
            this.getGui().sendError(new CompileError(source, errorMessage));
        } else {
            this.getGui().sendError(new CompileError(new WPos("", new LineOffsets(), 0, 0), errorMessage));
        }
        for (ILStackFrame sf : Utils.iterateReverse(this.getStackFrames().getStackFrames())) {
            this.getGui().sendError(sf.makeCompileError());
        }
    }

    public ILconst getObjectByIndex(int val) {
        return this.indexToObject.get(val);
    }

    public HashMap<Integer, IlConstHandle> getHandleMap() {
        return this.handleMap;
    }

    public ILconst getHandleByIndex(int val) {
        return this.handleMap.get(val);
    }

    public ILconstObject toObject(ILconst val) {
        if (val instanceof ILconstObject) {
            return (ILconstObject)val;
        }
        if (val instanceof ILconstInt) {
            return this.indexToObject.get(((ILconstInt)val).getVal());
        }
        throw new InterpreterException(this, "Value " + val + " (" + val.getClass().getSimpleName() + ") cannot be cast to object.");
    }

    public boolean isCompiletime() {
        return this.isCompiletime;
    }

    @Override
    protected ILconstArray getArray(ImVar v) {
        ILconstArray r = (ILconstArray)this.arrayValues.get(v);
        if (r == null) {
            ImType vType = v.getType();
            r = ProgramState.createArrayConstantFromType(vType);
            this.arrayValues.put(v, r);
            List<ImSet> e = this.prog.getGlobalInits().get(v);
            if (e != null) {
                LocalState ls = new LocalState();
                for (int i = 0; i < e.size(); ++i) {
                    ILconst val = e.get(i).getRight().evaluate(this, ls);
                    r.set(i, val);
                }
            }
        }
        return r;
    }

    public Collection<ILconstObject> getAllObjects() {
        return this.indexToObject.values();
    }

    public static class StackTrace {
        private final List<ILStackFrame> stackFrames;

        public StackTrace(Deque<ILStackFrame> stackFrames) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ILStackFrame stackFrame : stackFrames) {
                builder.add((Object)stackFrame);
            }
            this.stackFrames = builder.build();
        }

        public void appendTo(StringBuilder sb) {
            for (ILStackFrame stackFrame : this.stackFrames) {
                sb.append(stackFrame.getMessage());
                sb.append("\n");
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }

        public List<ILStackFrame> getStackFrames() {
            return this.stackFrames;
        }

        public Iterable<ILStackFrame> getStackFramesReversed() {
            return () -> {
                final ListIterator<ILStackFrame> it = this.stackFrames.listIterator();
                return new Iterator<ILStackFrame>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasPrevious();
                    }

                    @Override
                    public ILStackFrame next() {
                        return (ILStackFrame)it.previous();
                    }
                };
            };
        }
    }
}

