/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.objs;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataList;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.CombatTarget;
import net.moonlightflower.wc3libs.dataTypes.app.DefType;
import net.moonlightflower.wc3libs.dataTypes.app.DestructableId;
import net.moonlightflower.wc3libs.dataTypes.app.DoodadClass;
import net.moonlightflower.wc3libs.dataTypes.app.Model;
import net.moonlightflower.wc3libs.dataTypes.app.PathingTex;
import net.moonlightflower.wc3libs.dataTypes.app.ShadowTex;
import net.moonlightflower.wc3libs.dataTypes.app.SoundLabel;
import net.moonlightflower.wc3libs.dataTypes.app.Tileset;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.SLK;

public class DestructableSLK
extends ObjSLK<DestructableSLK, DestructableId, Obj> {
    public static final File GAME_PATH = new File("Units\\DestructableData.slk");

    @Override
    @Nonnull
    public Map<DestructableId, Obj> getObjs() {
        return this._objs;
    }

    @Override
    public void addObj(@Nonnull Obj val) {
        this._objs.put((DestructableId)val.getId(), val);
    }

    @Override
    @Nonnull
    public Obj addObj(@Nonnull DestructableId id) {
        if (this._objs.containsKey(id)) {
            return (Obj)this._objs.get(id);
        }
        Obj obj = new Obj(id);
        this.addObj(obj);
        return obj;
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            this.addObj(obj);
        }
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        super.read(file);
    }

    @Override
    public void write(@Nonnull File file) throws IOException {
        super.write(file);
    }

    public DestructableSLK(SLK slk) {
        this.read(slk);
    }

    public DestructableSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values(State.class)) {
            this.addField(state);
        }
    }

    public DestructableSLK(File file) throws IOException {
        this();
        this.read(file);
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(DestructableId.valueOf(id));
    }

    @Override
    public void merge(@Nonnull DestructableSLK other, boolean overwrite) {
        for (Map.Entry<DestructableId, Obj> objEntry : other.getObjs().entrySet()) {
            DestructableId objId = objEntry.getKey();
            Obj otherObj = objEntry.getValue();
            Obj obj = this.addObj(objId);
            obj.merge(otherObj);
        }
    }

    public static class Obj
    extends SLK.Obj<DestructableId> {
        private final Map<State, DataType> _stateVals = new LinkedHashMap<State, DataType>();

        @Override
        public Map<State, DataType> getStateVals() {
            return new LinkedHashMap<State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public <T extends DataType> T get(State<T> state) {
            try {
                if (!super.contains((FieldId)state.getFieldId())) {
                    return state.getDefVal();
                }
                return state.tryCastVal(super.get((FieldId)state.getFieldId()));
            }
            catch (DataTypeInfo.CastException castException) {
                return null;
            }
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set((FieldId)state.getFieldId(), (DataType)val);
        }

        private void read(SLK.Obj<? extends ObjId> slkObj) {
            this.merge(slkObj, true);
        }

        public Obj(SLK.Obj<? extends ObjId> slkObj) {
            super(DestructableId.valueOf(slkObj.getId()));
            this.read(slkObj);
        }

        public Obj(DestructableId id) {
            super(id);
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<DestructableId> OBJ_ID = new State<DestructableId>("DestructableID", DestructableId.class);
        public static final State<War3String> CATEGORY = new State<War3String>("category", War3String.class);
        public static final State<DataList<Tileset>> TILESETS = new State("tilesets", new DataTypeInfo((Class<? extends DataType>)DataList.class, (Class<? extends DataType>)Tileset.class));
        public static final State<War3Bool> TILESET_SPECIFIC = new State<War3Bool>("tilesetSpecific", War3Bool.class);
        public static final State<Model> MODEL = new State<Model>("file", Model.class);
        public static final State<War3Bool> LIGHTWEIGHT = new State<War3Bool>("lightweight", War3Bool.class);
        public static final State<War3Bool> FAT_LINE_OF_SIGHT = new State<War3Bool>("fatLOS", War3Bool.class);
        public static final State<War3Int> TEX_ID = new State<War3Int>("texID", War3Int.class);
        public static final State<War3String> TEX_FILE = new State<War3String>("texFile", War3String.class);
        public static final State<War3String> COMMENT = new State<War3String>("comment", War3String.class);
        public static final State<War3String> NAME = new State<War3String>("Name", War3String.class);
        public static final State<War3String> EDITOR_SUFFIX = new State<War3String>("EditorSuffix", War3String.class);
        public static final State<DoodadClass> DOOD_CLASS = new State<DoodadClass>("doodClass", DoodadClass.class);
        public static final State<War3Bool> USE_CLICK_HELPER = new State<War3Bool>("useClickHelper", War3Bool.class);
        public static final State<War3Bool> ON_CLIFFS = new State<War3Bool>("onCliffs", War3Bool.class);
        public static final State<War3Bool> ON_WATER = new State<War3Bool>("onWater", War3Bool.class);
        public static final State<War3Bool> CAN_PLACE_DEAD = new State<War3Bool>("canPlaceDead", War3Bool.class);
        public static final State<War3Bool> WALKABLE = new State<War3Bool>("walkable", War3Bool.class);
        public static final State<War3Int> CLIFF_HEIGHT = new State<War3Int>("CLIFF_HEIGHT", War3Int.class);
        public static final State<DataList<CombatTarget>> TARGS = new State("targType", new DataTypeInfo((Class<? extends DataType>)DataList.class, (Class<? extends DataType>)CombatTarget.class));
        public static final State<DefType> ARMOR_TYPE = new State<DefType>("armor", DefType.class);
        public static final State<War3Int> VARIATION_COUNT = new State<War3Int>("numVar", War3Int.class);
        public static final State<War3Int> LIFE = new State<War3Int>("HP", War3Int.class);
        public static final State<War3Real> OCCLUSION_HEIGHT = new State<War3Real>("occH", War3Real.class);
        public static final State<War3Real> FLY_HEIGHT = new State<War3Real>("flyH", War3Real.class);
        public static final State<War3Real> FIXED_ROTATION = new State<War3Real>("fixedRot", War3Real.class);
        public static final State<War3Real> SELECTION_SCALE_EDITOR = new State<War3Real>("selSize", War3Real.class);
        public static final State<War3Real> SCALE_MIN = new State<War3Real>("minScale", War3Real.class);
        public static final State<War3Real> SCALE_MAX = new State<War3Real>("maxScale", War3Real.class);
        public static final State<War3Bool> CAN_PLACE_RANDOM_SCALE = new State<War3Bool>("canPlaceRandScale", War3Bool.class);
        public static final State<War3Real> PITCH_MAX = new State<War3Real>("maxPitch", War3Real.class);
        public static final State<War3Real> ROLL_MAX = new State<War3Real>("maxRoll", War3Real.class);
        public static final State<War3Real> ELEV_RAD = new State<War3Real>("radius", War3Real.class);
        public static final State<War3Real> FOG_RAD = new State<War3Real>("fogRadius", War3Real.class);
        public static final State<War3Bool> FOG_VISIBILITY = new State<War3Bool>("fogVis", War3Bool.class);
        public static final State<PathingTex> PATH_TEX = new State<PathingTex>("pathTex", PathingTex.class);
        public static final State<PathingTex> PATH_TEX_DEAD = new State<PathingTex>("pathTexDeath", PathingTex.class);
        public static final State<SoundLabel> SOUND_DEATH = new State<SoundLabel>("deathSnd", SoundLabel.class);
        public static final State<ShadowTex> SHADOW_TEX = new State<ShadowTex>("shadow", ShadowTex.class);
        public static final State<War3Bool> MINIMAP_SHOW = new State<War3Bool>("showInMM", War3Bool.class);
        public static final State<War3Bool> MINIMAP_USE_COLOR = new State<War3Bool>("useMMColor", War3Bool.class);
        public static final State<War3Int> MINIMAP_COLOR_RED = new State<War3Int>("MMRed", War3Int.class);
        public static final State<War3Int> MINIMAP_COLOR_GREEN = new State<War3Int>("MMGreen", War3Int.class);
        public static final State<War3Int> MINIMAP_COLOR_BLUE = new State<War3Int>("MMBlue", War3Int.class);
        public static final State<War3Int> COLOR_RED = new State<War3Int>("colorR", War3Int.class);
        public static final State<War3Int> COLOR_GREEN = new State<War3Int>("colorG", War3Int.class);
        public static final State<War3Int> COLOR_BLUE = new State<War3Int>("colorB", War3Int.class);
        public static final State<War3Int> BUILD_TIME = new State<War3Int>("buildTime", War3Int.class);
        public static final State<War3Int> REPAIR_TIME = new State<War3Int>("repairTime", War3Int.class);
        public static final State<War3Int> COSTS_GOLD_REPAIR = new State<War3Int>("goldRep", War3Int.class);
        public static final State<War3Int> COSTS_LUMBER_REPAIR = new State<War3Int>("lumberRep", War3Int.class);
        public static final State<War3Bool> IN_USER_LIST = new State<War3Bool>("UserList", War3Bool.class);
        public static final State<War3Bool> IN_BETA = new State<War3Bool>("InBeta", War3Bool.class);
        public static final State<War3Int> VERSION = new State<War3Int>("version", War3Int.class);
        public static final State<War3Bool> SELECTABLE = new State<War3Bool>("selectable", War3Bool.class);
        public static final State<War3Real> SELECTION_SCALE_GAME = new State<War3Real>("selcircsize", War3Real.class);
        public static final State<Model> MODEL_PORTRAIT = new State<Model>("portraitmodel", Model.class);

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            super(idString, type);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            super(idString, type, defVal);
        }
    }
}

