/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3.security;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import systems.crigges.jmpq3.security.CryptographicLUT;

public class MPQHashGenerator {
    private int seed1;
    private int seed2;
    private final CryptographicLUT lut;

    private MPQHashGenerator(CryptographicLUT lut) {
        this.reset();
        this.lut = lut;
    }

    public void reset() {
        this.seed1 = 2146271213;
        this.seed2 = -286331154;
    }

    public void process(String src) {
        this.process(ByteBuffer.wrap(src.toUpperCase().getBytes(StandardCharsets.UTF_8)));
    }

    public void process(ByteBuffer src) {
        while (src.hasRemaining()) {
            byte value = src.get();
            this.seed1 = this.lut.lookup(value) ^ this.seed1 + this.seed2;
            this.seed2 = Byte.toUnsignedInt(value) + this.seed1 + this.seed2 + (this.seed2 << 5) + 3;
        }
    }

    public int getHash() {
        return this.seed1;
    }

    public static MPQHashGenerator getTableOffsetGenerator() {
        return new MPQHashGenerator(CryptographicLUT.HASH_TABLE_OFFSET);
    }

    public static MPQHashGenerator getTableKey1Generator() {
        return new MPQHashGenerator(CryptographicLUT.HASH_TABLE_KEY1);
    }

    public static MPQHashGenerator getTableKey2Generator() {
        return new MPQHashGenerator(CryptographicLUT.HASH_TABLE_KEY2);
    }

    public static MPQHashGenerator getFileKeyGenerator() {
        return new MPQHashGenerator(CryptographicLUT.HASH_ENCRYPTION_KEY);
    }
}

