@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  wurstscript startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
@rem This is normally unused
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and WURSTSCRIPT_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\wurstscript.jar;%APP_HOME%\lib\wc3libs-01fb9e23bf.jar;%APP_HOME%\lib\antlr4-4.13.1.jar;%APP_HOME%\lib\wurstsetup-475cc7fae8.jar;%APP_HOME%\lib\PeParser-3.3.jar;%APP_HOME%\lib\SwingDarkFlatTable-1d9ae26e69.jar;%APP_HOME%\lib\Collections-2.4.jar;%APP_HOME%\lib\HexUtilities-1.1.jar;%APP_HOME%\lib\ByteUtilities-2.0.jar;%APP_HOME%\lib\Utilities-1.46.jar;%APP_HOME%\lib\OS-1.8.jar;%APP_HOME%\lib\Updates-1.1.jar;%APP_HOME%\lib\kotlin-logging-jvm-3.0.5.jar;%APP_HOME%\lib\kotlinx-coroutines-core-jvm-1.7.3.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-1.9.10.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.15.3.jar;%APP_HOME%\lib\jackson-databind-2.15.3.jar;%APP_HOME%\lib\jackson-annotations-2.15.3.jar;%APP_HOME%\lib\jackson-core-2.15.3.jar;%APP_HOME%\lib\jackson-module-kotlin-2.15.3.jar;%APP_HOME%\lib\kotlin-reflect-1.5.32.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-1.9.10.jar;%APP_HOME%\lib\kotlin-stdlib-1.9.10.jar;%APP_HOME%\lib\annotations-23.0.0.jar;%APP_HOME%\lib\guava-32.1.3-jre.jar;%APP_HOME%\lib\vavr-0.10.4.jar;%APP_HOME%\lib\org.eclipse.lsp4j-0.21.1.jar;%APP_HOME%\lib\org.eclipse.jdt.annotation-2.1.0.jar;%APP_HOME%\lib\org.eclipse.lsp4j.jsonrpc-0.21.1.jar;%APP_HOME%\lib\gson-2.10.1.jar;%APP_HOME%\lib\velocity-1.7.jar;%APP_HOME%\lib\juniversalchardet-2.4.0.jar;%APP_HOME%\lib\jmpq3-264c54cfc8.jar;%APP_HOME%\lib\logback-classic-1.4.11.jar;%APP_HOME%\lib\org.eclipse.jgit.ssh.apache-6.7.0.202309050840-r.jar;%APP_HOME%\lib\org.eclipse.jgit-6.7.0.202309050840-r.jar;%APP_HOME%\lib\sshd-osgi-2.10.0.jar;%APP_HOME%\lib\sshd-sftp-2.10.0.jar;%APP_HOME%\lib\jcl-over-slf4j-1.7.32.jar;%APP_HOME%\lib\java-uuid-generator-4.2.0.jar;%APP_HOME%\lib\slf4j-api-2.0.7.jar;%APP_HOME%\lib\antlr4-runtime-4.13.1.jar;%APP_HOME%\lib\ST4-4.3.4.jar;%APP_HOME%\lib\antlr-runtime-3.5.3.jar;%APP_HOME%\lib\org.abego.treelayout.core-1.0.3.jar;%APP_HOME%\lib\icu4j-72.1.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\checker-qual-3.37.0.jar;%APP_HOME%\lib\error_prone_annotations-2.21.1.jar;%APP_HOME%\lib\vavr-match-0.10.4.jar;%APP_HOME%\lib\commons-collections-3.2.1.jar;%APP_HOME%\lib\commons-lang-2.4.jar;%APP_HOME%\lib\jzlib-1.1.3.jar;%APP_HOME%\lib\commons-compress-1.24.0.jar;%APP_HOME%\lib\CafeUndZopfli-5cdf283e67.jar;%APP_HOME%\lib\xz-1.9.jar;%APP_HOME%\lib\PeParser-Dorkbox-Util-2.7.jar;%APP_HOME%\lib\imageio-jpeg-3.9.4.jar;%APP_HOME%\lib\resty-0.3.2.jar;%APP_HOME%\lib\SimpleRegistry-f96dda96bd.jar;%APP_HOME%\lib\logback-core-1.4.11.jar;%APP_HOME%\lib\JavaEWAH-1.2.3.jar;%APP_HOME%\lib\commons-codec-1.16.0.jar;%APP_HOME%\lib\eddsa-0.3.0.jar;%APP_HOME%\lib\imageio-metadata-3.9.4.jar;%APP_HOME%\lib\imageio-core-3.9.4.jar;%APP_HOME%\lib\common-image-3.9.4.jar;%APP_HOME%\lib\common-io-3.9.4.jar;%APP_HOME%\lib\common-lang-3.9.4.jar;%APP_HOME%\lib\javacc-4.1.jar;%APP_HOME%\lib\snakeyaml-2.1.jar;%APP_HOME%\lib\kotlin-stdlib-common-1.9.10.jar


@rem Execute wurstscript
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %WURSTSCRIPT_OPTS%  -classpath "%CLASSPATH%" de.peeeq.wurstio.Main %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable WURSTSCRIPT_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%WURSTSCRIPT_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
