/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.Bin;
import net.moonlightflower.wc3libs.bin.BinState;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;

public class W3S {
    public static final File GAME_PATH = new File("war3map.W3S");
    private List<Sound> _sounds = new ArrayList<Sound>();

    @Nonnull
    public List<Sound> getSounds() {
        return new ArrayList<Sound>(this._sounds);
    }

    private void addSound(@Nonnull Sound val) {
        this._sounds.add(val);
    }

    @Nonnull
    public Sound addSound() {
        Sound sound = new Sound();
        this.addSound(sound);
        return sound;
    }

    public void read_0x1(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.W3S_0x1.getVersion(), version);
        int soundsCount = stream.readInt32("soundsCount");
        for (int i = 0; i < soundsCount; ++i) {
            this.addSound(new Sound(stream, EncodingFormat.W3S_0x1));
        }
    }

    public void write_0x1(@Nonnull Wc3BinOutputStream stream) {
        stream.writeInt32(EncodingFormat.W3S_0x1.getVersion());
        stream.writeInt32(this._sounds.size());
        for (Sound sound : this._sounds) {
            sound.write(stream, EncodingFormat.W3S_0x1);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32();
        stream.rewind();
        this.read(stream, stream.getFormat(EncodingFormat.class, version));
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case W3S_0x1: {
                this.read_0x1(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case W3S_0x1: 
            case AUTO: {
                this.write_0x1(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    private void read(@Nonnull File file, @Nonnull EncodingFormat format) throws IOException {
        this.read(new Wc3BinInputStream(file), format);
    }

    public void write(@Nonnull File file, @Nonnull EncodingFormat format) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream, format);
        outStream.close();
    }

    private void read(@Nonnull File file) throws IOException {
        this.read(file, EncodingFormat.AUTO);
    }

    public void write(@Nonnull File file) throws IOException {
        this.write(new Wc3BinOutputStream(file));
    }

    public W3S() {
    }

    public W3S(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream);
    }

    public W3S(@Nonnull File file) throws IOException {
        this.read(file);
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat W3S_0x1 = new EncodingFormat(Enum.W3S_0x1, 1);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            W3S_0x1;

        }
    }

    public static class Sound
    extends Bin {
        public static final State<War3String> DATA_FILE_PATH = new State<War3String>(War3String.class, "filePath");
        public static final State<War3String> DATA_EAX = new State<War3String>(War3String.class, "eax");
        public static final State<War3Int> DATA_FLAGS = new State<War3Int>(War3Int.class, "flags");
        public static final State<War3Int> DATA_FADE_IN = new State<War3Int>(War3Int.class, "fadeIn");
        public static final State<War3Int> DATA_FADE_OUT = new State<War3Int>(War3Int.class, "fadeOut");
        public static final State<War3Int> DATA_VOLUME = new State<War3Int>(War3Int.class, "volume");
        public static final State<War3Real> DATA_PITCH = new State<War3Real>(War3Real.class, "pitch");
        public static final State<War3Real> DATA_UNKNOWN_A = new State<War3Real>(War3Real.class, "unknownA");
        public static final State<War3Int> DATA_UNKNOWN_B = new State<War3Int>(War3Int.class, "unknownB");
        public static final State<War3Int> DATA_CHANNEL = new State<War3Int>(War3Int.class, "channel");
        public static final State<War3Real> DATA_DIST_MIN = new State<War3Real>(War3Real.class, "distMin");
        public static final State<War3Real> DATA_DIST_MAX = new State<War3Real>(War3Real.class, "distMax");
        public static final State<War3Real> DATA_DIST_CUTOFF = new State<War3Real>(War3Real.class, "cutoff");
        public static final State<War3Real> DATA_UNKNOWN_C = new State<War3Real>(War3Real.class, "unknownC");
        public static final State<War3Real> DATA_UNKNOWN_D = new State<War3Real>(War3Real.class, "unknownD");
        public static final State<War3Int> DATA_UNKNOWN_E = new State<War3Int>(War3Int.class, "unknownE");
        public static final State<War3Real> DATA_UNKNOWN_F = new State<War3Real>(War3Real.class, "unknownF");
        public static final State<War3Real> DATA_UNKNOWN_G = new State<War3Real>(War3Real.class, "unknownG");
        public static final State<War3Real> DATA_UNKNOWN_H = new State<War3Real>(War3Real.class, "unknownH");
        public static final State<War3String> TEXT_VAR_NAME = new State<War3String>(War3String.class, "varName", War3String.valueOf("unnamed"));
        public Float FLOAT_DEFAULT = Float.valueOf(ByteBuffer.wrap(new byte[]{79, -128, 0, 0}).order(ByteOrder.LITTLE_ENDIAN).getFloat());
        private Function<Float, War3Real> FLOAT_READ_FUNC = val -> {
            if (val.equals(this.FLOAT_DEFAULT)) {
                return null;
            }
            return War3Real.valueOf(val);
        };
        private Function<War3Real, Float> FLOAT_WRITE_FUNC = val -> {
            if (val == null) {
                return this.FLOAT_DEFAULT;
            }
            return val.getVal();
        };
        public static final Integer VOLUME_DEFAULT = -1;
        private Function<Integer, War3Int> VOLUME_READ_FUNC = val -> {
            if (val.equals(VOLUME_DEFAULT)) {
                return null;
            }
            return War3Int.valueOf(val);
        };
        private Function<War3Int, Integer> VOLUME_WRITE_FUNC = val -> {
            if (val == null) {
                return VOLUME_DEFAULT;
            }
            return val.getVal();
        };

        public <T extends DataType> T get(State<T> state) {
            try {
                return state.tryCastVal(super.get(state));
            }
            catch (DataTypeInfo.CastException castException) {
                return null;
            }
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set(state, val);
        }

        public <T extends DataType> void reset(State<T> state) {
            super.set((BinState<?>)state, (DataType)state.getDefVal());
        }

        public void init() {
            for (State state : State.values()) {
                ((Bin)this).set(state, (DataType)state.getDefVal());
            }
        }

        public void read_0x1(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.set(TEXT_VAR_NAME, (DataType)War3String.valueOf(stream.readString("varName")));
            this.set(DATA_FILE_PATH, (DataType)War3String.valueOf(stream.readString("filePath")));
            this.set(DATA_EAX, (DataType)War3String.valueOf(stream.readString("eax")));
            this.set(DATA_FLAGS, (DataType)War3Int.valueOf(stream.readInt32("flags")));
            this.set(DATA_FADE_IN, (DataType)War3Int.valueOf(stream.readInt32("fadeIn")));
            this.set(DATA_FADE_OUT, (DataType)War3Int.valueOf(stream.readInt32("fadeOut")));
            this.set(DATA_VOLUME, (DataType)this.VOLUME_READ_FUNC.apply(stream.readInt32("volume")));
            this.set(DATA_PITCH, (DataType)this.FLOAT_READ_FUNC.apply(stream.readFloat32("pitch")));
            this.set(DATA_UNKNOWN_A, (DataType)this.FLOAT_READ_FUNC.apply(stream.readFloat32("unknownA")));
            this.set(DATA_UNKNOWN_B, (DataType)War3Int.valueOf(stream.readInt32("unknownB")));
            this.set(DATA_CHANNEL, (DataType)War3Int.valueOf(stream.readInt32("channel")));
            this.set(DATA_DIST_MIN, (DataType)this.FLOAT_READ_FUNC.apply(stream.readFloat32("distMin")));
            this.set(DATA_DIST_MAX, (DataType)this.FLOAT_READ_FUNC.apply(stream.readFloat32("distMax")));
            this.set(DATA_DIST_CUTOFF, (DataType)this.FLOAT_READ_FUNC.apply(stream.readFloat32("distCutoff")));
            this.set(DATA_UNKNOWN_C, (DataType)this.FLOAT_READ_FUNC.apply(stream.readFloat32("unknownC")));
            this.set(DATA_UNKNOWN_D, (DataType)this.FLOAT_READ_FUNC.apply(stream.readFloat32("unknownD")));
            this.set(DATA_UNKNOWN_E, (DataType)War3Int.valueOf(stream.readInt32("unknownE")));
            this.set(DATA_UNKNOWN_F, (DataType)this.FLOAT_READ_FUNC.apply(stream.readFloat32("unknownF")));
            this.set(DATA_UNKNOWN_G, (DataType)this.FLOAT_READ_FUNC.apply(stream.readFloat32("unknownG")));
            this.set(DATA_UNKNOWN_H, (DataType)this.FLOAT_READ_FUNC.apply(stream.readFloat32("unknownH")));
        }

        public void write_0x1(@Nonnull Wc3BinOutputStream stream) {
            stream.writeString(this.get(TEXT_VAR_NAME));
            stream.writeString(this.get(DATA_FILE_PATH));
            stream.writeString(this.get(DATA_EAX));
            stream.writeInt32(this.get(DATA_FLAGS));
            stream.writeInt32(this.get(DATA_FADE_IN));
            stream.writeInt32(this.get(DATA_FADE_OUT));
            stream.writeInt32(this.VOLUME_WRITE_FUNC.apply(this.get(DATA_VOLUME)));
            stream.writeFloat32(this.FLOAT_WRITE_FUNC.apply(this.get(DATA_PITCH)).floatValue());
            stream.writeFloat32(this.FLOAT_WRITE_FUNC.apply(this.get(DATA_UNKNOWN_A)).floatValue());
            stream.writeInt32(this.get(DATA_UNKNOWN_B));
            stream.writeInt32(this.get(DATA_CHANNEL));
            stream.writeFloat32(this.FLOAT_WRITE_FUNC.apply(this.get(DATA_DIST_MIN)).floatValue());
            stream.writeFloat32(this.FLOAT_WRITE_FUNC.apply(this.get(DATA_DIST_MAX)).floatValue());
            stream.writeFloat32(this.FLOAT_WRITE_FUNC.apply(this.get(DATA_DIST_CUTOFF)).floatValue());
            stream.writeFloat32(this.FLOAT_WRITE_FUNC.apply(this.get(DATA_UNKNOWN_C)).floatValue());
            stream.writeFloat32(this.FLOAT_WRITE_FUNC.apply(this.get(DATA_UNKNOWN_D)).floatValue());
            stream.writeInt32(this.get(DATA_UNKNOWN_E));
            stream.writeFloat32(this.FLOAT_WRITE_FUNC.apply(this.get(DATA_UNKNOWN_F)).floatValue());
            stream.writeFloat32(this.FLOAT_WRITE_FUNC.apply(this.get(DATA_UNKNOWN_G)).floatValue());
            stream.writeFloat32(this.FLOAT_WRITE_FUNC.apply(this.get(DATA_UNKNOWN_H)).floatValue());
        }

        public void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3S_0x1: {
                    this.read_0x1(stream);
                }
            }
        }

        public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3S_0x1: 
                case AUTO: {
                    this.write_0x1(stream);
                }
            }
        }

        public Sound(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this();
            this.read(stream, format);
        }

        public Sound() {
            this.init();
        }

        public static enum Channel {
            GENERAL(0),
            UNIT_SELECTION(1),
            UNIT_ACKNOWLEDGEMENT(2),
            UNIT_MOVEMENT(3),
            UNIT_READY(4),
            COMBAT(5),
            ERROR(6),
            MUSIC(7),
            USER_INTERFACE(8),
            LOOPING_MOVEMENT(9),
            LOOPING_AMBIENT(10),
            ANIMATION(11),
            CONSTRUCTION(12),
            BIRTH(13),
            FIRE(14);

            private int _index;

            public int getIndex() {
                return this._index;
            }

            private Channel(int index) {
                this._index = index;
            }
        }

        public static enum Flag {
            LOOPING(1),
            USE_3D(2),
            STOP_WHEN_OUT_OF_RANGE(4),
            MUSIC(8),
            UNKNOWN(16);

            private int _index;

            public int getIndex() {
                return this._index;
            }

            private Flag(int index) {
                this._index = index;
            }
        }

        public static enum Eax {
            DEFAULT_ON("DefaultEAXON", "Default"),
            COMBAT("CombatSoundsEAX", "combat"),
            KOTO_DRUMS("KotoDrumsEAX", "drums"),
            SPELLS("SpellsEAX", "spells"),
            MISSILES("MissilesEAX", "missiles"),
            HERO_SPEECH("HeroAcksEAX", "hero speech"),
            Doodads("DoodadsEAX", "doodads");

            private String _key;
            private String _description;

            public String getKey() {
                return this._key;
            }

            public String getDescription() {
                return this._description;
            }

            private Eax(String key, String description) {
                this._key = key;
                this._description = description;
            }
        }

        public static class State<T extends DataType>
        extends BinState<T> {
            private static final List<State> _values = new ArrayList<State>();

            public static List<State> values() {
                return new ArrayList<State>(_values);
            }

            public State(@Nonnull DataTypeInfo typeInfo, @Nonnull String idString, T defVal) {
                super(idString, typeInfo, defVal);
                _values.add(this);
            }

            public State(@Nonnull DataTypeInfo typeInfo, @Nonnull String idString) {
                this(typeInfo, idString, null);
            }

            public State(@Nonnull Class<T> type, @Nonnull String idString) {
                this(new DataTypeInfo((Class<? extends DataType>)type), idString);
            }

            public State(@Nonnull Class<T> type, @Nonnull String idString, T defVal) {
                this(new DataTypeInfo((Class<? extends DataType>)type), idString, defVal);
            }
        }
    }
}

