/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeInterface;
import de.peeeq.wurstscript.utils.Utils;
import org.eclipse.jdt.annotation.Nullable;

public class InterfaceInstances {
    public static ImmutableCollection<WurstTypeInterface> getImplementedInterfaces(ClassDef c) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeExpr t : c.getImplementsList()) {
            InterfaceInstances.addInterface((ImmutableCollection.Builder<WurstTypeInterface>)result, t, null);
        }
        if (c.getExtendedClass() instanceof TypeExpr) {
            InterfaceInstances.addInterfacesFromExtends((ImmutableCollection.Builder<WurstTypeInterface>)result, (TypeExpr)c.getExtendedClass());
        }
        return result.build();
    }

    public static ImmutableCollection<WurstTypeInterface> getExtendedInterfaces(InterfaceDef in) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeExpr t : in.getExtendsList()) {
            InterfaceInstances.addInterface((ImmutableCollection.Builder<WurstTypeInterface>)result, t, in);
        }
        return result.build();
    }

    private static void addInterface(ImmutableCollection.Builder<WurstTypeInterface> result, TypeExpr t, @Nullable InterfaceDef in) {
        if (t.attrTyp() instanceof WurstTypeInterface) {
            WurstTypeInterface i = (WurstTypeInterface)t.attrTyp();
            if (i.getDef() == in) {
                t.addError("Interfaces must not extend themselves.");
                return;
            }
            result.add((Object)i);
            VariableBinding typeParamBounds = i.getTypeArgBinding();
            for (WurstTypeInterface i2 : i.extendedInterfaces()) {
                result.add((Object)((WurstTypeInterface)i2.setTypeArgs(typeParamBounds)));
            }
        } else {
            t.addError(Utils.printElement(t) + " is not an interface.");
        }
    }

    private static void addInterfacesFromExtends(ImmutableCollection.Builder<WurstTypeInterface> result, TypeExpr t) {
        if (t.attrTyp() instanceof WurstTypeClass) {
            WurstTypeClass wtc = (WurstTypeClass)t.attrTyp();
            VariableBinding typeParamBounds = wtc.getTypeArgBinding();
            for (WurstTypeInterface i2 : wtc.implementedInterfaces()) {
                result.add((Object)((WurstTypeInterface)i2.setTypeArgs(typeParamBounds)));
            }
        }
    }
}

