/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.utils;

import de.peeeq.wurstio.languageserver.WurstLanguageServer;
import de.peeeq.wurstscript.WLogger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.moonlightflower.wc3libs.bin.GameExe;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.Orient;
import net.moonlightflower.wc3libs.port.StdGameExeFinder;
import net.moonlightflower.wc3libs.port.StdGameVersionFinder;
import net.moonlightflower.wc3libs.port.UnsupportedPlatformException;
import net.moonlightflower.wc3libs.port.win.WinGameExeFinder;

public class W3InstallationData {
    private final WurstLanguageServer languageServer;
    private Optional<File> gameExe = Optional.empty();
    private Optional<GameVersion> version = Optional.empty();
    private File selectedFolder;
    private boolean shouldAskForPath = false;

    public W3InstallationData(Optional<File> gameExe, Optional<GameVersion> version) {
        this.languageServer = null;
        this.gameExe = gameExe;
        this.version = version;
    }

    public W3InstallationData(WurstLanguageServer languageServer, boolean shouldAskForPath) {
        this.languageServer = languageServer;
        this.shouldAskForPath = shouldAskForPath;
        this.discoverExePath();
        this.discoverVersion();
    }

    public W3InstallationData(WurstLanguageServer languageServer, File wc3Path, boolean shouldAskForPath) {
        this.languageServer = languageServer;
        this.shouldAskForPath = shouldAskForPath;
        if (!Orient.isWindowsSystem()) {
            WLogger.warning("Game path configuration only works on windows");
            this.discoverExePath();
            this.discoverVersion();
            return;
        }
        this.loadFromPath(wc3Path);
        if (!this.gameExe.isPresent()) {
            WLogger.warning("The provided wc3 path wasn't suitable. Falling back to discovery.");
            this.discoverExePath();
            this.discoverVersion();
        }
    }

    private void loadFromPath(File wc3Path) {
        try {
            this.gameExe = Optional.ofNullable(WinGameExeFinder.fromDirIgnoreVersion(wc3Path));
        }
        catch (NotFoundException e) {
            WLogger.severe(e);
        }
        WLogger.info("Game Executable from path: " + this.gameExe);
        this.version = this.gameExe.flatMap(exe -> {
            try {
                return Optional.ofNullable(GameExe.getVersion(exe));
            }
            catch (IOException e) {
                WLogger.severe(e);
                return Optional.empty();
            }
        });
        WLogger.info("Parsed custom game version from executable: " + this.version);
    }

    private void discoverExePath() {
        block2: {
            try {
                this.gameExe = Optional.ofNullable((File)new StdGameExeFinder().get());
                WLogger.info("Discovered game path: " + this.gameExe);
            }
            catch (NotFoundException | UnsupportedPlatformException e) {
                WLogger.warning("Can't find game installation directory: " + e.getMessage());
                if (!this.shouldAskForPath) break block2;
                this.showFileChooser();
            }
        }
    }

    private void showFileChooser() {
        try {
            SwingUtilities.invokeAndWait(() -> {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogTitle("Select Warcraft III installation directory");
                fileChooser.setFileSelectionMode(1);
                JDialog dialog = new JDialog();
                dialog.setAlwaysOnTop(true);
                int result = fileChooser.showOpenDialog(dialog);
                if (result == 0) {
                    this.selectedFolder = fileChooser.getSelectedFile();
                } else {
                    WLogger.warning("No directory selected");
                }
            });
            this.loadFromPath(this.selectedFolder);
            if (this.gameExe.isPresent()) {
                this.languageServer.getRemoteEndpoint().notify("wurst/updateGamePath", (Object)this.selectedFolder.getAbsolutePath());
            }
        }
        catch (InterruptedException | InvocationTargetException ex) {
            WLogger.warning("Choosing game path failed", ex);
        }
    }

    private void discoverVersion() {
        try {
            this.version = Optional.ofNullable((GameVersion)new StdGameVersionFinder().get());
            WLogger.info("Parsed game version: " + this.version);
        }
        catch (NotFoundException e) {
            WLogger.warning("Wurst compiler failed to determine game version", e);
        }
        catch (UnsupportedPlatformException e) {
            WLogger.warning("Wurst compiler cannot determine game version: " + e.getMessage());
        }
    }

    public Optional<GameVersion> getWc3PatchVersion() {
        return this.version;
    }

    public Optional<File> getGameExe() {
        return this.gameExe;
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
    }
}

