/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.NoTypeParamConstraints;
import de.peeeq.wurstscript.ast.TypeExprList;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.attributes.ImplicitFuncs;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeClassFunc;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeIntLiteral;
import io.vavr.control.Either;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;

public class WurstTypeBoundTypeParam
extends WurstType {
    private final TypeParamDef typeParamDef;
    private final WurstType baseType;
    private FuncDef fromIndex;
    private FuncDef toIndex;
    private final @Nullable Map<FuncDef, FuncLink> typeConstraintFunctions;
    private boolean indexInitialized = false;
    private final Element context;

    public WurstTypeBoundTypeParam(TypeParamDef def, WurstType baseType, Element context) {
        if (baseType instanceof WurstTypeIntLiteral) {
            baseType = WurstTypeInt.instance();
        }
        this.typeParamDef = def;
        this.baseType = baseType;
        this.context = context;
        this.typeConstraintFunctions = def.getTypeParamConstraints() instanceof NoTypeParamConstraints ? null : new HashMap<FuncDef, FuncLink>();
    }

    @Override
    VariableBinding matchAgainstSupertypeIntern(WurstType other, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        return this.baseType.matchAgainstSupertypeIntern(other, location, mapping, VariablePosition.NONE);
    }

    @Override
    public String getName() {
        return this.baseType.getName();
    }

    @Override
    public String getFullName() {
        return this.typeParamDef.getName() + "<--" + this.baseType.getFullName();
    }

    public WurstType getBaseType() {
        return this.baseType;
    }

    @Override
    public ImType imTranslateType(ImTranslator tr) {
        return this.baseType.imTranslateType(tr);
    }

    @Override
    public ImExprOpt getDefaultValue(ImTranslator tr) {
        return JassIm.ImIntVal(0);
    }

    @Override
    public WurstType dynamic() {
        return this.baseType.dynamic();
    }

    @Override
    public boolean canBeUsedInInstanceOf() {
        return this.baseType.canBeUsedInInstanceOf();
    }

    @Override
    public boolean allowsDynamicDispatch() {
        return this.baseType.allowsDynamicDispatch();
    }

    @Override
    public void addMemberMethods(Element node, String name, List<FuncLink> result) {
        this.baseType.addMemberMethods(node, name, result);
    }

    @Override
    public Stream<FuncLink> getMemberMethods(Element node) {
        return this.baseType.getMemberMethods(node);
    }

    @Override
    public boolean isStaticRef() {
        return this.baseType.isStaticRef();
    }

    @Override
    public boolean isCastableToInt() {
        return true;
    }

    @Override
    public WurstType normalize() {
        return this.baseType.normalize();
    }

    public FuncDef getFromIndex() {
        this.initIndex();
        return this.fromIndex;
    }

    public FuncDef getToIndex() {
        this.initIndex();
        return this.toIndex;
    }

    private void initIndex() {
        if (this.indexInitialized) {
            return;
        }
        if (this.typeConstraintFunctions == null) {
            if (!this.baseType.supportsGenerics()) {
                this.fromIndex = ImplicitFuncs.findFromIndexFunc(this.baseType, this.context);
                this.toIndex = ImplicitFuncs.findToIndexFunc(this.baseType, this.context);
            } else if (this.baseType instanceof WurstTypeBoundTypeParam) {
                WurstTypeBoundTypeParam bt = (WurstTypeBoundTypeParam)this.baseType;
                this.fromIndex = bt.getFromIndex();
                this.toIndex = bt.getToIndex();
            }
        }
        this.indexInitialized = true;
    }

    @Override
    public boolean supportsGenerics() {
        return this.baseType.supportsGenerics() || this.getFromIndex() != null && this.getToIndex() != null;
    }

    @Override
    protected boolean isNullable() {
        return this.baseType.isNullable();
    }

    @Override
    public WurstTypeBoundTypeParam setTypeArgs(VariableBinding typeParamMapping) {
        return this.withBaseType(this.baseType.setTypeArgs(typeParamMapping));
    }

    private WurstTypeBoundTypeParam withBaseType(WurstType t) {
        if (t == this.baseType) {
            return this;
        }
        return new WurstTypeBoundTypeParam(this.typeParamDef, t, this.context);
    }

    public TypeParamDef getTypeParamDef() {
        return this.typeParamDef;
    }

    @Override
    public boolean isTranslatedToInt() {
        return this.baseType.isTranslatedToInt();
    }

    public @Nullable Map<FuncDef, FuncLink> getTypeConstraintFunctions() {
        return this.typeConstraintFunctions;
    }

    public boolean isTemplateTypeParameter() {
        return this.typeParamDef.getTypeParamConstraints() instanceof TypeExprList;
    }

    public ImTypeArgument imTranslateToTypeArgument(ImTranslator tr) {
        ImType t = this.imTranslateType(tr);
        HashMap<ImTypeClassFunc, Either<ImMethod, ImFunction>> typeClassBinding = new HashMap<ImTypeClassFunc, Either<ImMethod, ImFunction>>();
        return JassIm.ImTypeArgument(t, typeClassBinding);
    }
}

