/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.OptExpr;
import de.peeeq.wurstscript.types.FunctionSignature;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public class CallSignature {
    private final @Nullable Expr receiver;
    private final List<Expr> arguments;

    public CallSignature(@Nullable OptExpr optExpr, List<Expr> arguments) {
        this.receiver = optExpr instanceof Expr ? (Expr)optExpr : null;
        this.arguments = arguments;
    }

    public List<Expr> getArguments() {
        return this.arguments;
    }

    public @Nullable Expr getReceiver() {
        return this.receiver;
    }

    public void checkSignatureCompatibility(FunctionSignature sig, String funcName, Element pos) {
        if (sig.isEmpty()) {
            return;
        }
        Expr l_receiver = this.receiver;
        if (l_receiver != null) {
            if (sig.getReceiverType() == null) {
                l_receiver.addError("No receiver expected for function " + funcName + ".");
            } else if (!l_receiver.attrTyp().isSubtypeOf(sig.getReceiverType(), l_receiver)) {
                l_receiver.addError("Incompatible receiver type at call to function " + funcName + ".\nFound " + l_receiver.attrTyp() + " but expected " + sig.getReceiverType());
            }
        }
        if (this.getArguments().size() > sig.getMaxNumParams()) {
            if (sig.getMaxNumParams() == 0) {
                pos.addError("Too many arguments. Function " + funcName + " takes no parameter.");
            } else if (sig.getMaxNumParams() == 1) {
                pos.addError("Too many arguments. Function " + funcName + " only takes one parameter.");
            } else {
                pos.addError("Too many arguments. Function " + funcName + " only takes " + sig.getParamTypes().size() + " parameters.");
            }
        } else if (this.getArguments().size() < sig.getMinNumParams()) {
            pos.addError("Not enough arguments. Function " + funcName + " requires the following arguments: " + sig.getParameterDescription());
        } else {
            for (int i = 0; i < this.getArguments().size(); ++i) {
                if (this.getArguments().get(i).attrTyp().isSubtypeOf(sig.getParamType(i), pos)) continue;
                this.getArguments().get(i).addError("Wrong parameter type when calling " + funcName + ".\nFound " + this.getArguments().get(i).attrTyp() + " but expected " + sig.getParamType(i) + " " + sig.getParamName(i));
            }
        }
    }
}

