/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.app;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.app.WCT;
import net.moonlightflower.wc3libs.bin.app.WTG;

public class Trigs {
    private final WCT _wct;
    private final WTG _wtg;
    private final List<Var> _vars = new ArrayList<Var>();
    private final List<TrigCat> _trigCats = new ArrayList<TrigCat>();
    private final List<Trig> _trigs = new ArrayList<Trig>();

    @Nonnull
    public WCT getWCT() {
        return this._wct;
    }

    @Nonnull
    public WTG getWTG() {
        return this._wtg;
    }

    public final List<Var> getVars() {
        return this._vars;
    }

    private void addVar(@Nonnull Var val) {
        this._vars.add(val);
    }

    public List<TrigCat> getTrigCats() {
        return new ArrayList<TrigCat>(this._trigCats);
    }

    private void addTrigCat(@Nonnull TrigCat val) {
        this._trigCats.add(val);
    }

    private List<Trig> getTrigs() {
        return new ArrayList<Trig>(this._trigs);
    }

    private void addTrig(@Nonnull Trig val) {
        this._trigs.add(val);
    }

    public Trigs(@Nonnull WCT wct, @Nonnull WTG wtg) {
        this._wct = wct;
        this._wtg = wtg;
    }

    public class GUITrig
    extends Trig {
        public GUITrig(WTG.Trig wtgTrig) {
            super(wtgTrig);
        }

        public GUITrig() {
        }

        public class Action
        extends ECA {
            public Action(String funcName) {
                super(funcName);
            }
        }

        public class Condition
        extends ECA {
            public Condition(String funcName) {
                super(funcName);
            }
        }

        public class Event
        extends ECA {
            public Event(String funcName) {
                super(funcName);
            }
        }

        public abstract class ECA {
            private String _funcName;
            private boolean _isEnabled = true;

            public String getFuncName() {
                return this._funcName;
            }

            private void setFuncName(String val) {
                this._funcName = val;
            }

            public boolean isEnabled() {
                return this._isEnabled;
            }

            public void setEnabled(boolean val) {
                this._isEnabled = val;
            }

            public ECA(String funcName) {
                this.setFuncName(funcName);
            }

            public class Param {
            }
        }
    }

    public class TextTrig
    extends Trig {
        private String _text;

        public String getText() {
            return this._text;
        }

        public void setText(String val) {
            this._text = val;
        }

        public TextTrig(WTG.Trig wtgTrig, WCT.Trig wctTrig) {
            this.setText(wctTrig.getText());
        }

        public TextTrig() {
        }
    }

    public abstract class Trig {
        private String _name;
        private String _comment;
        private boolean _enabled = true;
        private boolean _initiallyOn = true;
        private boolean _isRunOnMapInit = false;
        private TrigCat _trigCat;

        public String getName() {
            return this._name;
        }

        public void setName(String val) {
            this._name = val;
        }

        public String getComment() {
            return this._comment;
        }

        public void setComment(String val) {
            this._comment = val;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean val) {
            this._enabled = val;
        }

        public boolean isInitiallyOn() {
            return this._initiallyOn;
        }

        public void setInitiallyOn(boolean val) {
            this._initiallyOn = val;
        }

        public boolean isRunOnMapInit() {
            return this._isRunOnMapInit;
        }

        public void setRunOnMapInit(boolean val) {
            this._isRunOnMapInit = val;
        }

        public TrigCat getTrigCat() {
            return this._trigCat;
        }

        public void setTrigCat(@Nonnull TrigCat val) {
            this._trigCat = val;
        }

        public Trig(WTG.Trig wtgTrig) {
            this.setName(wtgTrig.getName());
            this.setComment(wtgTrig.getDescription());
            this.setEnabled(wtgTrig.isEnabled());
            this.setInitiallyOn(wtgTrig.isInitiallyOn());
            this.setRunOnMapInit(wtgTrig.isRunOnMapInit());
            this.setTrigCat(Trigs.this.getTrigCats().get(wtgTrig.getCatIndex()));
        }

        public Trig() {
        }
    }

    public static class TrigCat {
        private String _name;
        private boolean _isComment = false;

        public String getName() {
            return this._name;
        }

        public void setName(String val) {
            this._name = val;
        }

        public boolean isComment() {
            return this._isComment;
        }

        public void setComment(boolean val) {
            this._isComment = val;
        }

        public TrigCat(@Nonnull WTG.TrigCat wtgTrigCat) {
            this.setName(wtgTrigCat.getName());
        }

        public TrigCat() {
        }
    }

    public static class Var {
        private String _name;
        private String _type;
        private String _initVal = null;
        int _arraySize = -1;

        public String getName() {
            return this._name;
        }

        public void setName(String val) {
            this._name = val;
        }

        public String getType() {
            return this._type;
        }

        public void setType(String val) {
            this._type = val;
        }

        public String getInitVal() {
            return this._initVal;
        }

        public void setInitVal(String val) {
            this._initVal = val;
        }

        public int getArraySize() {
            return this._arraySize;
        }

        public boolean isArray() {
            return this.getArraySize() >= 0;
        }

        public void setArraySize(int val) {
            this._arraySize = val;
        }

        public Var(@Nonnull WTG.Var wtgVar) {
            this.setName(wtgVar.getName());
            this.setType(wtgVar.getType());
            this.setInitVal(wtgVar.getInitVal());
            this.setArraySize(wtgVar.getArraySize());
        }

        public Var() {
        }
    }
}

