/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.Bin;
import net.moonlightflower.wc3libs.bin.BinState;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.dataTypes.app.SoundLabel;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.dataTypes.app.WeatherId;
import net.moonlightflower.wc3libs.misc.Id;

public class W3R {
    public static final File GAME_PATH = new File("war3map.w3r");
    private List<Rect> _rects = new ArrayList<Rect>();

    @Nonnull
    public List<Rect> getRects() {
        return new ArrayList<Rect>(this._rects);
    }

    private void addRect(@Nonnull Rect val) {
        this._rects.add(val);
    }

    @Nonnull
    public Rect addRect() {
        Rect rect = new Rect();
        this.addRect(rect);
        return rect;
    }

    @Nonnull
    public Rect addRect(@Nonnull Bounds bounds) {
        Rect rect = this.addRect();
        rect.setBounds(bounds);
        return rect;
    }

    public void read_0x5(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.W3R_0x5.getVersion(), version);
        int rectsCount = stream.readInt32("rectsCount");
        for (int i = 0; i < rectsCount; ++i) {
            this.addRect(new Rect(stream, EncodingFormat.W3R_0x5));
        }
    }

    public void write_0x5(@Nonnull Wc3BinOutputStream stream) {
        stream.writeInt32(EncodingFormat.W3R_0x5.getVersion());
        stream.writeInt32(this._rects.size());
        for (Rect rect : this._rects) {
            rect.write(stream, EncodingFormat.W3R_0x5);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32();
        stream.rewind();
        this.read(stream, stream.getFormat(EncodingFormat.class, version));
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case W3R_0x5: {
                this.read_0x5(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case W3R_0x5: 
            case AUTO: {
                this.write_0x5(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    private void read(@Nonnull File file, @Nonnull EncodingFormat format) throws IOException {
        this.read(new Wc3BinInputStream(file), format);
    }

    public void write(@Nonnull File file, @Nonnull EncodingFormat format) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream, format);
        outStream.close();
    }

    private void read(@Nonnull File file) throws IOException {
        this.read(file, EncodingFormat.AUTO);
    }

    public void write(@Nonnull File file) throws IOException {
        this.write(new Wc3BinOutputStream(file));
    }

    public W3R() {
    }

    public W3R(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream);
    }

    public W3R(@Nonnull File file) throws IOException {
        this.read(file);
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat W3R_0x5 = new EncodingFormat(Enum.W3R_0x5, 5);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            W3R_0x5;

        }
    }

    public static class Rect
    extends Bin {
        public static final State<Color> ART_COLOR = new State<Color>(Color.class, "color", Color.fromBGR255(255, 255, 255));
        public static final State<WeatherId> ART_WEATHER = new State<Object>(WeatherId.class, "weather", null);
        public static final State<Bounds> DATA_BOUNDS = new State<Bounds>(Bounds.class, "bounds", new Bounds(0, 0, 0, 0));
        public static final State<War3Int> DATA_INDEX = new State<War3Int>(War3Int.class, "index", War3Int.valueOf(0));
        public static final State<SoundLabel> SOUND_LABEL = new State<SoundLabel>(SoundLabel.class, "sound", SoundLabel.valueOf("sound"));
        public static final State<War3String> TEXT_NAME = new State<War3String>(War3String.class, "name", War3String.valueOf("unnamed"));
        public WeatherId NULL_WEATHER_ID = WeatherId.valueOf("\u0000\u0000\u0000\u0000");

        public <T extends DataType> T get(State<T> state) {
            try {
                return state.tryCastVal(super.get(state));
            }
            catch (DataTypeInfo.CastException castException) {
                return null;
            }
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set(state, val);
        }

        public <T extends DataType> void reset(State<T> state) {
            super.set((BinState<?>)state, (DataType)state.getDefVal());
        }

        public void init() {
            for (State state : State.values()) {
                ((Bin)this).set(state, (DataType)state.getDefVal());
            }
        }

        @Nonnull
        public Bounds getBounds() {
            return this.get(DATA_BOUNDS) != null ? this.get(DATA_BOUNDS) : (Bounds)DATA_BOUNDS.getDefVal();
        }

        public void setBounds(@Nonnull Bounds val) {
            this.set(DATA_BOUNDS, (DataType)val);
        }

        public Color getColor() {
            return this.get(ART_COLOR);
        }

        public void setColor(Color val) {
            this.set(ART_COLOR, (DataType)val);
        }

        public War3Int getIndex() {
            return this.get(DATA_INDEX);
        }

        public void setIndex(War3Int val) {
            this.set(DATA_INDEX, (DataType)val);
        }

        public War3String getName() {
            return this.get(TEXT_NAME);
        }

        public void setName(War3String val) {
            this.set(TEXT_NAME, (DataType)val);
        }

        public SoundLabel getSound() {
            return this.get(SOUND_LABEL);
        }

        public void setSound(SoundLabel val) {
            this.set(SOUND_LABEL, (DataType)val);
        }

        public WeatherId getWeather() {
            return this.get(ART_WEATHER);
        }

        public void setWeather(WeatherId val) {
            this.set(ART_WEATHER, (DataType)val);
        }

        public void read_0x5(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            float minX = stream.readFloat32();
            float maxX = stream.readFloat32();
            float minY = stream.readFloat32();
            float maxY = stream.readFloat32();
            this.set(DATA_BOUNDS, (DataType)Bounds.valueOf((int)minX, (int)maxX, (int)minY, (int)maxY));
            this.set(TEXT_NAME, (DataType)War3String.valueOf(stream.readString()));
            this.set(DATA_INDEX, (DataType)stream.readWc3Int());
            WeatherId weatherId = WeatherId.valueOf(stream.readId());
            this.set(ART_WEATHER, (DataType)(!weatherId.equals(this.NULL_WEATHER_ID) ? weatherId : null));
            this.set(SOUND_LABEL, (DataType)SoundLabel.valueOf(stream.readString()));
            this.set(ART_COLOR, (DataType)Color.fromBGR255(stream.readUByte(), stream.readUByte(), stream.readUByte()));
            short endToken = stream.readUByte();
        }

        public void write_0x5(@Nonnull Wc3BinOutputStream stream) {
            Bounds bounds = this.get(DATA_BOUNDS);
            stream.writeReal(War3Real.valueOf(bounds.getMinX()));
            stream.writeReal(War3Real.valueOf(bounds.getMaxX()));
            stream.writeReal(War3Real.valueOf(bounds.getMinY()));
            stream.writeReal(War3Real.valueOf(bounds.getMaxY()));
            stream.writeString(this.get(TEXT_NAME));
            stream.writeInt32(this.get(DATA_INDEX));
            stream.writeId(this.get(ART_WEATHER) != null ? (Id)this.get(ART_WEATHER) : this.NULL_WEATHER_ID);
            stream.writeString(this.get(SOUND_LABEL));
            Color color = this.get(ART_COLOR);
            stream.writeUByte(color.getBlue255());
            stream.writeUByte(color.getGreen255());
            stream.writeUByte(color.getRed255());
            stream.writeUByte(255);
        }

        public void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3R_0x5: {
                    this.read_0x5(stream);
                }
            }
        }

        public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3R_0x5: 
                case AUTO: {
                    this.write_0x5(stream);
                }
            }
        }

        public Rect(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this();
            this.read(stream, format);
        }

        public Rect() {
            this.init();
        }

        public Rect(@Nonnull Bounds bounds) {
            this();
            this.set(DATA_BOUNDS, (DataType)bounds);
        }

        public static class State<T extends DataType>
        extends BinState<T> {
            private static final List<State> _values = new ArrayList<State>();

            public static List<State> values() {
                return new ArrayList<State>(_values);
            }

            public State(@Nonnull DataTypeInfo typeInfo, @Nonnull String fieldIdS, T defVal) {
                super(fieldIdS, typeInfo, defVal);
                _values.add(this);
            }

            public State(@Nonnull DataTypeInfo typeInfo, @Nonnull String idString) {
                this(typeInfo, idString, null);
            }

            public State(@Nonnull Class<T> type, @Nonnull String idString) {
                this(new DataTypeInfo((Class<? extends DataType>)type), idString);
            }

            public State(@Nonnull Class<T> type, @Nonnull String idString, T defVal) {
                this(new DataTypeInfo((Class<? extends DataType>)type), idString, defVal);
            }
        }
    }
}

