/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import com.google.gson.JsonObject;
import de.peeeq.wurstio.languageserver.BufferManager;
import de.peeeq.wurstio.languageserver.Convert;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;

public class CodeLensRequest {

    public static class Resolve
    extends UserRequest<CodeLens> {
        private final CodeLens unresolved;

        public Resolve(CodeLens unresolved) {
            this.unresolved = unresolved;
        }

        @Override
        public CodeLens execute(ModelManager modelManager) throws IOException {
            Object data = this.unresolved.getData();
            Command cmd = new Command("Run Wurst unit test", "wurst.tests", Collections.singletonList(data));
            this.unresolved.setCommand(cmd);
            return this.unresolved;
        }
    }

    public static class GetCodeLens
    extends UserRequest<List<? extends CodeLens>> {
        private final CodeLensParams params;
        private final BufferManager bufferManager;

        public GetCodeLens(CodeLensParams params, BufferManager bufferManager) {
            this.params = params;
            this.bufferManager = bufferManager;
        }

        @Override
        public List<CodeLens> execute(ModelManager modelManager) {
            String buffer;
            WFile wFile = WFile.create(this.params.getTextDocument());
            CompilationUnit cu = modelManager.replaceCompilationUnitContent(wFile, buffer = this.bufferManager.getBuffer(wFile), false);
            if (cu == null) {
                return Collections.emptyList();
            }
            ArrayList<CodeLens> result = new ArrayList<CodeLens>();
            for (WPackage p : cu.getPackages()) {
                for (WEntity element : p.getElements()) {
                    FuncDef f;
                    if (!(element instanceof FuncDef) || !(f = (FuncDef)element).hasAnnotation("@test")) continue;
                    Range range = Convert.range(f);
                    JsonObject options = new JsonObject();
                    options.addProperty("filename", this.params.getTextDocument().getUri());
                    String testName = p.getName() + "." + f.getName();
                    options.addProperty("testName", testName);
                    result.add(new CodeLens(range, null, (Object)options));
                }
            }
            return result;
        }
    }
}

