/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port.win;

import java.io.File;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.GameExe;
import net.moonlightflower.wc3libs.port.Context;
import net.moonlightflower.wc3libs.port.GameExeFinder;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.GameVersionFinder;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.win.WinGameExeFinder;
import net.moonlightflower.wc3libs.port.win.WinTelemetryGameVersionFinder;

public class WinGameVersionFinder
extends GameVersionFinder {
    protected GameExeFinder getGameExeFinder() {
        return Context.getService(WinGameExeFinder.class);
    }

    protected GameVersionFinder getTelemetryGameVersionFinder() {
        return new WinTelemetryGameVersionFinder();
    }

    @Override
    @Nonnull
    public GameVersion find() throws NotFoundException {
        GameExeFinder gameExeFinder = this.getGameExeFinder();
        try {
            File gameExeFile = (File)gameExeFinder.get();
            try {
                return GameExe.getVersion(gameExeFile);
            }
            catch (Exception e) {
                throw new NotFoundException(e);
            }
        }
        catch (NotFoundException notFoundException) {
            try {
                return (GameVersion)this.getTelemetryGameVersionFinder().get();
            }
            catch (NotFoundException notFoundException2) {
                throw new NotFoundException();
            }
        }
    }
}

