/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.optimizer;

import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.intermediatelang.optimizer.SideEffectAnalyzer;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImBoolVal;
import de.peeeq.wurstscript.jassIm.ImExitwhen;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImIntVal;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImRealVal;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImStringVal;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imoptimizer.OptimizerPass;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.TypesHelper;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class SimpleRewrites
implements OptimizerPass {
    private SideEffectAnalyzer sideEffectAnalysis;
    private int totalRewrites = 0;
    private final boolean showRewrites = false;

    @Override
    public int optimize(ImTranslator trans) {
        ImProg prog = trans.getImProg();
        this.sideEffectAnalysis = new SideEffectAnalyzer(prog);
        this.totalRewrites = 0;
        this.optimizeElement(prog);
        prog.flatten(trans);
        this.removeUnreachableCode(prog);
        return this.totalRewrites;
    }

    @Override
    public String getName() {
        return "Simple Rewrites";
    }

    private void removeUnreachableCode(ImProg prog) {
        prog.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImStmts stmts) {
                super.visit(stmts);
                SimpleRewrites.this.removeUnreachableCode(stmts);
            }
        });
    }

    private void removeUnreachableCode(ImStmts stmts) {
        Iterator it = stmts.iterator();
        boolean reachable = true;
        while (it.hasNext()) {
            ImStmt s = (ImStmt)it.next();
            if (reachable) {
                boolean b;
                ImExitwhen imExitwhen;
                ImExpr expr;
                if (s instanceof ImReturn) {
                    reachable = false;
                    continue;
                }
                if (!(s instanceof ImExitwhen) || !((expr = (imExitwhen = (ImExitwhen)s).getCondition()) instanceof ImBoolVal) || !(b = ((ImBoolVal)expr).getValB())) continue;
                reachable = false;
                continue;
            }
            ++this.totalRewrites;
            it.remove();
        }
    }

    private void optimizeElement(Element elem) {
        for (int i = 0; i < elem.size(); ++i) {
            this.optimizeElement(elem.get(i));
            if (i <= 0) continue;
            Element lookback = elem.get(i - 1);
            if (elem.get(i) instanceof ImExitwhen && lookback instanceof ImExitwhen) {
                this.optimizeConsecutiveExitWhen((ImExitwhen)lookback, (ImExitwhen)elem.get(i));
            }
            if (!(elem.get(i) instanceof ImSet) || !(lookback instanceof ImSet)) continue;
            this.optimizeConsecutiveSet((ImSet)lookback, (ImSet)elem.get(i));
        }
        if (elem instanceof ImOperatorCall) {
            ImOperatorCall opc = (ImOperatorCall)elem;
            this.optimizeOpCall(opc);
        } else if (elem instanceof ImIf) {
            ImIf imIf = (ImIf)elem;
            this.optimizeIf(imIf);
        } else if (elem instanceof ImExitwhen) {
            ImExitwhen imExitwhen = (ImExitwhen)elem;
            this.optimizeExitwhen(imExitwhen);
        }
    }

    private void optimizeConsecutiveExitWhen(ImExitwhen lookback, ImExitwhen element) {
        element.getCondition().setParent(null);
        lookback.setCondition(JassIm.ImOperatorCall(WurstOperator.OR, JassIm.ImExprs(lookback.getCondition().copy(), element.getCondition())));
        element.replaceBy(ImHelper.nullExpr());
        ++this.totalRewrites;
    }

    private void optimizeExitwhen(ImExitwhen imExitwhen) {
        boolean b;
        ImExpr expr = imExitwhen.getCondition();
        if (expr instanceof ImBoolVal && !(b = ((ImBoolVal)expr).getValB())) {
            imExitwhen.replaceBy(ImHelper.nullExpr());
            ++this.totalRewrites;
        }
    }

    private void optimizeIfExitwhen(ImIf imIf) {
        ImExitwhen imStmt = (ImExitwhen)imIf.getThenBlock().get(0);
        imStmt.getCondition().setParent(null);
        imIf.getCondition().setParent(null);
        imStmt.setCondition(JassIm.ImOperatorCall(WurstOperator.AND, JassIm.ImExprs(imIf.getCondition(), imStmt.getCondition())));
        imStmt.setParent(null);
        imIf.replaceBy(imStmt);
        ++this.totalRewrites;
    }

    private void optimizeOpCall(ImOperatorCall opc) {
        boolean wasViable = true;
        if (opc.getArguments().size() > 1) {
            ImExpr left = (ImExpr)opc.getArguments().get(0);
            ImExpr right = (ImExpr)opc.getArguments().get(1);
            if (left instanceof ImBoolVal && right instanceof ImBoolVal) {
                boolean result;
                boolean b1 = ((ImBoolVal)left).getValB();
                boolean b2 = ((ImBoolVal)right).getValB();
                switch (opc.getOp()) {
                    case OR: {
                        result = b1 || b2;
                        break;
                    }
                    case AND: {
                        result = b1 && b2;
                        break;
                    }
                    case EQ: {
                        result = b1 == b2;
                        break;
                    }
                    case NOTEQ: {
                        result = b1 != b2;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
                opc.replaceBy(JassIm.ImBoolVal(result));
            } else if (left instanceof ImBoolVal) {
                boolean b1 = ((ImBoolVal)left).getValB();
                wasViable = this.replaceBoolTerm(opc, right, b1);
            } else if (right instanceof ImBoolVal) {
                boolean b2 = ((ImBoolVal)right).getValB();
                wasViable = this.replaceBoolTerm(opc, left, b2);
            } else if (left instanceof ImIntVal && right instanceof ImIntVal) {
                wasViable = this.optimizeIntInt(opc, wasViable, (ImIntVal)left, (ImIntVal)right);
            } else if (left instanceof ImRealVal && right instanceof ImRealVal) {
                wasViable = this.optimizeRealReal(opc, wasViable, (ImRealVal)left, (ImRealVal)right);
            } else if (right instanceof ImStringVal) {
                if (left instanceof ImStringVal) {
                    wasViable = this.optimizeStringString(opc, (ImStringVal)left, (ImStringVal)right);
                } else if (((ImStringVal)right).getValS().equalsIgnoreCase("") && opc.getOp() == WurstOperator.PLUS) {
                    left.setParent(null);
                    opc.replaceBy(left);
                    wasViable = true;
                } else {
                    wasViable = false;
                }
            } else if (opc.getOp() == WurstOperator.PLUS && (left.attrTyp().equalsType(TypesHelper.imInt()) || left.attrTyp().equalsType(TypesHelper.imReal())) && left.structuralEquals(right)) {
                if (!this.sideEffectAnalysis.hasSideEffects(left)) {
                    opc.setOp(WurstOperator.MULT);
                    right.replaceBy(JassIm.ImIntVal(2));
                    wasViable = true;
                }
            } else {
                wasViable = false;
            }
        } else {
            ImExpr expr = (ImExpr)opc.getArguments().get(0);
            if (opc.getOp() == WurstOperator.UNARY_MINUS && expr instanceof ImIntVal) {
                ImIntVal imIntVal = (ImIntVal)expr;
                if (imIntVal.getValI() <= 0) {
                    int inverseVal = imIntVal.getValI() * -1;
                    ImIntVal newVal = JassIm.ImIntVal(inverseVal);
                    opc.replaceBy(newVal);
                }
                wasViable = false;
            } else if (expr instanceof ImBoolVal) {
                boolean result;
                boolean b1 = ((ImBoolVal)expr).getValB();
                switch (opc.getOp()) {
                    case NOT: {
                        result = !b1;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
                opc.replaceBy(JassIm.ImBoolVal(result));
            } else if (opc.getOp() == WurstOperator.NOT && expr instanceof ImOperatorCall) {
                ImOperatorCall inner = (ImOperatorCall)expr;
                switch (inner.getOp()) {
                    case NOT: {
                        opc.replaceBy((Element)inner.getArguments().remove(0));
                        break;
                    }
                    case EQ: 
                    case NOTEQ: 
                    case LESS: 
                    case LESS_EQ: 
                    case GREATER: 
                    case GREATER_EQ: {
                        opc.replaceBy(JassIm.ImOperatorCall(this.oppositeOperator(inner.getOp()), JassIm.ImExprs(inner.getArguments().removeAll())));
                        break;
                    }
                    case OR: 
                    case AND: {
                        List args = inner.getArguments().removeAll();
                        ImExprs imExprs = JassIm.ImExprs(new ImExpr[0]);
                        args.forEach(e -> imExprs.add(JassIm.ImOperatorCall(WurstOperator.NOT, JassIm.ImExprs(e.copy()))));
                        ImOperatorCall opCall = JassIm.ImOperatorCall(this.oppositeOperator(inner.getOp()), imExprs);
                        opc.replaceBy(opCall);
                        break;
                    }
                    default: {
                        wasViable = false;
                        break;
                    }
                }
            } else {
                wasViable = false;
            }
        }
        if (wasViable) {
            ++this.totalRewrites;
        }
    }

    private boolean optimizeStringString(ImOperatorCall opc, ImStringVal left, ImStringVal right) {
        String f1 = left.getValS();
        String f2 = right.getValS();
        switch (opc.getOp()) {
            case PLUS: {
                opc.replaceBy(JassIm.ImStringVal(f1 + f2));
                return true;
            }
        }
        return false;
    }

    private boolean optimizeRealReal(ImOperatorCall opc, boolean wasViable, ImRealVal left, ImRealVal right) {
        float f1 = Float.parseFloat(left.getValR());
        float f2 = Float.parseFloat(right.getValR());
        boolean isConditional = false;
        boolean isArithmetic = false;
        boolean result = false;
        float resultVal = 0.0f;
        switch (opc.getOp()) {
            case GREATER: {
                result = f1 > f2;
                isConditional = true;
                break;
            }
            case GREATER_EQ: {
                result = f1 >= f2;
                isConditional = true;
                break;
            }
            case LESS: {
                result = f1 < f2;
                isConditional = true;
                break;
            }
            case LESS_EQ: {
                result = f1 <= f2;
                isConditional = true;
                break;
            }
            case EQ: {
                result = f1 == f2;
                isConditional = true;
                break;
            }
            case NOTEQ: {
                result = f1 != f2;
                isConditional = true;
                break;
            }
            case PLUS: {
                resultVal = f1 + f2;
                isArithmetic = true;
                break;
            }
            case MINUS: {
                resultVal = f1 - f2;
                isArithmetic = true;
                break;
            }
            case MULT: {
                resultVal = f1 * f2;
                isArithmetic = true;
                break;
            }
            case MOD_REAL: {
                if (f2 == 0.0f) break;
                resultVal = f1 % f2;
                isArithmetic = true;
                break;
            }
            case DIV_INT: {
                if (f2 == 0.0f) break;
                resultVal = f1 / f2;
                isArithmetic = true;
                break;
            }
            case DIV_REAL: {
                if (f2 == 0.0f) break;
                resultVal = f1 / f2;
                isArithmetic = true;
                break;
            }
            default: {
                result = false;
                isConditional = false;
                isArithmetic = false;
            }
        }
        if (isConditional) {
            opc.replaceBy(JassIm.ImBoolVal(result));
        } else if (isArithmetic) {
            String s = SimpleRewrites.floatToStringWithDecimalDigits(resultVal, 4);
            if (Float.parseFloat(s) == resultVal) {
                opc.replaceBy(JassIm.ImRealVal(s));
            } else {
                s = SimpleRewrites.floatToStringWithDecimalDigits(resultVal, 9);
                if (Float.parseFloat(s) == resultVal) {
                    opc.replaceBy(JassIm.ImRealVal(s));
                } else {
                    wasViable = false;
                }
            }
        } else {
            wasViable = false;
        }
        return wasViable;
    }

    private boolean optimizeIntInt(ImOperatorCall opc, boolean wasViable, ImIntVal left, ImIntVal right) {
        int i1 = left.getValI();
        int i2 = right.getValI();
        boolean isConditional = false;
        boolean isArithmetic = false;
        boolean result = false;
        int resultVal = 0;
        switch (opc.getOp()) {
            case GREATER: {
                result = i1 > i2;
                isConditional = true;
                break;
            }
            case GREATER_EQ: {
                result = i1 >= i2;
                isConditional = true;
                break;
            }
            case LESS: {
                result = i1 < i2;
                isConditional = true;
                break;
            }
            case LESS_EQ: {
                result = i1 <= i2;
                isConditional = true;
                break;
            }
            case EQ: {
                result = i1 == i2;
                isConditional = true;
                break;
            }
            case NOTEQ: {
                result = i1 != i2;
                isConditional = true;
                break;
            }
            case PLUS: {
                resultVal = i1 + i2;
                isArithmetic = true;
                break;
            }
            case MINUS: {
                resultVal = i1 - i2;
                isArithmetic = true;
                break;
            }
            case MULT: {
                resultVal = i1 * i2;
                isArithmetic = true;
                break;
            }
            case MOD_INT: {
                if (i2 == 0) break;
                resultVal = i1 % i2;
                isArithmetic = true;
                break;
            }
            case MOD_REAL: {
                float f1 = i1;
                float f2 = i2;
                if (f2 == 0.0f) break;
                float resultF = f1 % f2;
                opc.replaceBy(JassIm.ImRealVal(String.valueOf(resultF)));
                break;
            }
            case DIV_INT: {
                if (i2 == 0) break;
                resultVal = i1 / i2;
                isArithmetic = true;
                break;
            }
            case DIV_REAL: {
                float f3 = i1;
                float f4 = i2;
                if (f4 == 0.0f) break;
                float resultF = f3 / f4;
                opc.replaceBy(JassIm.ImRealVal(String.valueOf(resultF)));
                break;
            }
            default: {
                result = false;
                isConditional = false;
                isArithmetic = false;
            }
        }
        if (isConditional) {
            opc.replaceBy(JassIm.ImBoolVal(result));
        } else if (isArithmetic) {
            opc.replaceBy(JassIm.ImIntVal(resultVal));
        } else {
            wasViable = false;
        }
        return wasViable;
    }

    private boolean replaceBoolTerm(ImOperatorCall opc, ImExpr expr, boolean b2) {
        switch (opc.getOp()) {
            case OR: {
                if (b2) {
                    opc.replaceBy(JassIm.ImBoolVal(true));
                    break;
                }
                expr.setParent(null);
                opc.replaceBy(expr);
                break;
            }
            case AND: {
                if (b2) {
                    expr.setParent(null);
                    opc.replaceBy(expr);
                    break;
                }
                opc.replaceBy(JassIm.ImBoolVal(false));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private WurstOperator oppositeOperator(WurstOperator op) {
        switch (op) {
            case EQ: {
                return WurstOperator.NOTEQ;
            }
            case GREATER: {
                return WurstOperator.LESS_EQ;
            }
            case GREATER_EQ: {
                return WurstOperator.LESS;
            }
            case LESS: {
                return WurstOperator.GREATER_EQ;
            }
            case LESS_EQ: {
                return WurstOperator.GREATER;
            }
            case NOTEQ: {
                return WurstOperator.EQ;
            }
            case AND: {
                return WurstOperator.OR;
            }
            case OR: {
                return WurstOperator.AND;
            }
        }
        throw new Error("operator " + op + " does not have an opposite.");
    }

    private static String floatToStringWithDecimalDigits(float resultVal, int digits) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(digits);
        format.setMinimumFractionDigits(1);
        format.setGroupingUsed(false);
        String s = format.format(resultVal);
        return s;
    }

    private void optimizeIf(ImIf imIf) {
        if (imIf.getThenBlock().isEmpty() && imIf.getElseBlock().isEmpty()) {
            ++this.totalRewrites;
            imIf.replaceBy(imIf.getCondition().copy());
        } else if (imIf.getCondition() instanceof ImBoolVal) {
            ImBoolVal boolVal = (ImBoolVal)imIf.getCondition();
            if (boolVal.getValB()) {
                imIf.replaceBy(ImHelper.statementExprVoid(imIf.getThenBlock().copy()));
                ++this.totalRewrites;
            } else if (!imIf.getElseBlock().isEmpty()) {
                imIf.replaceBy(ImHelper.statementExprVoid(imIf.getElseBlock().copy()));
                ++this.totalRewrites;
            } else {
                imIf.replaceBy(ImHelper.nullExpr());
                ++this.totalRewrites;
            }
        } else if (imIf.getElseBlock().isEmpty() && imIf.getThenBlock().size() == 1 && imIf.getThenBlock().get(0) instanceof ImExitwhen) {
            this.optimizeIfExitwhen(imIf);
        }
    }

    private void optimizeConsecutiveSet(ImSet imSet1, ImSet imSet2) {
        ImVarAccess imVarAccess2;
        ImOperatorCall rightOpCall2;
        if (!(imSet1.getLeft() instanceof ImVarAccess)) {
            return;
        }
        ImVar leftVar1 = ((ImVarAccess)imSet1.getLeft()).getVar();
        if (!(imSet2.getLeft() instanceof ImVarAccess)) {
            return;
        }
        ImVar leftVar2 = ((ImVarAccess)imSet2.getLeft()).getVar();
        ImExpr rightExpr1 = imSet1.getRight();
        ImExpr rightExpr2 = imSet2.getRight();
        if (leftVar1 == leftVar2 && rightExpr2 instanceof ImOperatorCall && (rightOpCall2 = (ImOperatorCall)rightExpr2).getArguments().size() == 2 && rightOpCall2.getArguments().get(0) instanceof ImVarAccess && (imVarAccess2 = (ImVarAccess)rightOpCall2.getArguments().get(0)).getVar() == leftVar2 && this.sideEffectAnalysis.cannotUseVar((ImStmt)rightOpCall2.getArguments().get(1), leftVar1)) {
            rightExpr1.setParent(null);
            imVarAccess2.replaceBy(rightExpr1);
            imSet1.replaceBy(ImHelper.nullExpr());
            ++this.totalRewrites;
        }
    }
}

