/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.ast;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import de.peeeq.immutablecollections.ImmutableList;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrInterface;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.CyclicDependencyError;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.FunctionImplementation;
import de.peeeq.wurstscript.ast.HasReadVariables;
import de.peeeq.wurstscript.ast.JassToplevelDeclarations;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WPackages;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.AttrImportedPackage;
import de.peeeq.wurstscript.attributes.AttrNameDef;
import de.peeeq.wurstscript.attributes.AttrNearest;
import de.peeeq.wurstscript.attributes.AttrPos;
import de.peeeq.wurstscript.attributes.ByTypes;
import de.peeeq.wurstscript.attributes.CompilationUnitInfo;
import de.peeeq.wurstscript.attributes.Description;
import de.peeeq.wurstscript.attributes.DescriptionHtml;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.attributes.ErrorHandling;
import de.peeeq.wurstscript.attributes.GetByType;
import de.peeeq.wurstscript.attributes.IsDynamicContext;
import de.peeeq.wurstscript.attributes.PathDescription;
import de.peeeq.wurstscript.attributes.ReadVariables;
import de.peeeq.wurstscript.attributes.SmallHelpers;
import de.peeeq.wurstscript.attributes.UsedPackages;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.NameLinks;
import de.peeeq.wurstscript.attributes.names.NameResolution;
import de.peeeq.wurstscript.attributes.names.PackageLink;
import de.peeeq.wurstscript.attributes.names.TypeLink;
import de.peeeq.wurstscript.attributes.names.TypeNameLinks;
import de.peeeq.wurstscript.attributes.prettyPrint.PrettyPrinter;
import de.peeeq.wurstscript.attributes.prettyPrint.Spacer;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.types.WurstType;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

class CompilationUnitImpl
implements CompilationUnit {
    private Element parent;
    private CompilationUnitInfo cuInfo;
    private JassToplevelDeclarations jassDecls;
    private WPackages packages;
    private int zzattr_attrReadVariables_state = 0;
    private ImmutableList<NameDef> zzattr_attrReadVariables_cache;
    private int zzattr_attrNextScope_state = 0;
    private @Nullable WScope zzattr_attrNextScope_cache;
    private int zzattr_attrGetByType_state = 0;
    private ByTypes zzattr_attrGetByType_cache;
    private int zzattr_attrNameLinks_state = 0;
    private ImmutableMultimap<String, DefLink> zzattr_attrNameLinks_cache;
    private int zzattr_attrTypeNameLinks_state = 0;
    private ImmutableMultimap<String, TypeLink> zzattr_attrTypeNameLinks_cache;

    CompilationUnitImpl(CompilationUnitInfo cuInfo, JassToplevelDeclarations jassDecls, WPackages packages) {
        if (cuInfo == null) {
            throw new IllegalArgumentException("Element cuInfo must not be null.");
        }
        if (jassDecls == null) {
            throw new IllegalArgumentException("Element jassDecls must not be null.");
        }
        if (packages == null) {
            throw new IllegalArgumentException("Element packages must not be null.");
        }
        this.cuInfo = cuInfo;
        this.jassDecls = jassDecls;
        this.packages = packages;
        jassDecls.setParent(this);
        packages.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setCuInfo(CompilationUnitInfo cuInfo) {
        if (cuInfo == null) {
            throw new IllegalArgumentException();
        }
        this.cuInfo = cuInfo;
    }

    @Override
    public CompilationUnitInfo getCuInfo() {
        return this.cuInfo;
    }

    @Override
    public void setJassDecls(JassToplevelDeclarations jassDecls) {
        if (jassDecls == null) {
            throw new IllegalArgumentException();
        }
        this.jassDecls.setParent(null);
        jassDecls.setParent(this);
        this.jassDecls = jassDecls;
    }

    @Override
    public JassToplevelDeclarations getJassDecls() {
        return this.jassDecls;
    }

    @Override
    public void setPackages(WPackages packages) {
        if (packages == null) {
            throw new IllegalArgumentException();
        }
        this.packages.setParent(null);
        packages.setParent(this);
        this.packages = packages;
    }

    @Override
    public WPackages getPackages() {
        return this.packages;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.jassDecls;
            }
            case 1: {
                return this.packages;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                JassToplevelDeclarations oldElem = this.jassDecls;
                this.setJassDecls((JassToplevelDeclarations)newElem);
                return oldElem;
            }
            case 1: {
                WPackages oldElem = this.packages;
                this.setPackages((WPackages)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.jassDecls);
        action.accept(this.packages);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public CompilationUnit copy() {
        CompilationUnitImpl result = new CompilationUnitImpl(this.cuInfo, this.jassDecls.copy(), this.packages.copy());
        return result;
    }

    @Override
    public CompilationUnit copyWithRefs() {
        CompilationUnit res = this.copy();
        return res;
    }

    @Override
    public void clearAttributes() {
        this.jassDecls.clearAttributes();
        this.packages.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
        this.zzattr_attrReadVariables_state = 0;
        this.zzattr_attrNextScope_state = 0;
        this.zzattr_attrGetByType_state = 0;
        this.zzattr_attrNameLinks_state = 0;
        this.zzattr_attrTypeNameLinks_state = 0;
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(HasReadVariables.Matcher<T> matcher) {
        return matcher.case_CompilationUnit(this);
    }

    @Override
    public void match(HasReadVariables.MatcherVoid matcher) {
        matcher.case_CompilationUnit(this);
    }

    @Override
    public <T> T match(WScope.Matcher<T> matcher) {
        return matcher.case_CompilationUnit(this);
    }

    @Override
    public void match(WScope.MatcherVoid matcher) {
        matcher.case_CompilationUnit(this);
    }

    @Override
    public <T> T match(PackageOrGlobal.Matcher<T> matcher) {
        return matcher.case_CompilationUnit(this);
    }

    @Override
    public void match(PackageOrGlobal.MatcherVoid matcher) {
        matcher.case_CompilationUnit(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_CompilationUnit(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_CompilationUnit(this);
    }

    public String toString() {
        return "CompilationUnit(" + this.cuInfo + ", " + this.jassDecls + ", " + this.packages + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof CompilationUnit) {
            CompilationUnit o = (CompilationUnit)e;
            return Objects.equals(this.cuInfo, o.getCuInfo()) && this.jassDecls.structuralEquals(o.getJassDecls()) && this.packages.structuralEquals(o.getPackages());
        }
        return false;
    }

    @Override
    public ImmutableList<NameDef> attrReadVariables() {
        if (this.zzattr_attrReadVariables_state == 0) {
            try {
                this.zzattr_attrReadVariables_state = 1;
                this.zzattr_attrReadVariables_cache = ReadVariables.calculate(this);
            }
            finally {
                this.zzattr_attrReadVariables_state = 0;
            }
            this.zzattr_attrReadVariables_state = 2;
        } else if (this.zzattr_attrReadVariables_state == 1) {
            throw new CyclicDependencyError(this, "attrReadVariables");
        }
        return this.zzattr_attrReadVariables_cache;
    }

    @Override
    public boolean attrIsDynamicContext() {
        return IsDynamicContext.calculate(this);
    }

    @Override
    public @Nullable PackageOrGlobal attrNearestPackage() {
        return AttrNearest.nearestPackage(this);
    }

    @Override
    public @Nullable NamedScope attrNearestNamedScope() {
        return AttrNearest.nearestNamedScope(this);
    }

    @Override
    public @Nullable WScope attrNearestScope() {
        return AttrNearest.nearestScope(this);
    }

    @Override
    public @Nullable WScope attrNextScope() {
        if (this.zzattr_attrNextScope_state == 0) {
            try {
                this.zzattr_attrNextScope_state = 1;
                this.zzattr_attrNextScope_cache = AttrNearest.nextScope(this);
            }
            finally {
                this.zzattr_attrNextScope_state = 0;
            }
            this.zzattr_attrNextScope_state = 2;
        } else if (this.zzattr_attrNextScope_state == 1) {
            throw new CyclicDependencyError(this, "attrNextScope");
        }
        return this.zzattr_attrNextScope_cache;
    }

    @Override
    public String attrPathDescription() {
        return PathDescription.get(this);
    }

    @Override
    public CompilationUnit attrCompilationUnit() {
        return AttrNearest.nearestCompilationUnit(this);
    }

    @Override
    public @Nullable ClassDef attrNearestClassDef() {
        return AttrNearest.nearestClassDef(this);
    }

    @Override
    public @Nullable ClassOrInterface attrNearestClassOrInterface() {
        return AttrNearest.nearestClassOrInterface(this);
    }

    @Override
    public @Nullable ClassOrModule attrNearestClassOrModule() {
        return AttrNearest.nearestClassOrModule(this);
    }

    @Override
    public @Nullable StructureDef attrNearestStructureDef() {
        return AttrNearest.nearestStructureDef(this);
    }

    @Override
    public @Nullable FunctionImplementation attrNearestFuncDef() {
        return AttrNearest.nearestFuncDef(this);
    }

    @Override
    public @Nullable ExprClosure attrNearestExprClosure() {
        return AttrNearest.nearestExprClosure(this);
    }

    @Override
    public @Nullable ExprStatementsBlock attrNearestExprStatementsBlock() {
        return AttrNearest.nearestExprStatementsBlock(this);
    }

    @Override
    public @Nullable NameDef tryGetNameDef() {
        return AttrNameDef.tryGetNameDef(this);
    }

    @Override
    public WPos attrSource() {
        return AttrPos.getPos(this);
    }

    @Override
    public WPos attrErrorPos() {
        return AttrPos.getErrorPos(this);
    }

    @Override
    public WurstModel getModel() {
        return AttrImportedPackage.getModel(this);
    }

    @Override
    public ByTypes attrGetByType() {
        if (this.zzattr_attrGetByType_state == 0) {
            try {
                this.zzattr_attrGetByType_state = 1;
                this.zzattr_attrGetByType_cache = GetByType.calculate(this);
            }
            finally {
                this.zzattr_attrGetByType_state = 0;
            }
            this.zzattr_attrGetByType_state = 2;
        } else if (this.zzattr_attrGetByType_state == 1) {
            throw new CyclicDependencyError(this, "attrGetByType");
        }
        return this.zzattr_attrGetByType_cache;
    }

    @Override
    public void addError(String msg) {
        ErrorHandling.addError(this, msg);
    }

    @Override
    public void addWarning(String msg) {
        ErrorHandling.addWarning(this, msg);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return ErrorHandling.getErrorHandler(this);
    }

    @Override
    public ImmutableMultimap<String, DefLink> attrNameLinks() {
        if (this.zzattr_attrNameLinks_state == 0) {
            try {
                this.zzattr_attrNameLinks_state = 1;
                this.zzattr_attrNameLinks_cache = NameLinks.calculate(this);
            }
            finally {
                this.zzattr_attrNameLinks_state = 0;
            }
            this.zzattr_attrNameLinks_state = 2;
        } else if (this.zzattr_attrNameLinks_state == 1) {
            throw new CyclicDependencyError(this, "attrNameLinks");
        }
        return this.zzattr_attrNameLinks_cache;
    }

    @Override
    public ImmutableMultimap<String, TypeLink> attrTypeNameLinks() {
        if (this.zzattr_attrTypeNameLinks_state == 0) {
            try {
                this.zzattr_attrTypeNameLinks_state = 1;
                this.zzattr_attrTypeNameLinks_cache = TypeNameLinks.calculate(this);
            }
            finally {
                this.zzattr_attrTypeNameLinks_state = 0;
            }
            this.zzattr_attrTypeNameLinks_state = 2;
        } else if (this.zzattr_attrTypeNameLinks_state == 1) {
            throw new CyclicDependencyError(this, "attrTypeNameLinks");
        }
        return this.zzattr_attrTypeNameLinks_cache;
    }

    @Override
    public @Nullable TypeDef lookupType(String name, boolean showErrors) {
        return NameResolution.lookupType(this, name, showErrors);
    }

    @Override
    public PackageLink lookupPackage(String name, boolean showErrors) {
        return NameResolution.lookupPackage(this, name, showErrors);
    }

    @Override
    public NameLink lookupVar(String name, boolean showErrors) {
        return NameResolution.lookupVar(this, name, showErrors);
    }

    @Override
    public NameLink lookupVarNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupVarNoConfig(this, name, showErrors);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberVar(this, receiverType, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name, boolean showErrors) {
        return NameResolution.lookupFuncs(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncsNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupFuncsNoConfig(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberFuncs(this, receiverType, name, showErrors);
    }

    @Override
    public @Nullable TypeDef lookupType(String name) {
        return NameResolution.lookupTypeShort(this, name);
    }

    @Override
    public PackageLink lookupPackage(String name) {
        return NameResolution.lookupPackageShort(this, name);
    }

    @Override
    public NameLink lookupVar(String name) {
        return NameResolution.lookupVarShort(this, name);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name) {
        return NameResolution.lookupMemberVarShort(this, receiverType, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name) {
        return NameResolution.lookupFuncsShort(this, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name) {
        return NameResolution.lookupMemberFuncsShort(this, receiverType, name);
    }

    @Override
    public ImmutableCollection<WPackage> attrUsedPackages() {
        return UsedPackages.usedPackages(this);
    }

    @Override
    public String description() {
        return Description.description(this);
    }

    @Override
    public String descriptionHtml() {
        return DescriptionHtml.description(this);
    }

    @Override
    public boolean isSubtreeOf(Element other) {
        return SmallHelpers.isSubtreeOf(this, other);
    }

    @Override
    public void prettyPrint(Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.prettyPrint(this, spacer, sb, indent);
    }
}

