/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.FuncRef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.attributes.AttrFuncDef;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeReal;
import de.peeeq.wurstscript.types.WurstTypeString;
import de.peeeq.wurstscript.utils.Utils;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public class PossibleFuncDefs {
    public static ImmutableList<FuncLink> calculate(ExprFuncRef node) {
        ImmutableCollection<FuncLink> funcs;
        if (node.getScopeName().length() > 0) {
            TypeDef typeDef = node.lookupType(node.getScopeName());
            if (typeDef == null) {
                node.addError("Could not find type " + node.getScopeName() + ".");
                return Utils.emptyList();
            }
            WurstType receiverType = typeDef.attrTyp();
            funcs = node.lookupMemberFuncs(receiverType, node.getFuncName());
        } else {
            funcs = node.lookupFuncs(node.getFuncName());
        }
        funcs = PossibleFuncDefs.filterInvisible(node.getFuncName(), node, funcs);
        return ImmutableList.copyOf(funcs);
    }

    public static ImmutableCollection<FuncLink> calculate(ExprMemberMethod node) {
        Expr left = node.getLeft();
        WurstType leftType = left.attrTyp();
        String funcName = node.getFuncName();
        return PossibleFuncDefs.searchMemberFunc(node, leftType, funcName);
    }

    public static ImmutableCollection<FuncLink> calculate(ExprFunctionCall node) {
        return PossibleFuncDefs.searchFunction(node.getFuncName(), node);
    }

    private static ImmutableCollection<FuncLink> getExtensionFunction(Expr left, Expr right, WurstOperator op) {
        String funcName = op.getOverloadingFuncName();
        if (funcName == null || PossibleFuncDefs.nativeOperator(left.attrTyp(), right.attrTyp(), left)) {
            return Utils.emptyList();
        }
        return PossibleFuncDefs.searchMemberFunc(left, left.attrTyp(), funcName);
    }

    private static boolean nativeOperator(WurstType leftType, WurstType rightType, Element term) {
        return (leftType.isSubtypeOf(WurstTypeInt.instance(), term) || leftType.isSubtypeOf(WurstTypeReal.instance(), term)) && (rightType.isSubtypeOf(WurstTypeInt.instance(), term) || rightType.isSubtypeOf(WurstTypeReal.instance(), term)) || leftType instanceof WurstTypeString && rightType instanceof WurstTypeString;
    }

    private static ImmutableCollection<FuncLink> searchFunction(String funcName, @Nullable FuncRef node) {
        if (node == null) {
            return ImmutableList.of();
        }
        ImmutableCollection<FuncLink> funcs1 = node.lookupFuncs(funcName);
        if (funcs1.size() == 0) {
            if (funcName.startsWith("InitTrig_")) {
                return ImmutableList.of();
            }
            node.addError("Reference to function " + funcName + " could not be resolved.");
            return ImmutableList.of();
        }
        ImmutableList<FuncLink> funcs2 = AttrFuncDef.filterAnnotation(node, funcs1);
        ImmutableCollection<FuncLink> funcs = PossibleFuncDefs.filterInvisible(funcName, node, funcs2);
        if (funcs.size() <= 1) {
            return funcs;
        }
        funcs = PossibleFuncDefs.filterByReceiverType(node, funcName, funcs);
        return funcs;
    }

    private static ImmutableCollection<FuncLink> searchMemberFunc(Expr node, WurstType leftType, String funcName) {
        ImmutableCollection<FuncLink> funcs1 = node.lookupMemberFuncs(leftType, funcName);
        if (funcs1.size() == 0) {
            return ImmutableList.of();
        }
        ImmutableCollection<FuncLink> funcs = PossibleFuncDefs.filterInvisible(funcName, node, funcs1);
        if (funcs.size() <= 1) {
            return funcs;
        }
        funcs = PossibleFuncDefs.filterByReceiverType(node, funcName, funcs);
        return funcs;
    }

    private static ImmutableCollection<FuncLink> filterInvisible(String funcName, Element node, ImmutableCollection<FuncLink> funcs) {
        if (node.attrSource().getFile().equals("<REPL>")) {
            return funcs;
        }
        List<Object> funcs2 = Lists.newArrayListWithCapacity((int)funcs.size());
        for (FuncLink nl : funcs) {
            if (nl.getVisibility() == Visibility.PRIVATE_OTHER || nl.getVisibility() == Visibility.PROTECTED_OTHER) continue;
            funcs2.add(nl);
        }
        if ((funcs2 = Utils.removedDuplicates(funcs2)).size() == 0) {
            node.addError("Function " + funcName + " is not visible here.");
            return ImmutableList.of((Object)Utils.getFirst(funcs));
        }
        return ImmutableList.copyOf(funcs2);
    }

    private static ImmutableList<FuncLink> filterByReceiverType(Element node, String funcName, ImmutableCollection<FuncLink> funcs) {
        ImmutableList.Builder funcs3 = ImmutableList.builder();
        for (FuncLink f : funcs) {
            boolean existsMoreSpecific = false;
            WurstType f_receiverType = f.getReceiverType();
            if (f_receiverType != null) {
                for (FuncLink g : funcs) {
                    WurstType g_receiverType;
                    if (f == g || (g_receiverType = g.getReceiverType()) == null || !g_receiverType.isSubtypeOf(f_receiverType, node) || g_receiverType.equalsType(f_receiverType, node)) continue;
                    existsMoreSpecific = true;
                    break;
                }
            }
            if (existsMoreSpecific) continue;
            funcs3.add((Object)f);
        }
        ImmutableList funcs4 = funcs3.build();
        if (funcs4.size() == 0) {
            node.addError("Function " + funcName + " has a wrong receiver type.");
            return ImmutableList.of((Object)Utils.getFirst(funcs));
        }
        return funcs4;
    }

    public static ImmutableCollection<FuncLink> calculate(Annotation node) {
        return PossibleFuncDefs.searchFunction(node.getFuncName(), node);
    }
}

