/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.EventObjectTrack;

public class EventObjectTrackChunk
extends Chunk {
    public static Id TOKEN = Id.valueOf("KEVT");
    private long _globalSequenceId = 0L;
    private final LinkedHashSet<EventObjectTrack> _tracks = new ObservableLinkedHashSet<EventObjectTrack>();

    @Override
    public Id getToken() {
        return TOKEN;
    }

    public long getGlobalSequenceId() {
        return this._globalSequenceId;
    }

    public void setGlobaLSequenceId(long globaLSequenceId) {
        this._globalSequenceId = globaLSequenceId;
    }

    public LinkedHashSet<EventObjectTrack> getTracks() {
        return this._tracks;
    }

    private void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id token = stream.readId("token");
        if (!token.equals(this.getToken())) {
            throw new IllegalArgumentException("invalid " + this.getToken() + " startToken (" + token + ")");
        }
        this._globalSequenceId = stream.readUInt32("globalSequenceId");
        for (long tracksCount = stream.readUInt32("tracksCount").longValue(); tracksCount > 0L; --tracksCount) {
            this._tracks.add(new EventObjectTrack(stream));
        }
    }

    private void write_0x0(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        stream.writeId(TOKEN);
        stream.writeUInt32(this.getTracks().size());
        stream.writeUInt32(this._globalSequenceId);
        for (EventObjectTrack track : this.getTracks()) {
            track.write(stream);
        }
    }

    public void read(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        switch ((MDX.EncodingFormat.Enum)((Object)format.toEnum())) {
            case MDX_0x0: {
                this.read_0x0(stream);
            }
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        switch ((MDX.EncodingFormat.Enum)((Object)format.toEnum())) {
            case MDX_0x0: 
            case AUTO: {
                this.write_0x0(stream);
            }
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public EventObjectTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        this();
        this.read(stream, format);
    }

    public EventObjectTrackChunk() {
    }
}

