/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.validation.controlflow;

import com.google.common.collect.Sets;
import de.peeeq.immutablecollections.ImmutableList;
import de.peeeq.wurstscript.ast.AstElementWithBody;
import de.peeeq.wurstscript.ast.CompoundStatement;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprDestroy;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.ExprThis;
import de.peeeq.wurstscript.ast.ExprVarAccess;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.HasReadVariables;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.LoopStatement;
import de.peeeq.wurstscript.ast.LoopStatementWithVarDef;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.StartFunctionStatement;
import de.peeeq.wurstscript.ast.StmtSet;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.types.WurstTypeArray;
import de.peeeq.wurstscript.utils.Utils;
import de.peeeq.wurstscript.validation.controlflow.ForwardMethod;
import de.peeeq.wurstscript.validation.controlflow.VarStates;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

public class DataflowAnomalyAnalysis
extends ForwardMethod<VarStates, AstElementWithBody> {
    private final boolean jassCode;

    public DataflowAnomalyAnalysis(boolean jassCode) {
        this.jassCode = jassCode;
    }

    @Override
    VarStates calculate(WStatement s, VarStates incoming) {
        NameDef n;
        if (s instanceof StartFunctionStatement) {
            HashSet r = Sets.newHashSet();
            this.collectLocalVars(r, (Element)this.getFuncDef());
            return VarStates.initial(r);
        }
        if (s instanceof CompoundStatement) {
            for (int i = 0; i < s.size(); ++i) {
                if (!(s.get(i) instanceof Expr)) continue;
                Expr expr = (Expr)s.get(i);
                incoming = this.handleExprInCompound(incoming, expr);
            }
            if (s instanceof SwitchStmt) {
                SwitchStmt swi = (SwitchStmt)s;
                for (SwitchCase switchCase : swi.getCases()) {
                    for (Expr switchCaseExpr : switchCase.getExpressions()) {
                        incoming = this.handleExprInCompound(incoming, switchCaseExpr);
                    }
                }
            }
        } else {
            this.checkIfVarsInitialized(s, incoming);
            for (NameDef v : s.attrReadVariables()) {
                if (!this.isLocalVarDef(v)) continue;
                incoming = incoming.addRead((LocalVarDef)v, s);
            }
            if (incoming.thisDestroyed) {
                this.checkNoAccessToThis(s);
            }
        }
        if (s instanceof ExprDestroy) {
            ExprDestroy destr = (ExprDestroy)s;
            if (destr.getDestroyedObj() instanceof ExprVarAccess) {
                ExprVarAccess destroyed = (ExprVarAccess)destr.getDestroyedObj();
                NameDef destroyedVar = destroyed.attrNameDef();
                if (this.isLocalVarDef(destroyedVar)) {
                    return incoming.addDestroy((LocalVarDef)destroyedVar);
                }
            } else if (destr.getDestroyedObj() instanceof ExprThis) {
                return incoming.withThisDestroyed(true);
            }
        }
        if ((n = this.getInitializedVar(s)) != null && this.isLocalVarDef(n)) {
            LocalVarDef lv = (LocalVarDef)n;
            return incoming.addWrite(lv, s);
        }
        return incoming;
    }

    private boolean checkNoAccessToThis(Element s) {
        for (int i = 0; i < s.size(); ++i) {
            if (!this.checkNoAccessToThis(s.get(i))) continue;
            return true;
        }
        if (s instanceof ExprThis) {
            this.reportError(s, "Cannot access 'this' because it might already have been destroyed.");
            return true;
        }
        if (s instanceof FunctionCall) {
            if (((FunctionCall)s).attrImplicitParameter() instanceof ExprThis) {
                this.reportError(s, "Cannot access 'this' because it might already have been destroyed.");
                return true;
            }
        } else if (s instanceof NameRef && ((NameRef)s).attrImplicitParameter() instanceof ExprThis) {
            this.reportError(s, "Cannot access 'this' because it might already have been destroyed.");
            return true;
        }
        return false;
    }

    private VarStates handleExprInCompound(VarStates incoming, Expr expr) {
        this.checkIfVarsInitialized(expr, incoming);
        for (NameDef v : expr.attrReadVariables()) {
            if (!this.isLocalVarDef(v)) continue;
            incoming = incoming.addRead((LocalVarDef)v, expr);
        }
        return incoming;
    }

    private @Nullable NameDef getInitializedVar(WStatement s) {
        NameDef n = null;
        if (s instanceof StmtSet) {
            StmtSet s2 = (StmtSet)s;
            NameLink link = s2.getUpdatedExpr().attrNameLink();
            if (link != null) {
                n = link.getDef();
            }
        } else if (this.isLocalVarDef(s)) {
            LocalVarDef l = (LocalVarDef)s;
            if (l.getInitialExpr() instanceof Expr) {
                n = l;
            }
        } else if (s instanceof LoopStatementWithVarDef) {
            LoopStatementWithVarDef s2 = (LoopStatementWithVarDef)s;
            n = s2.getLoopVar();
        }
        return n;
    }

    private void collectLocalVars(Set<LocalVarDef> r, Element e) {
        if (this.isLocalVarDef(e)) {
            r.add((LocalVarDef)e);
        }
        for (int i = 0; i < e.size(); ++i) {
            Element c = e.get(i);
            if (c instanceof ExprClosure || c instanceof ExprStatementsBlock) continue;
            this.collectLocalVars(r, c);
        }
    }

    private boolean isLocalVarDef(Element e) {
        if (e instanceof LocalVarDef) {
            LocalVarDef l = (LocalVarDef)e;
            return !l.attrTyp().isArray();
        }
        return false;
    }

    private void checkIfVarsInitialized(HasReadVariables s, VarStates incoming) {
        ImmutableList<NameDef> readVars = s.attrReadVariables();
        for (NameDef v : readVars) {
            if (v.attrTyp() instanceof WurstTypeArray || !incoming.uninitialized(v) && !incoming.destroyed(v)) continue;
            HasReadVariables readingExpr = this.findRead(s, v);
            if (readingExpr == null) {
                readingExpr = s;
            }
            String error = "Variable " + v.getName();
            error = incoming.destroyed(v) ? error + " may have been destroyed already" : error + " may not have been initialized";
            this.reportError(readingExpr, error);
        }
    }

    private void reportError(Element location, String error) {
        if (this.jassCode) {
            location.addWarning(error);
        } else {
            location.addError(error);
        }
    }

    private @Nullable HasReadVariables findRead(Element e, NameDef v) {
        HasReadVariables result = null;
        if (e instanceof HasReadVariables) {
            HasReadVariables r = (HasReadVariables)e;
            if (!r.attrReadVariables().contains(v)) {
                return null;
            }
            result = r;
        }
        for (int i = 0; i < e.size(); ++i) {
            HasReadVariables r = this.findRead(e.get(i), v);
            if (r == null || this.isLeftOfStmtSet(r)) continue;
            return r;
        }
        return result;
    }

    private boolean isLeftOfStmtSet(HasReadVariables r) {
        Element parent = r.getParent();
        if (parent instanceof StmtSet) {
            StmtSet stmtSet = (StmtSet)parent;
            return stmtSet.getUpdatedExpr() == r;
        }
        return false;
    }

    @Override
    VarStates merge(Collection<VarStates> values) {
        Iterator<VarStates> it = values.iterator();
        VarStates r = it.next();
        while (it.hasNext()) {
            r = r.merge(it.next());
        }
        return r;
    }

    @Override
    String print(VarStates t) {
        if (t == null) {
            return "null";
        }
        return t.toString();
    }

    @Override
    void checkFinal(VarStates fin) {
        for (LocalVarDef var : fin.states.keySet()) {
            if (var.getName().startsWith("_")) continue;
            for (WStatement ur : fin.getUnreadWrites(var)) {
                if (ur instanceof LoopStatement) continue;
                HasReadVariables errorPos = ur;
                if (ur instanceof StmtSet) {
                    errorPos = ((StmtSet)ur).getUpdatedExpr();
                }
                errorPos.addWarning("The assignment to " + Utils.printElement(var) + " is never read.");
            }
        }
    }

    @Override
    public VarStates startValue() {
        return VarStates.initial(Collections.emptySet());
    }
}

