/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SmartSet<T>
extends AbstractSet<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Object data;
    private int size;

    private SmartSet() {
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator iterator2;
        if (this.size() == 0) {
            iterator2 = Collections.emptySet().iterator();
        } else if (this.size() == 1) {
            iterator2 = new SingletonIterator<Object>(this.data);
        } else if (this.size() < 5) {
            Object object = this.data;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of org.jetbrains.kotlin.utils.SmartSet>");
            }
            iterator2 = new ArrayIterator<Object>((Object[])object);
        } else {
            Object object = this.data;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableSet<T of org.jetbrains.kotlin.utils.SmartSet>");
            }
            iterator2 = TypeIntrinsics.asMutableSet((Object)object).iterator();
        }
        return iterator2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(T element) {
        Object object;
        Object[] objectArray;
        if (this.size() == 0) {
            this.data = element;
        } else if (this.size() == 1) {
            if (Intrinsics.areEqual((Object)this.data, element)) {
                return false;
            }
            objectArray = new Object[]{this.data, element};
            this.data = objectArray;
        } else if (this.size() < 5) {
            Object object2;
            Object[] objectArray2;
            object = this.data;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of org.jetbrains.kotlin.utils.SmartSet>");
            }
            Object[] arr = object;
            if (ArraysKt.contains((Object[])arr, element)) {
                return false;
            }
            Object[] objectArray3 = this;
            if (this.size() == 4) {
                void $this$add_u24lambda_u2d0;
                object = SetsKt.linkedSetOf((Object[])Arrays.copyOf(arr, arr.length));
                boolean bl = false;
                boolean bl2 = false;
                Object object3 = object;
                Object[] objectArray4 = objectArray3;
                boolean bl3 = false;
                $this$add_u24lambda_u2d0.add(element);
                Unit unit = Unit.INSTANCE;
                objectArray2 = objectArray4;
                object2 = object;
            } else {
                object = arr;
                int n = this.size() + 1;
                boolean bl = false;
                Object[] objectArray5 = Arrays.copyOf(object, n);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray5, (String)"java.util.Arrays.copyOf(this, newSize)");
                object = objectArray5;
                n = 0;
                bl = false;
                Object $this$add_u24lambda_u2d0 = object;
                Object[] objectArray6 = objectArray3;
                boolean bl4 = false;
                $this$add_u24lambda_u2d1[((void)$this$add_u24lambda_u2d1).length - 1] = element;
                Unit unit = Unit.INSTANCE;
                objectArray2 = objectArray6;
                object2 = object;
            }
            objectArray2.data = object2;
        } else {
            object = this.data;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableSet<T of org.jetbrains.kotlin.utils.SmartSet>");
            }
            Set set = TypeIntrinsics.asMutableSet((Object)object);
            if (!set.add(element)) {
                return false;
            }
        }
        objectArray = this;
        int n = objectArray.size();
        objectArray.setSize(n + 1);
        return true;
    }

    @Override
    public void clear() {
        this.data = null;
        this.setSize(0);
    }

    @Override
    public boolean contains(Object element) {
        boolean bl;
        if (this.size() == 0) {
            bl = false;
        } else if (this.size() == 1) {
            bl = Intrinsics.areEqual((Object)this.data, (Object)element);
        } else if (this.size() < 5) {
            Object object = this.data;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of org.jetbrains.kotlin.utils.SmartSet>");
            }
            bl = ArraysKt.contains((Object[])((Object[])object), (Object)element);
        } else {
            Object object = this.data;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Set<T of org.jetbrains.kotlin.utils.SmartSet>");
            }
            bl = ((Set)object).contains(element);
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create() {
        return Companion.create();
    }

    public /* synthetic */ SmartSet(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create() {
            return new SmartSet(null);
        }

        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create(@NotNull Collection<? extends T> set) {
            Intrinsics.checkNotNullParameter(set, (String)"set");
            SmartSet smartSet = new SmartSet(null);
            boolean bl = false;
            boolean bl2 = false;
            SmartSet $this$create_u24lambda_u2d0 = smartSet;
            boolean bl3 = false;
            $this$create_u24lambda_u2d0.addAll(set);
            return smartSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private static final class SingletonIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        private final T element;
        private boolean hasNext;

        public SingletonIterator(T element) {
            this.element = element;
            this.hasNext = true;
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.element;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @NotNull
        public Void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ArrayIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        @NotNull
        private final Iterator<T> arrayIterator;

        public ArrayIterator(@NotNull T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            this.arrayIterator = ArrayIteratorKt.iterator((Object[])array);
        }

        @Override
        public boolean hasNext() {
            return this.arrayIterator.hasNext();
        }

        @Override
        public T next() {
            return this.arrayIterator.next();
        }

        @NotNull
        public Void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

