/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.PathScanningMatcher;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.fs.SftpPathDirectoryScanner;

public class SftpClientDirectoryScanner
extends PathScanningMatcher {
    protected String basedir;

    public SftpClientDirectoryScanner() {
        this(true);
    }

    public SftpClientDirectoryScanner(boolean caseSensitive) {
        this.setSeparator("/");
        this.setCaseSensitive(caseSensitive);
    }

    public SftpClientDirectoryScanner(String dir) {
        this(dir, Collections.emptyList());
    }

    public SftpClientDirectoryScanner(String dir, String ... includes) {
        this(dir, GenericUtils.isEmpty(includes) ? Collections.emptyList() : Arrays.asList(includes));
    }

    public SftpClientDirectoryScanner(String dir, Collection<String> includes) {
        this();
        this.setBasedir(dir);
        this.setIncludes(includes);
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = ValidateUtils.checkNotNullAndNotEmpty(basedir, "No base directory provided");
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public void setSeparator(String separator) {
        ValidateUtils.checkState("/".equals(separator), "Invalid separator: '%s'", (Object)separator);
        super.setSeparator(separator);
    }

    @Override
    public void setIncludes(Collection<String> includes) {
        this.includePatterns = GenericUtils.isEmpty(includes) ? Collections.emptyList() : Collections.unmodifiableList(includes.stream().map(SftpPathDirectoryScanner::adjustPattern).collect(Collectors.toCollection(() -> new ArrayList(includes.size()))));
    }

    public Collection<ScanDirEntry> scan(SftpClient client) throws IOException, IllegalStateException {
        return this.scan(client, LinkedList::new);
    }

    public <C extends Collection<ScanDirEntry>> C scan(SftpClient client, Supplier<? extends C> factory) throws IOException, IllegalStateException {
        String rootDir = this.getBasedir();
        ValidateUtils.checkState(GenericUtils.isNotEmpty(rootDir), "No basedir set");
        rootDir = client.canonicalPath(rootDir);
        SftpClient.Attributes attrs = client.stat(rootDir);
        if (attrs == null) {
            throw new IllegalStateException("basedir " + rootDir + " does not exist");
        }
        if (!attrs.isDirectory()) {
            throw new IllegalStateException("basedir " + rootDir + " is not a directory");
        }
        if (GenericUtils.isEmpty(this.getIncludes())) {
            throw new IllegalStateException("No includes set for " + rootDir);
        }
        return (C)this.scandir(client, rootDir, "", (Collection)factory.get());
    }

    protected <C extends Collection<ScanDirEntry>> C scandir(SftpClient client, String rootDir, String parent, C filesList) throws IOException {
        Collection<SftpClient.DirEntry> entries = client.readEntries(rootDir);
        if (GenericUtils.isEmpty(entries)) {
            return filesList;
        }
        for (SftpClient.DirEntry de : entries) {
            String name = de.getFilename();
            if (".".equals(name) || "..".equals(name)) continue;
            SftpClient.Attributes attrs = de.getAttributes();
            if (attrs.isDirectory()) {
                if (this.isIncluded(name)) {
                    String fullPath = this.createRelativePath(rootDir, name);
                    String relPath = this.createRelativePath(parent, name);
                    filesList.add((ScanDirEntry)new ScanDirEntry(fullPath, relPath, de));
                    this.scandir(client, fullPath, relPath, filesList);
                    continue;
                }
                if (!this.couldHoldIncluded(name)) continue;
                this.scandir(client, this.createRelativePath(rootDir, name), this.createRelativePath(parent, name), filesList);
                continue;
            }
            if (!attrs.isRegularFile() || !this.isIncluded(name)) continue;
            filesList.add((ScanDirEntry)new ScanDirEntry(this.createRelativePath(rootDir, name), this.createRelativePath(parent, name), de));
        }
        return filesList;
    }

    protected String createRelativePath(String parent, String name) {
        if (GenericUtils.isEmpty(parent)) {
            return name;
        }
        return parent + this.getSeparator() + name;
    }

    public static class ScanDirEntry
    extends SftpClient.DirEntry {
        private final String fullPath;
        private final String relativePath;

        public ScanDirEntry(String fullPath, String relativePath, SftpClient.DirEntry dirEntry) {
            super(dirEntry);
            this.fullPath = fullPath;
            this.relativePath = relativePath;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        @Override
        public String toString() {
            return this.getFullPath() + " - " + super.toString();
        }
    }
}

