/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.core.CoreModuleProperties;

public class LocalWindow
extends Window {
    private final AbstractChannel channel;
    private final AtomicLong adjustment = new AtomicLong();
    private long released;

    public LocalWindow(AbstractChannel channel, boolean isClient) {
        super(channel, isClient);
        this.channel = channel;
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channel;
    }

    public void init(PropertyResolver resolver) {
        this.init(CoreModuleProperties.WINDOW_SIZE.getRequired(resolver), CoreModuleProperties.MAX_PACKET_SIZE.getRequired(resolver), resolver);
        this.released = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(long len) throws IOException {
        long remainLen;
        BufferUtils.validateUint32Value(len, "Invalid consumption length: %d");
        this.checkInitialized("consume");
        Object object = this.lock;
        synchronized (object) {
            remainLen = this.getSize() - len;
            if (remainLen >= 0L) {
                this.updateSize(remainLen);
            }
        }
        if (remainLen < 0L) {
            throw new StreamCorruptedException("consume(" + this + ") required length (" + len + ") above available: " + (remainLen + len));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Consume {} by {} down to {}", this, len, remainLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(long len) throws IOException {
        long adjustSize;
        this.checkInitialized("check");
        if (len < 0L) {
            throw new IllegalArgumentException("LocalWindow: number of released bytes must be positive, was " + len);
        }
        long maxFree = this.getMaxSize();
        long packetSize = this.getPacketSize();
        boolean trySend = false;
        Object object = this.lock;
        synchronized (object) {
            long newSize;
            long size;
            this.released += len;
            if (!(this.released <= packetSize / 2L && this.released <= maxFree / 10L && this.released <= 16384L || (size = this.getSize()) >= maxFree / 2L && maxFree - size <= 3L * packetSize || (newSize = Math.min(size + this.released, maxFree)) <= size)) {
                long adjustSize2 = this.adjustment.addAndGet(newSize - size);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Increase {}: released now {}, total {}, adjustment {}, new size {}", this, len, this.released, adjustSize2, newSize);
                }
                this.released = 0L;
                trySend = true;
                this.updateSize(newSize);
            }
        }
        if (trySend && (adjustSize = this.adjustment.getAndSet(0L)) > 0L) {
            this.getChannel().sendWindowAdjust(adjustSize);
        }
    }
}

