/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.mac;

import org.apache.sshd.common.mac.MacInformation;
import org.apache.sshd.common.util.NumberUtils;

public interface Mac
extends MacInformation {
    public void init(byte[] var1) throws Exception;

    default public void update(byte[] buf) {
        this.update(buf, 0, NumberUtils.length(buf));
    }

    public void update(byte[] var1, int var2, int var3);

    public void updateUInt(long var1);

    default public byte[] doFinal() throws Exception {
        int blockSize = this.getBlockSize();
        byte[] buf = new byte[blockSize];
        this.doFinal(buf);
        return buf;
    }

    default public void doFinal(byte[] buf) throws Exception {
        this.doFinal(buf, 0);
    }

    public void doFinal(byte[] var1, int var2) throws Exception;

    public static boolean equals(byte[] a1, int a1Offset, byte[] a2, int a2Offset, int length) {
        int len1 = NumberUtils.length(a1);
        int len2 = NumberUtils.length(a2);
        int result2 = 0;
        if (len1 < a1Offset + length) {
            length = Math.min(length, len1 - a1Offset);
            length = Math.max(length, 0);
            result2 |= 0xFF;
        }
        if (len2 < a2Offset + length) {
            length = Math.min(length, len2 - a2Offset);
            length = Math.max(length, 0);
            result2 |= 0xFF00;
        }
        for (int cmpLen = length; cmpLen > 0; --cmpLen) {
            result2 |= a1[a1Offset] ^ a2[a2Offset];
            ++a1Offset;
            ++a2Offset;
        }
        return result2 == 0;
    }
}

