/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.CLICommand;
import file.ExceptionHandler;
import file.GlobalOptions;
import file.SetupApp;
import file.SetupMain;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0(\u00a2\u0006\u0002\u0010)J\u0016\u0010*\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0,H\u0002J\u001e\u0010-\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0,2\u0006\u0010.\u001a\u00020/H\u0002J\u000e\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020\u001dR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013R\u001a\u0010\u0019\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0011\"\u0004\b$\u0010\u0013\u00a8\u00063"}, d2={"Lfile/SetupMain;", "", "()V", "command", "Lfile/CLICommand;", "getCommand", "()Lfile/CLICommand;", "setCommand", "(Lfile/CLICommand;)V", "commandArg", "", "getCommandArg", "()Ljava/lang/String;", "setCommandArg", "(Ljava/lang/String;)V", "isGUILaunch", "", "()Z", "setGUILaunch", "(Z)V", "log", "Lmu/KLogger;", "measure", "getMeasure", "setMeasure", "noPJass", "getNoPJass", "setNoPJass", "projectRoot", "Ljava/nio/file/Path;", "getProjectRoot", "()Ljava/nio/file/Path;", "setProjectRoot", "(Ljava/nio/file/Path;)V", "requireConfirmation", "getRequireConfirmation", "setRequireConfirmation", "doMain", "", "args", "", "([Ljava/lang/String;)V", "parseCLIArgs", "argsList", "", "parseGlobalArgs", "start", "", "setProjectDir", "dir", "Companion", "WurstSetup"})
@SourceDebugExtension(value={"SMAP\nSetupMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetupMain.kt\nfile/SetupMain\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,92:1\n13309#2,2:93\n*S KotlinDebug\n*F\n+ 1 SetupMain.kt\nfile/SetupMain\n*L\n71#1:93,2\n*E\n"})
public final class SetupMain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger log = KotlinLogging.INSTANCE.logger(log.1.INSTANCE);
    private boolean isGUILaunch;
    @NotNull
    private CLICommand command = CLICommand.HELP;
    @NotNull
    private String commandArg = "";
    private boolean measure;
    @NotNull
    private Path projectRoot = SetupApp.INSTANCE.getDEFAULT_DIR();
    private boolean requireConfirmation;
    private boolean noPJass;

    public final boolean isGUILaunch() {
        return this.isGUILaunch;
    }

    public final void setGUILaunch(boolean bl) {
        this.isGUILaunch = bl;
    }

    @NotNull
    public final CLICommand getCommand() {
        return this.command;
    }

    public final void setCommand(@NotNull CLICommand cLICommand) {
        Intrinsics.checkNotNullParameter((Object)cLICommand, "<set-?>");
        this.command = cLICommand;
    }

    @NotNull
    public final String getCommandArg() {
        return this.commandArg;
    }

    public final void setCommandArg(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.commandArg = string;
    }

    public final boolean getMeasure() {
        return this.measure;
    }

    public final void setMeasure(boolean bl) {
        this.measure = bl;
    }

    @NotNull
    public final Path getProjectRoot() {
        return this.projectRoot;
    }

    public final void setProjectRoot(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "<set-?>");
        this.projectRoot = path;
    }

    public final boolean getRequireConfirmation() {
        return this.requireConfirmation;
    }

    public final void setRequireConfirmation(boolean bl) {
        this.requireConfirmation = bl;
    }

    public final boolean getNoPJass() {
        return this.noPJass;
    }

    public final void setNoPJass(boolean bl) {
        this.noPJass = bl;
    }

    public final void setProjectDir(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Files.createDirectories(dir, new FileAttribute[0]);
        if (Files.exists(dir, new LinkOption[0])) {
            this.projectRoot = dir;
        }
    }

    public final void doMain(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        ExceptionHandler.INSTANCE.setupExceptionHandler();
        List<String> argsList = ArraysKt.asList(args2);
        if (argsList.isEmpty()) {
            this.isGUILaunch = true;
        } else {
            this.parseCLIArgs(argsList);
        }
        SetupApp.INSTANCE.handleArgs(this);
    }

    private final void parseCLIArgs(List<String> argsList) throws IllegalArgumentException {
        String first = argsList.get(0);
        try {
            String string = first.toUpperCase();
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            this.command = CLICommand.valueOf(string);
            this.log.debug("found " + this.command);
            if (argsList.size() > 1) {
                if (!StringsKt.startsWith$default(argsList.get(1), "-", false, 2, null)) {
                    this.commandArg = argsList.get(1);
                    this.parseGlobalArgs(argsList, 2);
                } else {
                    this.parseGlobalArgs(argsList, 1);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.log.error("\ud83d\udd25 Invalid grill command <" + first + "> ! Available commands: [generate|install|remove|test|build] <command argument>");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void parseGlobalArgs(List<String> argsList, int start) {
        int skip = 0;
        int n = argsList.size();
        for (int i = start; i < n; ++i) {
            if (skip > 0) {
                --skip;
                continue;
            }
            GlobalOptions[] $this$forEach$iv = GlobalOptions.values();
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int j = 0; j < n2; ++j) {
                GlobalOptions element$iv;
                GlobalOptions it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getOptionName(), argsList.get(start))) continue;
                it.runOption(this, argsList.subList(i, i + it.getArgCount()));
            }
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lfile/SetupMain$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "WurstSetup"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            new SetupMain().doMain(args2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

