/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.module.kotlin.KotlinKeySerializersKt;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u0012*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0012B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J%\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ValueClassStaticJsonKeySerializer;", "T", "Lcom/fasterxml/jackson/databind/ser/std/StdSerializer;", "t", "Ljava/lang/Class;", "staticJsonKeyGetter", "Ljava/lang/reflect/Method;", "(Ljava/lang/Class;Ljava/lang/reflect/Method;)V", "keyType", "unboxMethod", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "(Ljava/lang/Object;Lcom/fasterxml/jackson/core/JsonGenerator;Lcom/fasterxml/jackson/databind/SerializerProvider;)V", "Companion", "jackson-module-kotlin"})
public final class ValueClassStaticJsonKeySerializer<T>
extends StdSerializer<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Method staticJsonKeyGetter;
    @NotNull
    private final Class<?> keyType;
    @NotNull
    private final Method unboxMethod;

    public ValueClassStaticJsonKeySerializer(@NotNull Class<T> t, @NotNull Method staticJsonKeyGetter) {
        Intrinsics.checkNotNullParameter(t, "t");
        Intrinsics.checkNotNullParameter(staticJsonKeyGetter, "staticJsonKeyGetter");
        super(t);
        this.staticJsonKeyGetter = staticJsonKeyGetter;
        GenericDeclaration genericDeclaration = this.staticJsonKeyGetter.getReturnType();
        Intrinsics.checkNotNullExpressionValue(genericDeclaration, "staticJsonKeyGetter.returnType");
        this.keyType = genericDeclaration;
        genericDeclaration = t.getMethod("unbox-impl", new Class[0]);
        Intrinsics.checkNotNullExpressionValue(genericDeclaration, "t.getMethod(\"unbox-impl\")");
        this.unboxMethod = genericDeclaration;
    }

    @Override
    public void serialize(T value, @NotNull JsonGenerator gen, @NotNull SerializerProvider provider) {
        JsonSerializer<Object> jsonSerializer;
        Object jsonKey;
        Intrinsics.checkNotNullParameter(gen, "gen");
        Intrinsics.checkNotNullParameter(provider, "provider");
        Object unboxed = this.unboxMethod.invoke(value, new Object[0]);
        Object[] objectArray = new Object[]{unboxed};
        Object object = jsonKey = this.staticJsonKeyGetter.invoke(null, objectArray);
        if (object == null) {
            jsonSerializer = null;
        } else {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            jsonSerializer = provider.findKeySerializer(this.keyType, null);
        }
        JsonSerializer<Object> jsonSerializer2 = jsonSerializer;
        JsonSerializer<Object> serializer = jsonSerializer2 == null ? provider.findNullKeySerializer(provider.constructType(this.keyType), null) : jsonSerializer2;
        serializer.serialize(jsonKey, gen, provider);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\u0007"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ValueClassStaticJsonKeySerializer$Companion;", "", "()V", "createOrNull", "Lcom/fasterxml/jackson/databind/ser/std/StdSerializer;", "t", "Ljava/lang/Class;", "jackson-module-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final StdSerializer<?> createOrNull(@NotNull Class<?> t) {
            ValueClassStaticJsonKeySerializer valueClassStaticJsonKeySerializer;
            Intrinsics.checkNotNullParameter(t, "t");
            Method method = KotlinKeySerializersKt.access$getStaticJsonKeyGetter(t);
            if (method == null) {
                valueClassStaticJsonKeySerializer = null;
            } else {
                Method method2 = method;
                boolean bl = false;
                boolean bl2 = false;
                Method it = method2;
                boolean bl3 = false;
                valueClassStaticJsonKeySerializer = new ValueClassStaticJsonKeySerializer(t, it);
            }
            return valueClassStaticJsonKeySerializer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

