/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

final class UInt24Array {
    public static final UInt24Array EMPTY = new UInt24Array(new byte[0]);
    private static final int ENTRY_SZ = 3;
    private final byte[] data;
    private final int size;

    UInt24Array(byte[] data2) {
        this.data = data2;
        this.size = data2.length / 3;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    int size() {
        return this.size;
    }

    int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(index);
        }
        int offset = index * 3;
        int e = this.data[offset] & 0xFF;
        e <<= 8;
        e |= this.data[offset + 1] & 0xFF;
        e <<= 8;
        return e |= this.data[offset + 2] & 0xFF;
    }

    int binarySearch(int needle) {
        if ((needle & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Too big value for 3 bytes");
        }
        if (this.size == 0) {
            return -1;
        }
        int high = this.size;
        if (high == 0) {
            return -1;
        }
        int low = 0;
        do {
            int mid;
            int cmp;
            if ((cmp = Integer.compare(needle, this.get(mid = low + high >>> 1))) < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                return mid;
            }
            low = mid + 1;
        } while (low < high);
        return -1;
    }

    int getLastValue() {
        return this.get(this.size - 1);
    }
}

