/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.json;

import java.util.Iterator;
import us.monoid.json.HTTPTokener;
import us.monoid.json.JSONException;
import us.monoid.json.JSONObject;

public class HTTP {
    public static final String CRLF = "\r\n";

    public static JSONObject toJSONObject(String string) throws JSONException {
        JSONObject o = new JSONObject();
        HTTPTokener x = new HTTPTokener(string);
        String t = x.nextToken();
        if (t.toUpperCase().startsWith("HTTP")) {
            o.put("HTTP-Version", (Object)t);
            o.put("Status-Code", (Object)x.nextToken());
            o.put("Reason-Phrase", (Object)x.nextTo('\u0000'));
            x.next();
        } else {
            o.put("Method", (Object)t);
            o.put("Request-URI", (Object)x.nextToken());
            o.put("HTTP-Version", (Object)x.nextToken());
        }
        while (x.more()) {
            String name = x.nextTo(':');
            x.next(':');
            o.put(name, (Object)x.nextTo('\u0000'));
            x.next();
        }
        return o;
    }

    public static String toString(JSONObject o) throws JSONException {
        Iterator<String> keys2 = o.keys();
        StringBuffer sb = new StringBuffer();
        if (o.has("Status-Code") && o.has("Reason-Phrase")) {
            sb.append(o.getString("HTTP-Version"));
            sb.append(' ');
            sb.append(o.getString("Status-Code"));
            sb.append(' ');
            sb.append(o.getString("Reason-Phrase"));
        } else if (o.has("Method") && o.has("Request-URI")) {
            sb.append(o.getString("Method"));
            sb.append(' ');
            sb.append('\"');
            sb.append(o.getString("Request-URI"));
            sb.append('\"');
            sb.append(' ');
            sb.append(o.getString("HTTP-Version"));
        } else {
            throw new JSONException("Not enough material for an HTTP header.");
        }
        sb.append(CRLF);
        while (keys2.hasNext()) {
            String s = keys2.next().toString();
            if (s.equals("HTTP-Version") || s.equals("Status-Code") || s.equals("Reason-Phrase") || s.equals("Method") || s.equals("Request-URI") || o.isNull(s)) continue;
            sb.append(s);
            sb.append(": ");
            sb.append(o.getString(s));
            sb.append(CRLF);
        }
        sb.append(CRLF);
        return sb.toString();
    }
}

