/*
 * Decompiled with CFR 0.152.
 */
package tablelayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import tablelayout.BaseTableLayout;
import tablelayout.Cell;
import tablelayout.Stack;
import tablelayout.SwingToolkit;
import tablelayout.TableLayout;
import tablelayout.Toolkit;
import tablelayout.Value;

public class Table
extends JComponent {
    private final TableLayout layout;

    public Table() {
        this(new TableLayout());
    }

    public Table(final TableLayout layout) {
        this.layout = layout;
        layout.setTable(this);
        this.setLayout(new LayoutManager(){
            private Dimension minSize = new Dimension();
            private Dimension prefSize = new Dimension();

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                layout.layout();
                this.prefSize.width = (int)layout.getMinWidth();
                this.prefSize.height = (int)layout.getMinHeight();
                return this.prefSize;
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                layout.layout();
                this.minSize.width = (int)layout.getMinWidth();
                this.minSize.height = (int)layout.getMinHeight();
                return this.minSize;
            }

            @Override
            public void layoutContainer(Container ignored) {
                layout.layout();
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }
        });
    }

    public void clear() {
        this.layout.clear();
        this.invalidate();
    }

    public Cell addCell(String text) {
        return this.addCell(new JLabel(text));
    }

    public Cell addCell() {
        return this.addCell((Component)null);
    }

    public Cell addCell(Component Component2) {
        return this.layout.add(Component2);
    }

    public Cell stack(Component ... components) {
        Stack stack = new Stack();
        for (Component component : components) {
            stack.add(component);
        }
        return this.addCell(stack);
    }

    public Cell row() {
        return this.layout.row();
    }

    public Cell columnDefaults(int column) {
        return this.layout.columnDefaults(column);
    }

    public Cell defaults() {
        return this.layout.defaults();
    }

    @Override
    public void layout() {
        this.layout.layout();
    }

    public void reset() {
        this.layout.reset();
    }

    public Cell getCell(Component Component2) {
        return this.layout.getCell(Component2);
    }

    public List<Cell> getCells() {
        return this.layout.getCells();
    }

    public Table pad(Value pad) {
        this.layout.pad(pad);
        return this;
    }

    public Table pad(Value top, Value left, Value bottom, Value right) {
        this.layout.pad(top, left, bottom, right);
        return this;
    }

    public Table padTop(Value padTop) {
        this.layout.padTop(padTop);
        return this;
    }

    public Table padLeft(Value padLeft) {
        this.layout.padLeft(padLeft);
        return this;
    }

    public Table padBottom(Value padBottom) {
        this.layout.padBottom(padBottom);
        return this;
    }

    public Table padRight(Value padRight) {
        this.layout.padRight(padRight);
        return this;
    }

    public Table pad(int pad) {
        this.layout.pad(pad);
        return this;
    }

    public Table pad(int top, int left, int bottom, int right) {
        this.layout.pad(top, left, bottom, right);
        return this;
    }

    public Table padTop(int padTop) {
        this.layout.padTop(padTop);
        return this;
    }

    public Table padLeft(int padLeft) {
        this.layout.padLeft(padLeft);
        return this;
    }

    public Table padBottom(int padBottom) {
        this.layout.padBottom(padBottom);
        return this;
    }

    public Table padRight(int padRight) {
        this.layout.padRight(padRight);
        return this;
    }

    public Table align(int align) {
        this.layout.align(align);
        return this;
    }

    public Table center() {
        this.layout.center();
        return this;
    }

    public Table top() {
        this.layout.top();
        return this;
    }

    public Table left() {
        this.layout.left();
        return this;
    }

    public Table bottom() {
        this.layout.bottom();
        return this;
    }

    public Table right() {
        this.layout.right();
        return this;
    }

    public Table debug() {
        this.layout.debug();
        return this;
    }

    public Table debug(BaseTableLayout.Debug debug) {
        this.layout.debug(debug);
        return this;
    }

    public BaseTableLayout.Debug getDebug() {
        return this.layout.getDebug();
    }

    public Value getPadTop() {
        return this.layout.getPadTopValue();
    }

    public Value getPadLeft() {
        return this.layout.getPadLeftValue();
    }

    public Value getPadBottom() {
        return this.layout.getPadBottomValue();
    }

    public Value getPadRight() {
        return this.layout.getPadRightValue();
    }

    public int getAlign() {
        return this.layout.getAlign();
    }

    public TableLayout getTableLayout() {
        return this.layout;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.layout.invalidate();
    }

    static {
        Toolkit.instance = new SwingToolkit();
    }
}

