/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;

public class SftpPathImpl
extends SftpPath {
    private SftpClient.Attributes attributes;
    private int cachingLevel;

    public SftpPathImpl(SftpFileSystem fileSystem, String root, List<String> names) {
        super(fileSystem, root, names);
    }

    protected void cacheAttributes(boolean doCache) {
        if (doCache) {
            if (this.cachingLevel == 0) {
                this.attributes = null;
            }
            ++this.cachingLevel;
        } else if (this.cachingLevel > 0) {
            --this.cachingLevel;
            if (this.cachingLevel == 0) {
                this.attributes = null;
            }
        } else {
            throw new IllegalStateException("SftpPathImpl.cacheAttributes(boolean) not properly nested");
        }
    }

    public void cacheAttributes(SftpClient.Attributes attributes) {
        if (this.cachingLevel > 0) {
            this.setAttributes(attributes);
        }
    }

    public void setAttributes(SftpClient.Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public SftpClient.Attributes getAttributes() {
        return this.attributes;
    }

    public <T> T withAttributeCache(IOFunction<Path, T> operation) throws IOException {
        this.cacheAttributes(true);
        try {
            T t = operation.apply(this);
            return t;
        }
        finally {
            this.cacheAttributes(false);
        }
    }

    public static <T> T withAttributeCache(Path path, IOFunction<Path, T> operation) throws IOException {
        if (path instanceof SftpPathImpl) {
            return ((SftpPathImpl)path).withAttributeCache(operation);
        }
        return operation.apply(path);
    }
}

