/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;

public class ChannelSession
extends AbstractClientChannel {
    protected CloseableExecutorService pumperService;
    protected Future<?> pumper;
    private final Map<String, Object> env = new LinkedHashMap<String, Object>();

    public ChannelSession() {
        super("session");
    }

    @Override
    protected void doOpen() throws IOException {
        if (StreamingChannel.Streaming.Async.equals((Object)this.streaming)) {
            this.asyncIn = new ChannelAsyncOutputStream(this, 94){

                @Override
                protected CloseFuture doCloseGracefully() {
                    DefaultCloseFuture result2 = new DefaultCloseFuture(ChannelSession.this.getChannelId(), this.futureLock);
                    CloseFuture packetsWritten = super.doCloseGracefully();
                    packetsWritten.addListener(p -> {
                        try {
                            IoWriteFuture eofSent = ChannelSession.this.sendEof();
                            if (eofSent != null) {
                                eofSent.addListener(f -> result2.setClosed());
                                return;
                            }
                        }
                        catch (Exception e) {
                            ChannelSession.this.getSession().exceptionCaught(e);
                        }
                        result2.setClosed();
                    });
                    return result2;
                }
            };
            this.asyncOut = new ChannelAsyncInputStream(this);
            this.asyncErr = this.redirectErrorStream ? this.asyncOut : new ChannelAsyncInputStream(this);
        } else {
            ChannelPipedOutputStream pos;
            ChannelPipedInputStream pis;
            this.invertedIn = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            LocalWindow wLocal = this.getLocalWindow();
            if (this.out == null) {
                pis = new ChannelPipedInputStream(this, wLocal);
                pos = new ChannelPipedOutputStream(pis);
                this.out = pos;
                this.invertedOut = pis;
            }
            if (this.err == null) {
                if (this.redirectErrorStream) {
                    this.err = this.out;
                    this.invertedErr = this.invertedOut;
                } else {
                    pis = new ChannelPipedInputStream(this, wLocal);
                    pos = new ChannelPipedOutputStream(pis);
                    this.err = pos;
                    this.invertedErr = pis;
                }
            }
            if (this.in != null) {
                CloseableExecutorService service = this.getExecutorService();
                this.pumperService = service == null ? ThreadUtils.newSingleThreadExecutor("ClientInputStreamPump[" + Math.abs(System.nanoTime() & 0xFFFFL) + "]") : ThreadUtils.noClose(service);
                this.pumper = this.pumperService.submit(this::pumpInputStream);
            }
        }
    }

    @Override
    protected RequestHandler.Result handleInternalRequest(String req, boolean wantReply, Buffer buffer) throws IOException {
        switch (req) {
            case "xon-xoff": {
                return this.handleXonXoff(buffer, wantReply);
            }
        }
        return super.handleInternalRequest(req, wantReply, buffer);
    }

    protected RequestHandler.Result handleXonXoff(Buffer buffer, boolean wantReply) throws IOException {
        boolean clientCanDo = buffer.getBoolean();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleXonXoff({})[want-reply={}] client-can-do={}", this, wantReply, clientCanDo);
        }
        return RequestHandler.Result.ReplySuccess;
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        if (this.pumper != null && this.pumperService != null && !this.pumperService.isShutdown()) {
            try {
                if (!this.pumper.isDone()) {
                    this.pumper.cancel(true);
                }
                this.pumperService.shutdownNow();
            }
            catch (Exception e) {
                this.warn("doCloseImmediately({}) failed {} to shutdown stream pumper: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            }
            finally {
                this.pumper = null;
                this.pumperService = null;
            }
        }
    }

    protected void pumpInputStream() {
        block6: {
            boolean debugEnabled = this.log.isDebugEnabled();
            try {
                Session session = this.getSession();
                RemoteWindow wRemote = this.getRemoteWindow();
                long packetSize = wRemote.getPacketSize();
                ValidateUtils.checkTrue(packetSize > 0L && packetSize < Integer.MAX_VALUE, "Invalid remote packet size int boundary: %d", packetSize);
                byte[] buffer = new byte[(int)packetSize];
                int maxChunkSize = CoreModuleProperties.INPUT_STREAM_PUMP_CHUNK_SIZE.getRequired(session);
                maxChunkSize = Math.max(maxChunkSize, CoreModuleProperties.INPUT_STREAM_PUMP_CHUNK_SIZE.getRequiredDefault());
                while (!this.closeFuture.isClosed()) {
                    int len = this.securedRead(this.in, maxChunkSize, buffer, 0, buffer.length);
                    if (len < 0) {
                        if (debugEnabled) {
                            this.log.debug("pumpInputStream({}) EOF signalled", (Object)this);
                        }
                        this.sendEof();
                        return;
                    }
                    session.resetIdleTimeout();
                    if (len <= 0) continue;
                    this.invertedIn.write(buffer, 0, len);
                    this.invertedIn.flush();
                }
                if (debugEnabled) {
                    this.log.debug("pumpInputStream({}) close future closed", (Object)this);
                }
            }
            catch (Exception e) {
                if (this.isClosing()) break block6;
                this.error("pumpInputStream({}) Caught {} : {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
                this.close(false);
            }
        }
    }

    protected int securedRead(InputStream in, int maxChunkSize, byte[] buf, int off, int len) throws IOException {
        int availLen;
        int n = 0;
        do {
            int nread;
            if ((nread = in.read(buf, off + n, Math.min(maxChunkSize, len - n))) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while ((availLen = in.available()) > 0);
        return n;
    }

    public Object setEnv(String key, Object value) {
        ValidateUtils.checkNotNull(key, "No key provided");
        if (value == null) {
            return this.env.remove(key);
        }
        return this.env.put(key, value);
    }

    protected void sendEnvVariables(Session session) throws IOException {
        if (MapEntryUtils.size(this.env) > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending env variables ({}) Send SSH_MSG_CHANNEL_REQUEST env: {}", (Object)this, (Object)this.env);
            }
            for (Map.Entry<String, Object> entry : this.env.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                String str = Objects.toString(value);
                Buffer buffer = session.createBuffer((byte)98, key.length() + GenericUtils.length(str) + 32);
                buffer.putInt(this.getRecipient());
                buffer.putString("env");
                buffer.putBoolean(false);
                buffer.putString(key);
                buffer.putString(str);
                this.writePacket(buffer);
            }
        }
    }
}

