/*
 * Decompiled with CFR 0.152.
 */
package config;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import config.WurstProjectConfig;
import config.WurstProjectConfigData;
import file.DependencyManager;
import file.Download;
import file.FileUtilsKt;
import file.YamlHelper;
import file.ZipArchiveExtractor;
import global.InstallationManager;
import global.Log;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.swing.JOptionPane;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.UiManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\"\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020\u0019J\u0010\u0010 \u001a\u0004\u0018\u00010\u00192\u0006\u0010!\u001a\u00020\u0013J\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0016\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010$\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\"\u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010&\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Lconfig/WurstProjectConfig;", "", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "kotlin.jvm.PlatformType", "VSCODE_MIN_CONFIG", "", "log", "Lmu/KLogger;", "schema", "Ljava/net/URL;", "getSchema", "()Ljava/net/URL;", "schema$delegate", "Lkotlin/Lazy;", "cleanupDownload", "", "projectRoot", "Ljava/nio/file/Path;", "createConfigFile", "vsCode", "createProject", "gameRoot", "projectConfig", "Lconfig/WurstProjectConfigData;", "extractDownload", "it", "handleCreate", "handleUpdate", "gamePath", "config", "loadProject", "buildFile", "modifySettingsJson", "saveProjectConfig", "setConfigValues", "setupEnvironment", "setupVSCode", "WurstSetup"})
public final class WurstProjectConfig {
    @NotNull
    public static final WurstProjectConfig INSTANCE = new WurstProjectConfig();
    private static final JsonMapper MAPPER;
    @NotNull
    private static final Lazy schema$delegate;
    @NotNull
    private static final KLogger log;
    @NotNull
    private static final String VSCODE_MIN_CONFIG = "{\"wurst.javaOpts\": [\"-XX:+UseStringDeduplication\", \"-Xmx1G\"],\n\t\"files.associations\": {\n        \"wurst.build\": \"yaml\"\n    },\n\t\"search.useIgnoreFiles\": false }";

    private WurstProjectConfig() {
    }

    private final URL getSchema() {
        Lazy lazy = schema$delegate;
        return (URL)lazy.getValue();
    }

    public final void handleCreate(@NotNull Path projectRoot, @Nullable Path gameRoot, @NotNull WurstProjectConfigData projectConfig) {
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        Intrinsics.checkNotNullParameter(projectConfig, "projectConfig");
        try {
            this.createProject(projectRoot, gameRoot, projectConfig);
            UiManager.INSTANCE.refreshComponents();
        }
        catch (Exception e) {
            Log.INSTANCE.print("\n===ERROR PROJECT CREATE===\n" + e.getMessage() + "\nPlease report here: github.com/wurstscript/WurstScript/issues\n");
        }
    }

    @Nullable
    public final WurstProjectConfigData loadProject(@NotNull Path buildFile) throws IOException {
        Intrinsics.checkNotNullParameter(buildFile, "buildFile");
        Log.INSTANCE.println("Loading project..");
        if (Files.exists(buildFile, new LinkOption[0]) && StringsKt.equals(((Object)buildFile.getFileName()).toString(), "wurst.build", true)) {
            WurstProjectConfigData config = YamlHelper.INSTANCE.loadProjectConfig(buildFile);
            Path projectRoot = buildFile.getParent();
            if (((CharSequence)config.getProjectName()).length() == 0) {
                Path path = projectRoot;
                config.setProjectName(String.valueOf(path != null ? path.getFileName() : null));
                Intrinsics.checkNotNull(projectRoot);
                this.saveProjectConfig(projectRoot, config);
            }
            Log.INSTANCE.print("done\n");
            return config;
        }
        return null;
    }

    private final void createProject(Path projectRoot, Path gameRoot, WurstProjectConfigData projectConfig) throws Exception {
        Log.INSTANCE.print("Creating project root..");
        if (Files.exists(projectRoot, new LinkOption[0]) && Files.list(projectRoot).filter(arg_0 -> WurstProjectConfig.createProject$lambda$0(createProject.1.INSTANCE, arg_0)).findAny().isPresent()) {
            log.error("Project root already exists and contains files");
            Log.INSTANCE.print("\nError: Project root already exists!\n");
        } else {
            Files.createDirectories(projectRoot, new FileAttribute[0]);
            Log.INSTANCE.print("done\n");
            Log.INSTANCE.print("Download template..");
            log.info("\u23ec Downloading template..");
            Download.INSTANCE.downloadBareboneProject((Function1<? super Path, Unit>)new Function1<Path, Unit>(projectRoot, gameRoot, projectConfig){
                final /* synthetic */ Path $projectRoot;
                final /* synthetic */ Path $gameRoot;
                final /* synthetic */ WurstProjectConfigData $projectConfig;
                {
                    this.$projectRoot = $projectRoot;
                    this.$gameRoot = $gameRoot;
                    this.$projectConfig = $projectConfig;
                    super(1);
                }

                public final void invoke(@NotNull Path it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    WurstProjectConfig.access$extractDownload(WurstProjectConfig.INSTANCE, it, this.$projectRoot, this.$gameRoot, this.$projectConfig);
                }
            });
        }
    }

    private final void extractDownload(Path it, Path projectRoot, Path gameRoot, WurstProjectConfigData projectConfig) {
        Log.INSTANCE.println(" done.");
        Log.INSTANCE.print("Extracting template..");
        boolean extractSuccess = ZipArchiveExtractor.INSTANCE.extractArchive(it, projectRoot);
        Files.delete(it);
        if (extractSuccess) {
            Log.INSTANCE.print("done\n");
            this.cleanupDownload(projectRoot);
        } else {
            Log.INSTANCE.print("error\n");
            JOptionPane.showMessageDialog(null, "Error: Cannot extract patch files.\nWurst might still be in use.\nClose any Wurst, VSCode or Eclipse instances before updating.", "Error Massage", 0);
        }
        this.setupEnvironment(projectRoot, gameRoot, projectConfig);
        log.info("\u2714 Project generated.");
        UiManager.INSTANCE.refreshComponents();
    }

    private final void cleanupDownload(Path projectRoot) {
        Log.INSTANCE.print("Clean up..");
        Path folder = projectRoot.resolve("wurst-project-template-master");
        Intrinsics.checkNotNull(folder);
        FileUtilsKt.copyFolder(folder, projectRoot);
        Files.walk(folder, new FileVisitOption[0]).sorted((arg_0, arg_1) -> WurstProjectConfig.cleanupDownload$lambda$1(cleanupDownload.1.INSTANCE, arg_0, arg_1)).forEach(arg_0 -> WurstProjectConfig.cleanupDownload$lambda$2(cleanupDownload.2.INSTANCE, arg_0));
    }

    private final void setupEnvironment(Path projectRoot, Path gameRoot, WurstProjectConfigData projectConfig) {
        Log.INSTANCE.print("done\n");
        this.setupVSCode(projectRoot, gameRoot);
        this.saveProjectConfig(projectRoot, projectConfig);
        DependencyManager.INSTANCE.updateDependencies(projectRoot, projectConfig);
        Log.INSTANCE.print("---\n\n");
        if (gameRoot == null || !Files.exists(gameRoot, new LinkOption[0])) {
            Log.INSTANCE.print("Warning: Your game path has not been set.\n");
        }
        Log.INSTANCE.print("Your project has been successfully created!\nYou can now open your project folder in VSCode.\nOpen the wurst/Hello.wurst package to continue.\n");
    }

    public final void saveProjectConfig(@NotNull Path projectRoot, @NotNull WurstProjectConfigData projectConfig) throws IOException {
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        Intrinsics.checkNotNullParameter(projectConfig, "projectConfig");
        String projectYaml = YamlHelper.INSTANCE.dumpProjectConfig(projectConfig);
        Path path = projectRoot.resolve("wurst.build");
        String string = projectYaml;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    private final void setupVSCode(Path projectRoot, Path gamePath) throws IOException {
        Path wbschema;
        Log.INSTANCE.print("Updating vsconfig..");
        if (projectRoot == null || !Files.exists(projectRoot, new LinkOption[0])) {
            throw new IOException("Project root does not exist!");
        }
        Path vsCode = projectRoot.resolve(".vscode/settings.json");
        Intrinsics.checkNotNull(vsCode);
        this.createConfigFile(vsCode);
        Path it = wbschema = projectRoot.resolve(".vscode/wbschema.json");
        boolean bl = false;
        URL uRL = INSTANCE.getSchema();
        Intrinsics.checkNotNull(uRL);
        Files.write(it, TextStreamsKt.readBytes(uRL), new OpenOption[0]);
        Object object = gamePath;
        if (object == null || (object = object.toAbsolutePath()) == null || (object = object.toString()) == null) {
            object = "";
        }
        this.setConfigValues(vsCode, (String)object);
        Log.INSTANCE.print("done.\n");
    }

    private final void setConfigValues(Path vsCode, String gamePath) {
        OpenOption[] json;
        OpenOption[] openOptionArray = json = this.modifySettingsJson(vsCode, gamePath);
        byte[] byArray = openOptionArray.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        openOptionArray = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING};
        Files.write(vsCode, byArray, openOptionArray);
    }

    private final void createConfigFile(Path vsCode) {
        if (!Files.exists(vsCode, new LinkOption[0])) {
            Files.createDirectories(vsCode.getParent(), new FileAttribute[0]);
            OpenOption[] openOptionArray = "{\"wurst.javaOpts\": [\"-XX:+UseStringDeduplication\", \"-Xmx1G\"],\n\t\"files.associations\": {\n        \"wurst.build\": \"yaml\"\n    },\n\t\"search.useIgnoreFiles\": false }";
            byte[] byArray = openOptionArray.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            openOptionArray = new OpenOption[]{StandardOpenOption.CREATE_NEW};
            Files.write(vsCode, byArray, openOptionArray);
        }
    }

    private final String modifySettingsJson(Path vsCode, String gamePath) {
        byte[] byArray = Files.readAllBytes(vsCode);
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
        byte[] byArray2 = byArray;
        String json = new String(byArray2, Charsets.UTF_8);
        String absolutePath = InstallationManager.INSTANCE.getCompilerPath();
        JsonNode jsonNode = MAPPER.readTree(json);
        Intrinsics.checkNotNull(jsonNode, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode jsonNode2 = (ObjectNode)jsonNode;
        jsonNode2.put("wurst.wurstJar", absolutePath);
        if (!StringsKt.isBlank(gamePath)) {
            jsonNode2.put("wurst.wc3path", gamePath);
        }
        ObjectNode schemaNode = MAPPER.createObjectNode();
        schemaNode.put("./.vscode/wbschema.json", "/wurst.build");
        jsonNode2.replace("yaml.schemas", schemaNode);
        String string = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(jsonNode2);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        return string;
    }

    public final void handleUpdate(@NotNull Path projectRoot, @Nullable Path gamePath, @NotNull WurstProjectConfigData config) {
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        Intrinsics.checkNotNullParameter(config, "config");
        Log.INSTANCE.print("Updating project...\n");
        try {
            this.setupVSCode(projectRoot, gamePath);
            this.saveProjectConfig(projectRoot, config);
            DependencyManager.INSTANCE.updateDependencies(projectRoot, config);
            Log.INSTANCE.print("Project successfully updated!\nReload vscode to apply the changed dependencies.\n");
            UiManager.INSTANCE.refreshComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.INSTANCE.print("\n===ERROR PROJECT UPDATE===\n" + e.getMessage() + "\nPlease report here: github.com/wurstscript/WurstScript/issues\n");
        }
    }

    private static final boolean createProject$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int cleanupDownload$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void cleanupDownload$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$extractDownload(WurstProjectConfig $this, Path it, Path projectRoot, Path gameRoot, WurstProjectConfigData projectConfig) {
        $this.extractDownload(it, projectRoot, gameRoot, projectConfig);
    }

    static {
        JsonReadFeature[] jsonReadFeatureArray = new JsonReadFeature[]{JsonReadFeature.ALLOW_TRAILING_COMMA};
        MAPPER = (JsonMapper)JsonMapper.builder().enable(jsonReadFeatureArray).build();
        schema$delegate = LazyKt.lazy(schema.2.INSTANCE);
        log = KotlinLogging.INSTANCE.logger(log.1.INSTANCE);
    }
}

