/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.simple.registry;

import de.ralleytn.simple.registry.Key;
import de.ralleytn.simple.registry.Value;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public final class Registry {
    public static final String HKEY_CLASSES_ROOT = "HKEY_CLASSES_ROOT";
    public static final String HKEY_CURRENT_USER = "HKEY_CURRENT_USER";
    public static final String HKEY_LOCAL_MASHINE = "HKEY_LOCAL_MASHINE";
    public static final String HKEY_USERS = "HKEY_USERS";
    public static final String HKEY_CURRENT_CONFIG = "HKEY_CURRENT_CONFIG";
    public static final String HKEY_DYN_DATA = "HKEY_DYN_DATA";

    private Registry() {
    }

    public static final void deleteAllValues(String path) throws IOException {
        Registry.exec("reg delete \"" + path + "\" /va /f");
    }

    public static final void deleteDefaultValue(String path) throws IOException {
        Registry.exec("reg delete \"" + path + "\" /ve /f");
    }

    public static final void deleteValue(String path, String name) throws IOException {
        Registry.exec("reg delete \"" + path + "\" /v " + name + " /f");
    }

    public static final void setValue(String path, String name, Value.Type type2, char seperator, String rawValue) throws IOException {
        Registry.exec("reg add \"" + path + "\" /v " + name + " /t " + type2.name() + (type2 == Value.Type.REG_MULTI_SZ ? " /s " + seperator : "") + " /d \"" + rawValue + "\" /f");
    }

    public static final void setDeafultValue(String path, Value.Type type2, char seperator, String rawValue) throws IOException {
        Registry.exec("reg add \"" + path + "\" /ve /t " + type2.name() + (type2 == Value.Type.REG_MULTI_SZ ? " /s " + seperator : "") + " /d \"" + rawValue + "\" /f");
    }

    public static final Value getValue(String path, String name) throws IOException {
        String result2 = Registry.exec("reg query \"" + path + "\" /v " + name);
        for (String line : result2.split("\n")) {
            if (!line.startsWith(" >")) continue;
            String[] valueAttribs = line.substring(2).split("\\|");
            return new Value(valueAttribs[0], Value.Type.getTypeByName(valueAttribs[1]), valueAttribs.length == 2 ? null : valueAttribs[2], path);
        }
        return null;
    }

    public static final void importFile(File file) throws IOException {
        Registry.exec("reg import \"" + file.getAbsolutePath() + "\"");
    }

    public static final void exportKey(String path, File exportFile) throws IOException {
        Registry.exec("reg export \"" + path + "\" \"" + exportFile.getAbsolutePath() + "\" /y");
    }

    public static final void deleteKey(String path) throws IOException {
        Registry.exec("reg delete \"" + path + "\" /f");
    }

    public static final void setKey(String path) throws IOException {
        Registry.exec("reg add \"" + path + "\" /f");
    }

    public static final Key getKey(String path) throws IOException {
        String result2;
        if ((path = path.replace('/', '\\')).endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        String name = null;
        String parent = null;
        if (path.contains("\\")) {
            String[] parts = path.split("\\\\");
            name = parts[parts.length - 1];
            StringBuilder parentPathBuilder = new StringBuilder();
            boolean first = true;
            for (int index = 0; index < parts.length - 1; ++index) {
                if (first) {
                    first = false;
                } else {
                    parentPathBuilder.append('\\');
                }
                parentPathBuilder.append(parts[index]);
                parent = parentPathBuilder.toString();
            }
        } else {
            name = path;
        }
        if ((result2 = Registry.exec("reg query \"" + path + "\"")) != null) {
            String[] valueAttribs;
            ArrayList<String> childs = new ArrayList<String>();
            ArrayList<Value> values2 = new ArrayList<Value>();
            Value defaultValue = null;
            for (String line : result2.split("\n")) {
                if (line.startsWith(" >")) {
                    valueAttribs = line.substring(2).split("\\|");
                    values2.add(new Value(valueAttribs[0], Value.Type.getTypeByName(valueAttribs[1]), valueAttribs.length == 2 ? null : valueAttribs[2], path));
                    continue;
                }
                if (line.equals(path)) continue;
                childs.add(line);
            }
            result2 = Registry.exec("reg query \"" + path + "\" /ve");
            for (String line : result2.split("\n")) {
                if (!line.startsWith(" >")) continue;
                valueAttribs = line.substring(2).split("\\|");
                defaultValue = new Value(valueAttribs[0], Value.Type.getTypeByName(valueAttribs[1]), valueAttribs.length == 2 ? null : valueAttribs[2], path);
            }
            return new Key(path, name, values2, defaultValue, parent, childs);
        }
        return null;
    }

    private static final String exec(String cmd) throws IOException {
        Process process = Runtime.getRuntime().exec("cmd /c " + cmd);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append('\n');
                }
                if (line.startsWith("    ")) {
                    line = " >" + line.substring(4).replace("    ", "|");
                }
                builder.append(line);
            }
        }
        if (process.exitValue() != 0) {
            reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
            var5_5 = null;
            try {
                try {
                    throw new IOException(reader.readLine());
                }
                catch (Throwable throwable) {
                    var5_5 = throwable;
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    if (var5_5 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            var5_5.addSuppressed(throwable2);
                        }
                    } else {
                        reader.close();
                    }
                }
                throw throwable;
            }
        }
        return builder.toString();
    }
}

