/*
 * Decompiled with CFR 0.152.
 */
package workers;

import file.CompileTimeInfo;
import global.InstallationManager;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import mu.KLogger;
import mu.KotlinLogging;
import net.ConnectionManager;
import net.NetStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.SetupUpdateDialog;
import ui.UiManager;
import workers.WurstBuildCheckWorker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lworkers/WurstBuildCheckWorker;", "Ljavax/swing/SwingWorker;", "", "Ljava/lang/Void;", "()V", "log", "Lmu/KLogger;", "doInBackground", "()Ljava/lang/Boolean;", "WurstSetup"})
public final class WurstBuildCheckWorker
extends SwingWorker<Boolean, Void> {
    @NotNull
    private final KLogger log = KotlinLogging.INSTANCE.logger(log.1.INSTANCE);

    @Override
    @Nullable
    protected Boolean doInBackground() throws Exception {
        ConnectionManager.INSTANCE.checkWurstBuild();
        InstallationManager.INSTANCE.verifyInstallation();
        if (ConnectionManager.INSTANCE.getNetStatus() == NetStatus.ONLINE) {
            int latestSetupBuild = ConnectionManager.INSTANCE.getLatestSetupBuild();
            int jenkinsBuildVer = InstallationManager.INSTANCE.getJenkinsBuildVer(CompileTimeInfo.INSTANCE.getVersion());
            this.log.debug("current setup ver: " + jenkinsBuildVer + " latest Setup: " + latestSetupBuild);
            if (latestSetupBuild > jenkinsBuildVer) {
                new SetupUpdateDialog("There is a more recent version of the setup tool available. It is highly recommended to update before making any further changes.");
            }
        }
        UiManager.INSTANCE.refreshComponents();
        return null;
    }
}

