/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.PackInputStream;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;

final class LargePackedWholeObject
extends ObjectLoader {
    private final int type;
    private final long size;
    private final long objectOffset;
    private final int headerLength;
    private final DfsPackFile pack;
    private final DfsObjDatabase db;

    LargePackedWholeObject(int type2, long size, long objectOffset, int headerLength, DfsPackFile pack, DfsObjDatabase db) {
        this.type = type2;
        this.size = size;
        this.objectOffset = objectOffset;
        this.headerLength = headerLength;
        this.pack = pack;
        this.db = db;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isLarge() {
        return true;
    }

    @Override
    public byte[] getCachedBytes() throws LargeObjectException {
        throw new LargeObjectException();
    }

    @Override
    public ObjectStream openStream() throws MissingObjectException, IOException {
        PackInputStream packIn;
        try (DfsReader ctx = this.db.newReader();){
            try {
                packIn = new PackInputStream(this.pack, this.objectOffset + (long)this.headerLength, ctx);
                ctx = null;
            }
            catch (IOException packGone) {
                ObjectId obj = this.pack.getReverseIdx(ctx).findObject(this.objectOffset);
                ObjectStream objectStream = ctx.open(obj, this.type).openStream();
                if (ctx != null) {
                    ctx.close();
                }
                return objectStream;
            }
        }
        int bufsz = 8192;
        BufferedInputStream in = new BufferedInputStream(new InflaterInputStream(packIn, packIn.ctx.inflater(), bufsz), bufsz);
        return new ObjectStream.Filter(this.type, this.size, in);
    }
}

