/*
 * Decompiled with CFR 0.152.
 */
package file;

import config.WurstProjectConfigData;
import file.DependencyManager;
import global.Log;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lfile/DependencyManager;", "", "()V", "log", "Lmu/KLogger;", "cleanRepo", "", "depFolder", "Ljava/nio/file/Path;", "branch", "", "cloneRepo", "", "dependency", "deleteDirectoryStream", "path", "isGitRepoUpToDate", "isUpdateAvailable", "projectRoot", "projectConfig", "Lconfig/WurstProjectConfigData;", "prepareRepo", "git", "Lorg/eclipse/jgit/api/Git;", "resolveName", "Lkotlin/Triple;", "updateDependencies", "updateRepo", "WurstSetup"})
@SourceDebugExtension(value={"SMAP\nDependencyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyManager.kt\nfile/DependencyManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
public final class DependencyManager {
    @NotNull
    public static final DependencyManager INSTANCE = new DependencyManager();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(log.1.INSTANCE);

    private DependencyManager() {
    }

    public final void updateDependencies(@NotNull Path projectRoot, @NotNull WurstProjectConfigData projectConfig) {
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        Intrinsics.checkNotNullParameter(projectConfig, "projectConfig");
        ArrayList<String> depFolders = new ArrayList<String>();
        log.info("\ud83d\udd37 Installing dependencies..");
        Log.INSTANCE.print("Updating dependencies...\n");
        for (String dependency : projectConfig.getDependencies()) {
            Intrinsics.checkNotNull(dependency);
            Triple<String, String, String> triple = this.resolveName(dependency);
            String dependencyName = triple.component2();
            String branch = triple.component3();
            log.info("\t\ud83d\udd39 Pulling <" + dependencyName + ":" + branch + ">");
            Log.INSTANCE.print("Updating dependency - " + dependencyName + " ..");
            Path depFolder = projectRoot.resolve("_build/dependencies/" + dependencyName);
            if (Files.exists(depFolder, new LinkOption[0])) {
                log.debug("depencency exists locally");
                depFolders.add(((Object)depFolder.toAbsolutePath()).toString());
                Intrinsics.checkNotNull(depFolder);
                if (!this.cleanRepo(depFolder, branch)) {
                    this.deleteDirectoryStream(depFolder);
                    this.cloneRepo(dependency, depFolder);
                    continue;
                }
                this.updateRepo(depFolder, branch);
                continue;
            }
            Intrinsics.checkNotNull(depFolder);
            this.cloneRepo(dependency, depFolder);
            depFolders.add(((Object)depFolder.toAbsolutePath()).toString());
        }
        if (!depFolders.isEmpty()) {
            try {
                Files.write(projectRoot.resolve("wurst.dependencies"), (Iterable<? extends CharSequence>)depFolders, Charset.defaultCharset(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("\u2714 Installed dependencies!");
    }

    @NotNull
    public final Triple<String, String, String> resolveName(@NotNull String dependency) {
        Intrinsics.checkNotNullParameter(dependency, "dependency");
        String string = dependency.substring(StringsKt.lastIndexOf$default((CharSequence)dependency, "/", 0, false, 6, null) + 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        String dependencyName = string;
        String branch = "master";
        String depURI = dependency;
        if (StringsKt.contains$default((CharSequence)dependencyName, ":", false, 2, null)) {
            String string2 = depURI.substring(0, StringsKt.lastIndexOf$default((CharSequence)depURI, ":", 0, false, 6, null));
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            depURI = string2;
            String string3 = dependencyName.substring(StringsKt.lastIndexOf$default((CharSequence)dependencyName, ":", 0, false, 6, null) + 1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            branch = string3;
            String string4 = dependencyName.substring(0, StringsKt.lastIndexOf$default((CharSequence)dependencyName, ":", 0, false, 6, null));
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            dependencyName = string4;
        }
        return new Triple<String, String, String>(depURI, dependencyName, branch);
    }

    public final boolean isUpdateAvailable(@NotNull Path projectRoot, @NotNull WurstProjectConfigData projectConfig) {
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        Intrinsics.checkNotNullParameter(projectConfig, "projectConfig");
        Log.INSTANCE.print("Checking dependencies...\n");
        for (String dependency : projectConfig.getDependencies()) {
            String dependencyName;
            Intrinsics.checkNotNull(dependency);
            Intrinsics.checkNotNullExpressionValue(dependency.substring(StringsKt.lastIndexOf$default((CharSequence)dependency, "/", 0, false, 6, null) + 1), "substring(...)");
            Log.INSTANCE.print("Checking dependency - " + dependencyName + " ..");
            Path depFolder = projectRoot.resolve("_build/dependencies/" + dependencyName);
            if (Files.exists(depFolder, new LinkOption[0])) {
                Intrinsics.checkNotNull(depFolder);
                this.isGitRepoUpToDate(depFolder);
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cloneRepo(@NotNull String dependency, @NotNull Path depFolder) {
        Intrinsics.checkNotNullParameter(dependency, "dependency");
        Intrinsics.checkNotNullParameter(depFolder, "depFolder");
        Triple<String, String, String> triple = this.resolveName(dependency);
        String depURI = triple.component1();
        String branch = triple.component3();
        try {
            Files.createDirectories(depFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            Log.INSTANCE.print("error when trying to create directory");
            throw new RuntimeException("Could not create dependency folder", e);
        }
        try {
            AutoCloseable e = Git.cloneRepository().setURI(depURI).setBranch(branch).setDirectory(depFolder.toFile()).call();
            Throwable throwable = null;
            try {
                Git result2 = (Git)e;
                boolean bl = false;
                Log.INSTANCE.print("done\n");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(e, throwable);
            }
        }
        catch (Exception e) {
            Log.INSTANCE.print("error!\n");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateRepo(Path depFolder, String branch) {
        try {
            AutoCloseable autoCloseable = new FileRepository(depFolder.resolve(".git").toFile());
            Throwable throwable = null;
            try {
                FileRepository repository = (FileRepository)autoCloseable;
                boolean bl = false;
                try {
                    AutoCloseable autoCloseable2 = new Git(repository);
                    Throwable throwable2 = null;
                    try {
                        Git git = (Git)autoCloseable2;
                        boolean bl2 = false;
                        PullResult pullResult = git.pull().call();
                        Log.INSTANCE.print("done (success=" + pullResult.isSuccessful() + ")\n");
                        log.debug("Was pull successful?: " + pullResult.isSuccessful());
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                    }
                }
                catch (Exception e) {
                    Log.INSTANCE.print("error when trying to fetch remote\n");
                    e.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
        catch (Exception e) {
            Log.INSTANCE.print("error when trying open repository");
            e.printStackTrace();
        }
    }

    private final void deleteDirectoryStream(Path path) throws IOException {
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(arg_0 -> DependencyManager.deleteDirectoryStream$lambda$3(deleteDirectoryStream.1.INSTANCE, arg_0)).forEach(arg_0 -> DependencyManager.deleteDirectoryStream$lambda$4(deleteDirectoryStream.2.INSTANCE, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean cleanRepo(Path depFolder, String branch) {
        block15: {
            try {
                AutoCloseable autoCloseable = new FileRepository(depFolder.resolve(".git").toFile());
                Throwable throwable = null;
                try {
                    boolean bl;
                    FileRepository repository = (FileRepository)autoCloseable;
                    boolean bl2 = false;
                    AutoCloseable autoCloseable2 = new Git(repository);
                    Throwable throwable2 = null;
                    try {
                        Git git = (Git)autoCloseable2;
                        boolean bl3 = false;
                        git.clean().setCleanDirectories(true).setForce(true).call();
                        git.checkout().setAllPaths(true).call();
                        git.reset().call();
                        log.debug("cleaned repo");
                        bl = INSTANCE.prepareRepo(git, branch);
                    }
                    catch (Throwable throwable3) {
                        try {
                            try {
                                try {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                                    throw throwable4;
                                }
                            }
                            catch (Exception e) {
                                Log.INSTANCE.print("error when trying to clean repository\n");
                                e.printStackTrace();
                                Unit unit = Unit.INSTANCE;
                                AutoCloseableKt.closeFinally(autoCloseable, throwable);
                                break block15;
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throw throwable6;
                        }
                    }
                    AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                    boolean bl4 = bl;
                    return bl4;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
            }
            catch (Exception e) {
                Log.INSTANCE.print("error when trying open repository");
                e.printStackTrace();
            }
        }
        return false;
    }

    private final boolean prepareRepo(Git git, String branch) {
        boolean bl;
        try {
            git.checkout().setCreateBranch(true).setName(branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint("origin/" + branch).call();
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                git.checkout().setName(branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint("origin/" + branch).call();
                bl2 = true;
            }
            catch (Exception e2) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean isGitRepoUpToDate(Path depFolder) {
        try {
            try {
                AutoCloseable autoCloseable = new FileRepository(depFolder.toFile());
                Throwable throwable = null;
                try {
                    FileRepository repository = (FileRepository)autoCloseable;
                    boolean bl = false;
                    try {
                        Throwable throwable2;
                        AutoCloseable autoCloseable2;
                        block20: {
                            autoCloseable2 = new Git(repository);
                            throwable2 = null;
                            Git git = (Git)autoCloseable2;
                            boolean bl2 = false;
                            git.lsRemote().setHeads(true).call();
                            Status status = git.status().call();
                            if (status.hasUncommittedChanges()) {
                                Log.INSTANCE.print("You have modified files in your dependencies folder.");
                                break block20;
                            }
                            if (!status.isClean()) break block20;
                            boolean bl3 = true;
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                            boolean bl4 = bl3;
                            return bl4;
                        }
                        try {
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                    }
                    catch (Exception e) {
                        Log.INSTANCE.print("error when trying to fetch remote\n");
                        e.printStackTrace();
                    }
                    Unit unit = Unit.INSTANCE;
                    return false;
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
            }
            catch (Exception e) {
                Log.INSTANCE.print("error when trying open repository");
                e.printStackTrace();
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static final File deleteDirectoryStream$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (File)$tmp0.invoke(p0);
    }

    private static final void deleteDirectoryStream$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }
}

