/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.GpgSignatureVerifier;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.jgit.util.StringUtils;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static String toString(GpgSignatureVerifier.SignatureVerification verification, PersonIdent creator, GitDateFormatter formatter) {
        StringBuilder result2 = new StringBuilder();
        PersonIdent dateId = new PersonIdent(creator, verification.getCreationDate());
        result2.append(MessageFormat.format(JGitText.get().verifySignatureMade, formatter.formatDate(dateId)));
        result2.append('\n');
        result2.append(MessageFormat.format(JGitText.get().verifySignatureKey, verification.getKeyFingerprint().toUpperCase(Locale.ROOT)));
        result2.append('\n');
        if (!StringUtils.isEmptyOrNull(verification.getSigner())) {
            result2.append(MessageFormat.format(JGitText.get().verifySignatureIssuer, verification.getSigner()));
            result2.append('\n');
        }
        String msg = verification.getVerified() ? (verification.isExpired() ? JGitText.get().verifySignatureExpired : JGitText.get().verifySignatureGood) : JGitText.get().verifySignatureBad;
        result2.append(MessageFormat.format(msg, verification.getKeyUser()));
        if (!GpgSignatureVerifier.TrustLevel.UNKNOWN.equals((Object)verification.getTrustLevel())) {
            result2.append(" " + MessageFormat.format(JGitText.get().verifySignatureTrust, verification.getTrustLevel().name().toLowerCase(Locale.ROOT)));
        }
        result2.append('\n');
        msg = verification.getMessage();
        if (!StringUtils.isEmptyOrNull(msg)) {
            result2.append(msg);
            result2.append('\n');
        }
        return result2.toString();
    }
}

