/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.common.extensions;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.sftp.common.extensions.AbstractParser;

public class FilenameCharsetParser
extends AbstractParser<FilenameCharset> {
    public static final FilenameCharsetParser INSTANCE = new FilenameCharsetParser();

    public FilenameCharsetParser() {
        super("filename-charset");
    }

    @Override
    public FilenameCharset parse(byte[] input, int offset, int len) {
        return this.parse(new String(input, offset, len, StandardCharsets.UTF_8));
    }

    public FilenameCharset parse(String s) {
        return new FilenameCharset(s);
    }

    public static class FilenameCharset
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -4848766176935392024L;
        private String charset;

        public FilenameCharset() {
            this(null);
        }

        public FilenameCharset(String charset) {
            this.charset = charset;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public FilenameCharset clone() {
            try {
                return (FilenameCharset)this.getClass().cast(super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Failed to clone " + this.toString() + ": " + e.getMessage(), e);
            }
        }

        public int hashCode() {
            return GenericUtils.hashCode(this.getCharset(), Boolean.TRUE);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            return GenericUtils.safeCompare(this.getCharset(), ((FilenameCharset)o).getCharset(), false) == 0;
        }

        public String toString() {
            return this.getCharset();
        }
    }
}

