/*
 * Decompiled with CFR 0.152.
 */
package global;

import file.Download;
import file.FileUtilsKt;
import file.SetupApp;
import file.ZipArchiveExtractor;
import global.CLIParser;
import global.InstallationManager;
import global.Log;
import global.WurstConfigData;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import net.ConnectionManager;
import net.NetStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.ErrorDialog;
import ui.MainWindow;
import ui.UiManager;
import workers.ExtractWorker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0006\u0010+\u001a\u00020\u0004J\u000e\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0004J\u0006\u0010.\u001a\u00020'J\u0006\u0010/\u001a\u00020'J\u000e\u00100\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0004J\b\u00101\u001a\u00020'H\u0002J\u0018\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0002J\u0006\u00104\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u000fR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00066"}, d2={"Lglobal/InstallationManager;", "", "()V", "COMPILER_FILE_NAME", "", "FOLDER_PATH", "compilerJar", "Ljava/nio/file/Path;", "getCompilerJar", "()Ljava/nio/file/Path;", "currentCompilerVersion", "", "getCurrentCompilerVersion", "()I", "setCurrentCompilerVersion", "(I)V", "installDir", "getInstallDir", "jenkinsVerPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "latestCompilerVersion", "getLatestCompilerVersion", "setLatestCompilerVersion", "log", "Lmu/KLogger;", "status", "Lglobal/InstallationManager$InstallationStatus;", "getStatus", "()Lglobal/InstallationManager$InstallationStatus;", "setStatus", "(Lglobal/InstallationManager$InstallationStatus;)V", "wurstConfig", "Lglobal/WurstConfigData;", "getWurstConfig", "()Lglobal/WurstConfigData;", "setWurstConfig", "(Lglobal/WurstConfigData;)V", "checkExtraction", "", "isFreshInstall", "", "downloadCompiler", "getCompilerPath", "getJenkinsBuildVer", "version", "handleRemove", "handleUpdate", "isJenkinsBuilt", "setGrillExectuable", "startExtractWorker", "it", "verifyInstallation", "InstallationStatus", "WurstSetup"})
public final class InstallationManager {
    @NotNull
    public static final InstallationManager INSTANCE = new InstallationManager();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(log.1.INSTANCE);
    @NotNull
    private static final String FOLDER_PATH = ".wurst";
    @NotNull
    private static final String COMPILER_FILE_NAME = "wurstscript.jar";
    @NotNull
    private static final Path installDir;
    @NotNull
    private static final Path compilerJar;
    @Nullable
    private static WurstConfigData wurstConfig;
    @NotNull
    private static InstallationStatus status;
    private static int currentCompilerVersion;
    private static int latestCompilerVersion;
    private static final Pattern jenkinsVerPattern;

    private InstallationManager() {
    }

    @NotNull
    public final Path getInstallDir() {
        return installDir;
    }

    @NotNull
    public final Path getCompilerJar() {
        return compilerJar;
    }

    @Nullable
    public final WurstConfigData getWurstConfig() {
        return wurstConfig;
    }

    public final void setWurstConfig(@Nullable WurstConfigData wurstConfigData) {
        wurstConfig = wurstConfigData;
    }

    @NotNull
    public final InstallationStatus getStatus() {
        return status;
    }

    public final void setStatus(@NotNull InstallationStatus installationStatus) {
        Intrinsics.checkNotNullParameter((Object)installationStatus, "<set-?>");
        status = installationStatus;
    }

    public final int getCurrentCompilerVersion() {
        return currentCompilerVersion;
    }

    public final void setCurrentCompilerVersion(int n) {
        currentCompilerVersion = n;
    }

    public final int getLatestCompilerVersion() {
        return latestCompilerVersion;
    }

    public final void setLatestCompilerVersion(int n) {
        latestCompilerVersion = n;
    }

    @NotNull
    public final InstallationStatus verifyInstallation() {
        block8: {
            log.debug("verify Install");
            status = InstallationStatus.NOT_INSTALLED;
            currentCompilerVersion = -1;
            latestCompilerVersion = 0;
            if (Files.exists(installDir, new LinkOption[0]) && Files.exists(compilerJar, new LinkOption[0])) {
                log.debug("Found installation");
                status = InstallationStatus.INSTALLED_UNKNOWN;
                try {
                    if (!Files.isWritable(compilerJar)) {
                        CLIParser.INSTANCE.showWurstInUse();
                        break block8;
                    }
                    CLIParser.INSTANCE.getVersionFomJar();
                }
                catch (Error error) {
                    log.warn("Custom WurstScript installation detected.");
                }
            } else {
                log.info("WurstScript is not currently installed.");
            }
        }
        if (ConnectionManager.INSTANCE.getNetStatus() == NetStatus.ONLINE) {
            log.debug("Client online, check for update");
            latestCompilerVersion = ConnectionManager.INSTANCE.getLatestCompilerBuild();
            log.debug("latest compiler: " + latestCompilerVersion);
            if (currentCompilerVersion >= latestCompilerVersion) {
                status = InstallationStatus.INSTALLED_UPTODATE;
            }
        } else {
            log.debug("Client offline, check for update");
        }
        return status;
    }

    public final void handleUpdate() {
        boolean isFreshInstall = status == InstallationStatus.NOT_INSTALLED;
        try {
            log.debug(isFreshInstall ? "isInstall" : "isUpdate");
            Log.INSTANCE.print(isFreshInstall ? "Installing WurstScript..\n" : "Updating WursScript..\n");
            Log.INSTANCE.print("Downloading compiler..");
            log.info("\u23ec Downloading WurstScript..");
            this.downloadCompiler(isFreshInstall);
        }
        catch (Exception e) {
            log.error("Exception: ", e);
            Log.INSTANCE.print("\n===ERROR COMPILER UPDATE===\n" + e.getMessage() + "\nPlease report here: github.com/wurstscript/WurstScript/issues\n");
        }
    }

    private final void downloadCompiler(boolean isFreshInstall) {
        Download.INSTANCE.downloadCompiler((Function1<? super Path, Unit>)new Function1<Path, Unit>(isFreshInstall){
            final /* synthetic */ boolean $isFreshInstall;
            {
                this.$isFreshInstall = $isFreshInstall;
                super(1);
            }

            public final void invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Log.INSTANCE.print(" done.\n");
                if (SetupApp.INSTANCE.getSetup().isGUILaunch()) {
                    InstallationManager.access$startExtractWorker(InstallationManager.INSTANCE, it, this.$isFreshInstall);
                } else {
                    InstallationManager.access$getLog$p().info("\t\ud83d\udce6 Extracting..");
                    ZipArchiveExtractor.INSTANCE.extractArchive(it, InstallationManager.INSTANCE.getInstallDir());
                    Files.delete(it);
                    InstallationManager.access$setGrillExectuable(InstallationManager.INSTANCE);
                    InstallationManager.access$getLog$p().info("\u2714 Installed WurstScript");
                }
            }
        });
    }

    private final void setGrillExectuable() {
        try {
            installDir.resolve("grill").toFile().setExecutable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void startExtractWorker(Path it, boolean isFreshInstall) {
        new ExtractWorker(it, SetupApp.INSTANCE.getSetup().isGUILaunch() ? MainWindow.INSTANCE.getUi().getProgressBar() : null, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(isFreshInstall){
            final /* synthetic */ boolean $isFreshInstall;
            {
                this.$isFreshInstall = $isFreshInstall;
                super(1);
            }

            public final void invoke(boolean it) {
                if (it) {
                    InstallationManager.access$checkExtraction(InstallationManager.INSTANCE, this.$isFreshInstall);
                } else {
                    Log.INSTANCE.print("error\n");
                    InstallationManager.access$getLog$p().error("error");
                    new ErrorDialog("Could not extract patch files.\nWurst might still be in use.\nMake sure to close VSCode before updating.", false);
                }
                UiManager.INSTANCE.refreshComponents();
            }
        }).execute();
    }

    private final void checkExtraction(boolean isFreshInstall) {
        Log.INSTANCE.print("done\n");
        if (status == InstallationStatus.NOT_INSTALLED) {
            wurstConfig = new WurstConfigData(0L, 1, null);
        }
        if (!Files.exists(compilerJar, new LinkOption[0])) {
            Log.INSTANCE.print("ERROR");
        } else {
            Log.INSTANCE.print(isFreshInstall ? "Installation complete\n" : "Update complete\n");
            log.debug("Installed WurstScript");
            if (SetupApp.INSTANCE.getSetup().isGUILaunch()) {
                SwingUtilities.invokeLater(InstallationManager::checkExtraction$lambda$0);
            }
            this.verifyInstallation();
        }
    }

    public final boolean isJenkinsBuilt(@NotNull String version) {
        Intrinsics.checkNotNullParameter(version, "version");
        return jenkinsVerPattern.matcher(version).matches();
    }

    public final int getJenkinsBuildVer(@NotNull String version) {
        Intrinsics.checkNotNullParameter(version, "version");
        Matcher matcher = jenkinsVerPattern.matcher(version);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            return Integer.parseInt(string);
        }
        return 0;
    }

    public final void handleRemove() {
        FileUtilsKt.clearFolder(installDir);
        this.verifyInstallation();
        log.info("WurstScript has been removed.");
    }

    @NotNull
    public final String getCompilerPath() {
        return ((Object)compilerJar.toAbsolutePath()).toString();
    }

    private static final void checkExtraction$lambda$0() {
        MainWindow.INSTANCE.getUi().getProgressBar().setValue(0);
    }

    public static final /* synthetic */ void access$startExtractWorker(InstallationManager $this, Path it, boolean isFreshInstall) {
        $this.startExtractWorker(it, isFreshInstall);
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ void access$setGrillExectuable(InstallationManager $this) {
        $this.setGrillExectuable();
    }

    public static final /* synthetic */ void access$checkExtraction(InstallationManager $this, boolean isFreshInstall) {
        $this.checkExtraction(isFreshInstall);
    }

    static {
        String[] stringArray = new String[]{FOLDER_PATH};
        Path path = Paths.get(System.getProperty("user.home"), stringArray);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        installDir = path;
        Path path2 = installDir.resolve(COMPILER_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue(path2, "resolve(...)");
        compilerJar = path2;
        status = InstallationStatus.NOT_INSTALLED;
        currentCompilerVersion = -1;
        jenkinsVerPattern = Pattern.compile("(?:\\d\\.){3}\\d(?:-\\w+)+-(\\d+)");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lglobal/InstallationManager$InstallationStatus;", "", "(Ljava/lang/String;I)V", "NOT_INSTALLED", "INSTALLED_UNKNOWN", "INSTALLED_OUTDATED", "INSTALLED_UPTODATE", "WurstSetup"})
    public static final class InstallationStatus
    extends Enum<InstallationStatus> {
        public static final /* enum */ InstallationStatus NOT_INSTALLED = new InstallationStatus();
        public static final /* enum */ InstallationStatus INSTALLED_UNKNOWN = new InstallationStatus();
        public static final /* enum */ InstallationStatus INSTALLED_OUTDATED = new InstallationStatus();
        public static final /* enum */ InstallationStatus INSTALLED_UPTODATE = new InstallationStatus();
        private static final /* synthetic */ InstallationStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static InstallationStatus[] values() {
            return (InstallationStatus[])$VALUES.clone();
        }

        public static InstallationStatus valueOf(String value) {
            return Enum.valueOf(InstallationStatus.class, value);
        }

        @NotNull
        public static EnumEntries<InstallationStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = installationStatusArray = new InstallationStatus[]{InstallationStatus.NOT_INSTALLED, InstallationStatus.INSTALLED_UNKNOWN, InstallationStatus.INSTALLED_OUTDATED, InstallationStatus.INSTALLED_UPTODATE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

