/*
 * Decompiled with CFR 0.152.
 */
package file;

import config.WurstProjectConfig;
import config.WurstProjectConfigData;
import file.CLICommand;
import file.CompileTimeInfo;
import file.DependencyManager;
import file.Download;
import file.SetupApp;
import file.SetupMain;
import global.InstallationManager;
import global.Log;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import net.ConnectionManager;
import net.NetStatus;
import org.eclipse.jgit.api.Git;
import org.jetbrains.annotations.NotNull;
import ui.UiManager;
import ui.UpdateFoundDialog;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u001b\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0014H\u0002J\b\u0010!\u001a\u00020\u0014H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010'\u001a\u00020\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lfile/SetupApp;", "", "()V", "DEFAULT_DIR", "Ljava/nio/file/Path;", "getDEFAULT_DIR", "()Ljava/nio/file/Path;", "REPO_REGEX", "Lkotlin/text/Regex;", "getREPO_REGEX", "()Lkotlin/text/Regex;", "log", "Lmu/KLogger;", "setup", "Lfile/SetupMain;", "getSetup", "()Lfile/SetupMain;", "setSetup", "(Lfile/SetupMain;)V", "buildProject", "", "configData", "Lconfig/WurstProjectConfigData;", "commonArgs", "Ljava/util/ArrayList;", "", "handleArgs", "handleCMD", "handleInstallDep", "handleInstallWurst", "handleRemoveDep", "handleRemoveWurst", "handleRunArgs", "handleUpdateGrill", "handleUpdateProject", "startWurstProcess", "", "args", "testProject", "updateGrillJar", "WurstSetup"})
public final class SetupApp {
    @NotNull
    public static final SetupApp INSTANCE = new SetupApp();
    @NotNull
    private static final Path DEFAULT_DIR;
    @NotNull
    private static final KLogger log;
    public static SetupMain setup;
    @NotNull
    private static final Regex REPO_REGEX;

    private SetupApp() {
    }

    @NotNull
    public final Path getDEFAULT_DIR() {
        return DEFAULT_DIR;
    }

    @NotNull
    public final SetupMain getSetup() {
        SetupMain setupMain = setup;
        if (setupMain != null) {
            return setupMain;
        }
        Intrinsics.throwUninitializedPropertyAccessException("setup");
        return null;
    }

    public final void setSetup(@NotNull SetupMain setupMain) {
        Intrinsics.checkNotNullParameter(setupMain, "<set-?>");
        setup = setupMain;
    }

    public final void handleArgs(@NotNull SetupMain setup) {
        Intrinsics.checkNotNullParameter(setup, "setup");
        this.setSetup(setup);
        this.updateGrillJar();
        if (setup.isGUILaunch()) {
            log.info("\ud83d\uddbc No arguments found. Launching Wurst Setup GUI..");
            if (GraphicsEnvironment.isHeadless()) {
                log.error("\ud83d\udd25 Error: Can't run GUI in headless environment!");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            UiManager.INSTANCE.initUI();
        } else {
            log.info("\ud83d\udd25 Grill warming up..");
            this.handleCMD();
        }
    }

    private final void handleCMD() {
        ConnectionManager.INSTANCE.checkConnectivity("http://google.com");
        ConnectionManager.INSTANCE.checkWurstBuild();
        InstallationManager.INSTANCE.verifyInstallation();
        if (ConnectionManager.INSTANCE.getNetStatus() == NetStatus.ONLINE) {
            int latestSetupBuild = ConnectionManager.INSTANCE.getLatestSetupBuild();
            int jenkinsBuildVer = InstallationManager.INSTANCE.getJenkinsBuildVer(CompileTimeInfo.INSTANCE.getVersion());
            log.debug("current setup ver: " + jenkinsBuildVer + " latest Setup: " + latestSetupBuild);
            if (latestSetupBuild > jenkinsBuildVer) {
                log.info("\ud83d\udd04 Grill update available: " + jenkinsBuildVer + " -> " + latestSetupBuild + ". Run `grill install grill` to update.");
            }
        }
        log.info("\ud83d\udd25 Ready. Version: <{}>", (Object)CompileTimeInfo.INSTANCE.getVersion());
        this.handleRunArgs();
    }

    private final void handleRunArgs() {
        log.debug("handle runargs");
        Path configFile = this.getSetup().getProjectRoot().resolve("wurst.build");
        WurstProjectConfigData configData = null;
        if (Files.exists(configFile, new LinkOption[0])) {
            Intrinsics.checkNotNull(configFile);
            WurstProjectConfigData wurstProjectConfigData = WurstProjectConfig.INSTANCE.loadProject(configFile);
            Intrinsics.checkNotNull(wurstProjectConfigData);
            configData = wurstProjectConfigData;
        } else {
            log.warn("\u26a0\ufe0f No wurst.build configuration file at current location.");
        }
        if (this.getSetup().getCommand() == CLICommand.HELP) {
            log.info("Use one of the following commands: " + ArraysKt.joinToString$default((Object[])CLICommand.values(), (CharSequence)", ", null, null, 0, null, null, 62, null));
        } else if (this.getSetup().getCommand() == CLICommand.INSTALL) {
            if (StringsKt.isBlank(this.getSetup().getCommandArg())) {
                if (configData != null) {
                    this.handleUpdateProject(configData);
                }
            } else {
                String string = this.getSetup().getCommandArg().toLowerCase();
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase()");
                if (Intrinsics.areEqual(string, "wurstscript")) {
                    this.handleInstallWurst();
                } else {
                    String string2 = this.getSetup().getCommandArg().toLowerCase();
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase()");
                    if (Intrinsics.areEqual(string2, "grill")) {
                        this.handleUpdateGrill();
                    } else if (configData != null) {
                        this.handleInstallDep(configData);
                        WurstProjectConfig.INSTANCE.saveProjectConfig(this.getSetup().getProjectRoot(), configData);
                        this.handleUpdateProject(configData);
                    }
                }
            }
        } else if (this.getSetup().getCommand() == CLICommand.REMOVE) {
            String string = this.getSetup().getCommandArg().toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase()");
            if (Intrinsics.areEqual(string, "wurstscript")) {
                this.handleRemoveWurst();
            } else if (configData != null) {
                this.handleRemoveDep(configData);
                WurstProjectConfig.INSTANCE.saveProjectConfig(this.getSetup().getProjectRoot(), configData);
            }
        } else if (this.getSetup().getCommand() == CLICommand.GENERATE) {
            log.info("\u2708 Generating project..");
            if (configData == null) {
                Path path = DEFAULT_DIR.resolve(this.getSetup().getCommandArg());
                Intrinsics.checkNotNullExpressionValue(path, "resolve(...)");
                String[] stringArray = new String[]{"https://github.com/wurstscript/wurstStdlib2"};
                WurstProjectConfig.INSTANCE.handleCreate(path, null, new WurstProjectConfigData(this.getSetup().getCommandArg(), new ArrayList(CollectionsKt.mutableListOf(stringArray)), null, 4, null));
            }
        } else if (this.getSetup().getCommand() == CLICommand.TEST) {
            log.info("\u2697\ufe0f Testing project..");
            if (InstallationManager.INSTANCE.getStatus() != InstallationManager.InstallationStatus.NOT_INSTALLED && configData != null) {
                this.testProject(configData);
            }
        } else if (this.getSetup().getCommand() == CLICommand.BUILD) {
            log.info("\ud83d\udd28 Building project..");
            if (StringsKt.isBlank(this.getSetup().getCommandArg())) {
                log.error("\t\u274c No input map specified.");
            } else if (!Files.exists(this.getSetup().getProjectRoot().resolve(this.getSetup().getCommandArg()), new LinkOption[0])) {
                log.error("\t\u274c Input map cannot be found at project root.");
            } else if (InstallationManager.INSTANCE.getStatus() != InstallationManager.InstallationStatus.NOT_INSTALLED && configData != null) {
                this.buildProject(configData);
            }
        } else if (this.getSetup().getCommand() == CLICommand.SELF_UPDATE) {
            log.info("\ud83d\udd04 Updating..");
            try {
                log.info("\u2714 Updated succeeded.");
                if (this.getSetup().isGUILaunch()) {
                    String[] stringArray = new String[]{"java", "-jar", ((Object)InstallationManager.INSTANCE.getInstallDir()).toString()};
                    Runtime.getRuntime().exec(stringArray);
                }
                System.exit(0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (Exception e) {
                log.error("Grill update failed. Original files might still be in use.");
            }
        }
    }

    private final void handleUpdateGrill() {
        Download.INSTANCE.downloadSetup(handleUpdateGrill.1.INSTANCE);
    }

    private final void buildProject(WurstProjectConfigData configData) {
        ArrayList<String> args2 = this.commonArgs(configData);
        args2.add("-build");
        if (this.getSetup().getMeasure()) {
            args2.add("-measure");
        }
        args2.add("-workspaceroot");
        args2.add(((Object)this.getSetup().getProjectRoot().toAbsolutePath()).toString());
        args2.add("-inputmap");
        args2.add(((Object)this.getSetup().getProjectRoot().resolve(this.getSetup().getCommandArg()).toAbsolutePath()).toString());
        int result2 = this.startWurstProcess(args2);
        if (result2 != 0) {
            log.info("\u274c There was an issue with the wurst build process.");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        log.info("\ud83d\uddfa\ufe0f Map has been built!");
    }

    private final void testProject(WurstProjectConfigData configData) {
        ArrayList<String> args2 = this.commonArgs(configData);
        args2.add("-runtests");
        int result2 = this.startWurstProcess(args2);
        if (result2 != 0) {
            log.info("\u274c Tests did not execute successfully.");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        log.info("\u2714 All tests succeeded.");
    }

    private final int startWurstProcess(ArrayList<String> args2) {
        ProcessBuilder pb = new ProcessBuilder((List<String>)args2);
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        return p.waitFor();
    }

    private final ArrayList<String> commonArgs(WurstProjectConfigData configData) {
        String[] stringArray = new String[]{"java", "-jar", ((Object)InstallationManager.INSTANCE.getInstallDir().resolve("wurstscript.jar").toAbsolutePath()).toString()};
        ArrayList<String> args2 = CollectionsKt.arrayListOf(stringArray);
        Path buildFolder = this.getSetup().getProjectRoot().resolve("_build");
        Path jassdoc = buildFolder.resolve("dependencies").resolve("jassdoc");
        if (Files.exists(jassdoc, new LinkOption[0])) {
            File[] fileArray = jassdoc.toFile().listFiles();
            Intrinsics.checkNotNull(fileArray);
            for (File f : fileArray) {
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                if (!StringsKt.endsWith$default(string, ".j", false, 2, null)) continue;
                String string2 = f.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                if (StringsKt.startsWith$default(string2, "builtin-types", false, 2, null)) continue;
                args2.add(f.getAbsolutePath().toString());
            }
        } else {
            Path common = Files.exists(buildFolder.resolve("common.j"), new LinkOption[0]) ? buildFolder.resolve("common.j") : InstallationManager.INSTANCE.getInstallDir().resolve("common.j");
            Path blizzard = Files.exists(buildFolder.resolve("blizzard.j"), new LinkOption[0]) ? buildFolder.resolve("blizzard.j") : InstallationManager.INSTANCE.getInstallDir().resolve("blizzard.j");
            args2.add(((Object)common.toAbsolutePath()).toString());
            args2.add(((Object)blizzard.toAbsolutePath()).toString());
        }
        args2.add(((Object)this.getSetup().getProjectRoot().resolve("wurst").toAbsolutePath()).toString());
        args2.add("-runcompiletimefunctions");
        if (this.getSetup().getNoPJass()) {
            args2.add("-noPJass");
        }
        configData.getDependencies().stream().forEach(arg_0 -> SetupApp.commonArgs$lambda$0(new Function1<String, Unit>(args2, buildFolder){
            final /* synthetic */ ArrayList<String> $args;
            final /* synthetic */ Path $buildFolder;
            {
                this.$args = $args;
                this.$buildFolder = $buildFolder;
                super(1);
            }

            public final void invoke(String it) {
                this.$args.add("-lib");
                Intrinsics.checkNotNull(it);
                String dependencyName = DependencyManager.INSTANCE.resolveName(it).component2();
                this.$args.add(((Object)this.$buildFolder.resolve("dependencies").resolve(dependencyName).toAbsolutePath()).toString());
            }
        }, arg_0));
        return args2;
    }

    private final void handleRemoveDep(WurstProjectConfigData configData) {
        log.error("removing " + this.getSetup().getCommandArg());
        if (configData.getDependencies().contains(this.getSetup().getCommandArg())) {
            configData.getDependencies().remove(this.getSetup().getCommandArg());
        } else {
            log.error("dependency does not exist in project");
        }
    }

    private final void handleRemoveWurst() {
        if (!this.getSetup().getRequireConfirmation()) {
            InstallationManager.INSTANCE.handleRemove();
        }
    }

    private final void handleUpdateProject(WurstProjectConfigData configData) {
        WurstProjectConfig.INSTANCE.handleUpdate(this.getSetup().getProjectRoot(), null, configData);
    }

    @NotNull
    public final Regex getREPO_REGEX() {
        return REPO_REGEX;
    }

    private final void handleInstallDep(WurstProjectConfigData configData) {
        Triple<String, String, String> resolvedName = DependencyManager.INSTANCE.resolveName(this.getSetup().getCommandArg());
        if (!REPO_REGEX.matches(resolvedName.getFirst())) {
            log.info("<" + this.getSetup().getCommandArg() + "> does not appear to be a valid git repo link (e.g. https://github.com/user/repo)");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        log.info("\ud83d\udd39 Installing " + resolvedName.getSecond());
        if (configData.getDependencies().contains(this.getSetup().getCommandArg())) {
            log.info("Dependency is already installed.");
            return;
        }
        try {
            Object result2 = Git.lsRemoteRepository().setRemote(resolvedName.getFirst()).call();
            if (!result2.isEmpty()) {
                Log.INSTANCE.print("valid!\n");
                configData.getDependencies().add(this.getSetup().getCommandArg());
            } else {
                log.error("Entered invalid git repo.");
            }
        }
        catch (Exception e) {
            log.error("Entered invalid git repo.");
            e.printStackTrace();
        }
    }

    private final void handleInstallWurst() {
        log.info("\ud83c\udf2d Installing WurstScript..");
        if (InstallationManager.INSTANCE.getStatus() != InstallationManager.InstallationStatus.INSTALLED_UPTODATE) {
            log.info("\tUpdate available!");
            if (this.getSetup().getRequireConfirmation()) {
                if (this.getSetup().isGUILaunch()) {
                    new UpdateFoundDialog("A Wurst compiler update has been found!");
                } else {
                    log.info("Do you want to update your wurst installation? (y/n)");
                    Scanner sc = new Scanner(System.in);
                    String line = sc.nextLine();
                    if (Intrinsics.areEqual(line, "y")) {
                        InstallationManager.INSTANCE.handleUpdate();
                    }
                }
            } else {
                InstallationManager.INSTANCE.handleUpdate();
            }
        } else {
            log.info("Already up to date.");
        }
    }

    private final void updateGrillJar() {
        Path path;
        Object[] objectArray;
        URL url = InstallationManager.class.getProtectionDomain().getCodeSource().getLocation();
        Path ownFile = Paths.get(url.toURI());
        if (ownFile.endsWith(".2.jar")) {
            log.debug("copy jar from own");
            objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(ownFile, ownFile.resolveSibling("WurstSetup.jar"), (CopyOption[])objectArray);
        }
        log.debug("path: " + url);
        log.debug("file: " + ownFile.toAbsolutePath());
        if (Files.exists(ownFile, new LinkOption[0]) && (ownFile.getParent() == null || !Intrinsics.areEqual((path = ownFile.getParent()) != null && (path = path.getFileName()) != null ? ((Object)path).toString() : null, ".wurst"))) {
            log.debug("copy jar");
            objectArray = new String[]{"WurstSetup.jar"};
            Path path2 = Paths.get(((Object)InstallationManager.INSTANCE.getInstallDir()).toString(), (String[])objectArray);
            objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(ownFile, path2, (CopyOption[])objectArray);
        }
    }

    private static final void commonArgs$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }

    static {
        Path path = Paths.get(".", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        DEFAULT_DIR = path;
        log = KotlinLogging.INSTANCE.logger(log.1.INSTANCE);
        REPO_REGEX = new Regex("((git@|http(s)?://)([\\w.@]+)([/:]))([\\w,\\-,_]+)/([\\w,\\-,_]+)(.git)?((/)?)");
    }
}

