/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface Property<T>
extends NamedResource {
    public static Property<String> string(String name) {
        return Property.string(name, null);
    }

    public static Property<String> string(String name, String def) {
        return new StringProperty(name, def);
    }

    public static Property<Boolean> bool(String name) {
        return new BooleanProperty(name);
    }

    public static Property<Boolean> bool(String name, boolean def) {
        return new BooleanProperty(name, def);
    }

    public static Property<Integer> integer(String name) {
        return new IntegerProperty(name);
    }

    public static Property<Integer> integer(String name, int def) {
        return new IntegerProperty(name, def);
    }

    public static Property<Long> long_(String name) {
        return new LongProperty(name);
    }

    public static Property<Long> long_(String name, long def) {
        return new LongProperty(name, def);
    }

    public static <T extends Enum<T>> Property<T> enum_(String name, Class<T> type2) {
        return Property.enum_(name, type2, null);
    }

    public static <T extends Enum<T>> Property<T> enum_(String name, Class<T> type2, T def) {
        return new EnumProperty<T>(name, type2, def);
    }

    public static Property<Duration> duration(String name) {
        return Property.duration(name, null);
    }

    public static Property<Duration> duration(String name, Duration def) {
        return new DurationProperty(name, def);
    }

    public static Property<Duration> duration(String name, Duration def, Duration min) {
        return new DurationProperty(name, def, min);
    }

    public static Property<Duration> durationSec(String name) {
        return Property.durationSec(name, null);
    }

    public static Property<Duration> durationSec(String name, Duration def) {
        return new DurationInSecondsProperty(name, def);
    }

    public static Property<Duration> durationSec(String name, Duration def, Duration min) {
        return new DurationInSecondsProperty(name, def, min);
    }

    public static Property<Charset> charset(String name) {
        return Property.charset(name, null);
    }

    public static Property<Charset> charset(String name, Charset def) {
        return new CharsetProperty(name, def);
    }

    public static Property<Object> object(String name) {
        return Property.object(name, null);
    }

    public static Property<Object> object(String name, Object def) {
        return new ObjectProperty(name, def);
    }

    public static <T> Property<T> validating(Property<T> prop, Consumer<? super T> validator) {
        return new Validating<T>(prop, validator);
    }

    public Class<T> getType();

    public Optional<T> getDefault();

    default public T getRequiredDefault() {
        return this.getDefault().get();
    }

    public Optional<T> get(PropertyResolver var1);

    default public T getRequired(PropertyResolver resolver) {
        return this.get(resolver).get();
    }

    default public T getOrNull(PropertyResolver resolver) {
        return this.getOrCustomDefault(resolver, null);
    }

    public T getOrCustomDefault(PropertyResolver var1, T var2);

    public void set(PropertyResolver var1, T var2);

    default public void remove(PropertyResolver resolver) {
        PropertyResolverUtils.updateProperty(resolver, this.getName(), null);
    }

    public static class StringProperty
    extends BaseProperty<String> {
        public StringProperty(String name) {
            this(name, (String)null);
        }

        public StringProperty(String name, String def) {
            super(name, String.class, def);
        }

        @Override
        protected String fromStorage(Object value) {
            return value != null ? value.toString() : null;
        }
    }

    public static class BooleanProperty
    extends BaseProperty<Boolean> {
        public BooleanProperty(String name) {
            this(name, (Boolean)null);
        }

        public BooleanProperty(String name, Boolean defaultValue) {
            super(name, Boolean.class, defaultValue);
        }

        @Override
        protected Boolean fromStorage(Object value) {
            return PropertyResolverUtils.toBoolean(value);
        }
    }

    public static class IntegerProperty
    extends BaseProperty<Integer> {
        public IntegerProperty(String name) {
            this(name, (Integer)null);
        }

        public IntegerProperty(String name, Integer defaultValue) {
            super(name, Integer.class, defaultValue);
        }

        @Override
        protected Integer fromStorage(Object value) {
            return PropertyResolverUtils.toInteger(value);
        }
    }

    public static class LongProperty
    extends BaseProperty<Long> {
        public LongProperty(String name) {
            this(name, (Long)null);
        }

        public LongProperty(String name, Long defaultValue) {
            super(name, Long.class, defaultValue);
        }

        @Override
        protected Long fromStorage(Object value) {
            return PropertyResolverUtils.toLong(value);
        }
    }

    public static class EnumProperty<T extends Enum<T>>
    extends BaseProperty<T> {
        protected final Collection<T> values;

        public EnumProperty(String name, Class<T> type2) {
            this(name, type2, null);
        }

        public EnumProperty(String name, Class<T> type2, T def) {
            super(name, type2, def);
            this.values = Collections.unmodifiableSet(EnumSet.allOf(type2));
        }

        @Override
        protected T fromStorage(Object value) {
            Class type2 = this.getType();
            return PropertyResolverUtils.toEnum(type2, value, false, this.values);
        }
    }

    public static class DurationProperty
    extends BaseProperty<Duration> {
        protected final Duration min;

        public DurationProperty(String name) {
            this(name, (Duration)null);
        }

        public DurationProperty(String name, Duration def) {
            super(name, Duration.class, def);
            this.min = null;
        }

        public DurationProperty(String name, Duration def, Duration min) {
            super(name, Duration.class, DurationProperty.atLeast(name, def, min));
            this.min = min;
        }

        @Override
        protected Object toStorage(Duration value) {
            DurationProperty.atLeast(this.getName(), value, this.min);
            return value != null ? Long.valueOf(value.toMillis()) : null;
        }

        @Override
        protected Duration fromStorage(Object value) {
            Long val = PropertyResolverUtils.toLong(value);
            return val != null ? Duration.ofMillis(val) : null;
        }

        private static Long toMillis(Duration value) {
            return value == null ? null : Long.valueOf(value.toMillis());
        }

        protected static Duration atLeast(String name, Duration value, Duration min) {
            if (min != null) {
                ValidateUtils.checkTrue(value != null && min.compareTo(value) <= 0, "Property %s must be at least %d ms; actual value: %d ms", name, DurationProperty.toMillis(min), DurationProperty.toMillis(value));
            }
            return value;
        }
    }

    public static class DurationInSecondsProperty
    extends DurationProperty {
        public DurationInSecondsProperty(String name) {
            this(name, (Duration)null);
        }

        public DurationInSecondsProperty(String name, Duration def) {
            super(name, def);
        }

        public DurationInSecondsProperty(String name, Duration def, Duration min) {
            super(name, def, min);
        }

        @Override
        protected Object toStorage(Duration value) {
            DurationInSecondsProperty.atLeast(this.getName(), value, this.min);
            return value != null ? Long.valueOf(value.getSeconds()) : null;
        }

        @Override
        protected Duration fromStorage(Object value) {
            Long val = PropertyResolverUtils.toLong(value);
            return val != null ? Duration.ofSeconds(val) : null;
        }
    }

    public static class CharsetProperty
    extends BaseProperty<Charset> {
        public CharsetProperty(String name) {
            this(name, (Charset)null);
        }

        public CharsetProperty(String name, Charset defaultValue) {
            super(name, Charset.class, defaultValue);
        }

        @Override
        protected Charset fromStorage(Object value) {
            return PropertyResolverUtils.toCharset(value);
        }
    }

    public static class ObjectProperty
    extends BaseProperty<Object> {
        public ObjectProperty(String name) {
            this(name, (Object)null);
        }

        public ObjectProperty(String name, Object defaultValue) {
            super(name, Object.class, defaultValue);
        }

        @Override
        protected Object fromStorage(Object value) {
            return value;
        }
    }

    public static class Validating<T>
    implements Property<T> {
        protected final Property<T> delegate;
        protected final Consumer<? super T> validator;

        public Validating(Property<T> delegate, Consumer<? super T> validator) {
            this.delegate = delegate;
            this.validator = validator;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Class<T> getType() {
            return this.delegate.getType();
        }

        @Override
        public Optional<T> getDefault() {
            return this.delegate.getDefault();
        }

        @Override
        public T getRequiredDefault() {
            return this.delegate.getRequiredDefault();
        }

        @Override
        public Optional<T> get(PropertyResolver resolver) {
            Optional<? super T> t = this.delegate.get(resolver);
            t.ifPresent(this.validator);
            return t;
        }

        @Override
        public T getOrCustomDefault(PropertyResolver resolver, T defaultValue) {
            T value = this.delegate.getOrCustomDefault(resolver, defaultValue);
            this.validator.accept(value);
            return value;
        }

        @Override
        public void set(PropertyResolver resolver, T value) {
            this.validator.accept(value);
            this.delegate.set(resolver, value);
        }

        @Override
        public void remove(PropertyResolver resolver) {
            this.delegate.remove(resolver);
        }
    }

    public static abstract class BaseProperty<T>
    implements Property<T> {
        private final String name;
        private final Class<T> type;
        private final Optional<T> defaultValue;

        protected BaseProperty(String name, Class<T> type2) {
            this(name, type2, null);
        }

        protected BaseProperty(String name, Class<T> type2, T defaultValue) {
            this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No name provided");
            this.type = Objects.requireNonNull(type2, "Type must be provided");
            this.defaultValue = Optional.ofNullable(defaultValue);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public Optional<T> getDefault() {
            return this.defaultValue;
        }

        @Override
        public Optional<T> get(PropertyResolver resolver) {
            Object propValue = PropertyResolverUtils.resolvePropertyValue(resolver, this.getName());
            return propValue != null ? Optional.of(this.fromStorage(propValue)) : this.getDefault();
        }

        @Override
        public T getOrCustomDefault(PropertyResolver resolver, T defaultValue) {
            Object propValue = PropertyResolverUtils.resolvePropertyValue(resolver, this.getName());
            return propValue != null ? this.fromStorage(propValue) : defaultValue;
        }

        @Override
        public void set(PropertyResolver resolver, T value) {
            PropertyResolverUtils.updateProperty(resolver, this.getName(), this.toStorage(value));
        }

        protected Object toStorage(T value) {
            return value;
        }

        protected abstract T fromStorage(Object var1);

        public String toString() {
            return "Property[" + this.getName() + "](" + this.getType().getSimpleName() + "]";
        }
    }
}

