/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.peeeq.immutablecollections.ImmutableList;
import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.ModuleInstanciations;
import de.peeeq.wurstscript.ast.ModuleUse;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ModuleExpander {
    private ModuleExpander() {
    }

    public static void expandModules(CompilationUnit cu) {
        for (WPackage t : cu.getPackages()) {
            ModuleExpander.expandModules(t);
        }
    }

    private static void expandModules(WPackage p) {
        for (WEntity e : p.getElements()) {
            if (!(e instanceof ClassOrModule)) continue;
            ModuleExpander.expandModules((ClassOrModule)e);
        }
    }

    public static ModuleInstanciations expandModules(ClassOrModule m) {
        return ModuleExpander.expandModules(m, new ArrayList<ClassOrModule>());
    }

    private static ModuleInstanciations expandModules(ClassOrModule m, List<ClassOrModule> visited) {
        if (m.getP_moduleInstanciations().size() > 0 || m.getModuleUses().isEmpty()) {
            return m.getP_moduleInstanciations();
        }
        Preconditions.checkNotNull((Object)m);
        if (visited.contains(m)) {
            throw new CompileError(m.getSource(), "Cyclic module dependencies: " + visited.stream().map(ClassOrModule::getName).sorted().collect(Collectors.joining(", ")));
        }
        visited.add(m);
        for (ModuleUse moduleUse : m.getModuleUses()) {
            ModuleDef usedModule = moduleUse.attrModuleDef();
            if (usedModule == null) {
                moduleUse.addError("not found");
                continue;
            }
            ModuleInstanciations usedModuleInst = ModuleExpander.expandModules(usedModule, visited);
            int numTypeArgs = moduleUse.getTypeArgs().size();
            if (numTypeArgs < usedModule.getTypeParameters().size()) {
                moduleUse.addError("Missing type arguments for module " + moduleUse.getModuleName() + ".");
            } else if (numTypeArgs > usedModule.getTypeParameters().size()) {
                moduleUse.addError("Too many type arguments for module " + moduleUse.getModuleName() + ".");
            }
            ArrayList typeReplacements = Lists.newArrayList();
            for (int i = 0; i < numTypeArgs; ++i) {
                typeReplacements.add(Pair.create(((TypeParamDef)usedModule.getTypeParameters().get(i)).attrTyp(), ((TypeExpr)moduleUse.getTypeArgs().get(i)).attrTyp()));
            }
            WPos source = moduleUse.getSource().artificial();
            WPos idSource = moduleUse.getModuleNameId().getSource().artificial();
            ModuleInstanciation mi = Ast.ModuleInstanciation(source, Ast.Modifiers(new Modifier[0]), Ast.Identifier(idSource, usedModule.getName()), ModuleExpander.smartCopy(usedModule.getInnerClasses(), typeReplacements), ModuleExpander.smartCopy(usedModule.getMethods(), typeReplacements), ModuleExpander.smartCopy(usedModule.getVars(), typeReplacements), ModuleExpander.smartCopy(usedModule.getConstructors(), typeReplacements), ModuleExpander.smartCopy(usedModuleInst, typeReplacements), ModuleExpander.smartCopy(usedModule.getModuleUses(), typeReplacements), ModuleExpander.smartCopy(usedModule.getOnDestroy(), typeReplacements));
            if (mi.getConstructors().isEmpty()) {
                mi.getConstructors().add(Ast.ConstructorDef(source, Ast.Modifiers(new Modifier[0]), Ast.WParameters(new WParameter[0]), Ast.NoSuperConstructorCall(), Ast.WStatements(Ast.StartFunctionStatement(source), Ast.EndFunctionStatement(source))));
            }
            m.getP_moduleInstanciations().add(mi);
        }
        return m.getP_moduleInstanciations();
    }

    public static ModuleInstanciations expandModules(ModuleInstanciation mi) {
        return mi.getP_moduleInstanciations();
    }

    public static <T extends Element> T smartCopy(T e, List<Pair<WurstType, WurstType>> typeReplacements) {
        ArrayList replacementsByPath = Lists.newArrayList();
        ModuleExpander.calcReplacementsByPath(typeReplacements, replacementsByPath, e, ImmutableList.emptyList());
        Element copy = e.copy();
        for (Pair rep : replacementsByPath) {
            ModuleExpander.doReplacement(copy, (ImmutableList)rep.getA(), ((TypeExpr)rep.getB()).copy());
        }
        Element t = copy;
        return (T)t;
    }

    private static void doReplacement(Element e, ImmutableList<Integer> a, TypeExpr newTypeExpr) {
        if (a.size() == 1) {
            e.set(a.head(), newTypeExpr);
        } else if (a.size() > 1) {
            ModuleExpander.doReplacement(e.get(a.head()), a.tail(), newTypeExpr);
        }
    }

    private static void calcReplacementsByPath(List<Pair<WurstType, WurstType>> typeReplacements, List<Pair<ImmutableList<Integer>, TypeExpr>> replacementsByPath, Element e, ImmutableList<Integer> pos) {
        if (e instanceof TypeExpr) {
            TypeExpr typeExpr = (TypeExpr)e;
            for (Pair<WurstType, WurstType> rep : typeReplacements) {
                if (!typeExpr.attrTyp().equalsType(rep.getA(), e)) continue;
                WPos source = typeExpr.getSource();
                replacementsByPath.add(Pair.create(pos, Ast.TypeExprResolved(source, rep.getB())));
            }
        }
        for (int i = 0; i < e.size(); ++i) {
            ModuleExpander.calcReplacementsByPath(typeReplacements, replacementsByPath, e.get(i), pos.appBack(i));
        }
    }
}

