/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtojass;

import com.google.common.collect.Lists;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstArray;
import de.peeeq.wurstscript.intermediatelang.ILconstBool;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;
import de.peeeq.wurstscript.intermediatelang.ILconstNull;
import de.peeeq.wurstscript.intermediatelang.ILconstReal;
import de.peeeq.wurstscript.intermediatelang.ILconstTuple;
import de.peeeq.wurstscript.intermediatelang.ILconstUnsafeDefault;
import de.peeeq.wurstscript.jassIm.ImAnyType;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeVarRef;
import de.peeeq.wurstscript.jassIm.ImVoid;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class DefaultValue {
    public static ILconst get(ImArrayType t) {
        return t.getEntryType().defaultValue();
    }

    public static ILconst get(ImSimpleType t) {
        String typename = t.getTypename();
        if (typename.equals("string")) {
            return ILconstNull.instance();
        }
        if (typename.equals("integer")) {
            return new ILconstInt(0);
        }
        if (typename.equals("real")) {
            return new ILconstReal(0.0);
        }
        if (typename.equals("boolean")) {
            return ILconstBool.FALSE;
        }
        WLogger.info("could not get default value for " + typename);
        return ILconstNull.instance();
    }

    public static ILconst get(ImTupleType tt) {
        ArrayList values = Lists.newArrayList();
        for (ImType t : tt.getTypes()) {
            values.add(t.defaultValue());
        }
        return new ILconstTuple(values.toArray(new ILconst[0]));
    }

    public static ILconst get(ImVoid t) {
        throw new Error("Could not get default value for void variable.");
    }

    public static ILconst get(ImArrayTypeMulti t) {
        List<Integer> sizes = t.getArraySize();
        return new ILconstArray(sizes.get(0), DefaultValue.makeSupplier(sizes.size() - 1, t.getEntryType()));
    }

    private static Supplier<ILconst> makeSupplier(int depth, ImType entryType) {
        if (depth <= 1) {
            return entryType::defaultValue;
        }
        return () -> new ILconstArray(Integer.MAX_VALUE, DefaultValue.makeSupplier(depth - 1, entryType));
    }

    public static ILconst get(ImTypeVarRef e) {
        return new ILconstUnsafeDefault(e.getTypeVariable());
    }

    public static ILconst get(ImClassType ct) {
        return new ILconstInt(0);
    }

    public static ILconst get(ImAnyType imAnyType) {
        return ILconstNull.instance();
    }
}

